/*
 * Decompiled with CFR 0.152.
 */
package jarxplorer.model;

import jarxplorer.model.MethodNode;
import jarxplorer.model.MyTreeNode;
import jarxplorer.model.Utilities;
import jarxplorer.parser.MyMethod;
import jarxplorer.parser.Parser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class MethodNodeLabel
implements MyTreeNode {
    private String label;
    private String className;
    private Parser myParser;
    private MyMethod[] methods;

    public MethodNodeLabel(String string, String string2) {
        this.label = string;
        String string3 = Utilities.formatClassPathDir(string2);
        String string4 = Utilities.getJarPath();
        try {
            this.myParser = new Parser(Utilities.getJarPath(), string3);
            this.methods = this.myParser.getMethods();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    public Object getChild(Object object, int n) {
        Arrays.sort(this.methods, new Comparator<MyMethod>(){

            @Override
            public int compare(MyMethod myMethod, MyMethod myMethod2) {
                String string = myMethod.getName();
                String string2 = myMethod2.getName();
                return string.compareTo(string2);
            }
        });
        return new MethodNode(this.methods[n]);
    }

    public int getChildCount(Object object) {
        return this.methods.length;
    }

    public boolean isLeaf(Object object) {
        return this.methods.length == 0;
    }

    public int getIndexOfChild(Object object, Object object2) {
        MethodNodeLabel methodNodeLabel = (MethodNodeLabel)object;
        MethodNode methodNode = (MethodNode)object2;
        ArrayList<MyMethod> arrayList = new ArrayList<MyMethod>(Arrays.asList(methodNodeLabel.methods));
        return arrayList.indexOf(methodNode.getMethod());
    }

    public String getType() {
        return "MethodNodeLabel";
    }

    public String toString() {
        return this.label;
    }
}

