/*
 * Decompiled with CFR 0.152.
 */
package cpusim;

import cpusim.Field;
import cpusim.FieldValue;
import cpusim.Machine;
import cpusim.util.Factory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;

public class FieldFactory
implements Factory {
    private Machine machine;
    private Field[] clones;
    private Field prototype;
    private HashMap<Field, Field> assocList;

    public FieldFactory(Machine m) {
        this.machine = m;
        this.prototype = new Field();
        this.assocList = new HashMap();
        this.clones = this.createClones();
    }

    @Override
    public Object getNewObject(String name) {
        Field clone = this.prototype.clone();
        clone.setName(name);
        return clone;
    }

    public Field[] getClones() {
        return this.clones;
    }

    public Field[] createClones() {
        List<Field> fields = this.machine.getFields();
        Field[] clones = new Field[fields.size()];
        for (int i = 0; i < clones.length; ++i) {
            clones[i] = fields.get(i).clone();
            this.assocList.put(clones[i], fields.get(i));
        }
        return clones;
    }

    public Field getCurrentFromClone(Field clone) {
        return this.assocList.get(clone);
    }

    @Override
    public String getHelpPageID() {
        return "fieldsDialog";
    }

    @Override
    public void displayError(String e) {
        JOptionPane.showMessageDialog(null, e, "Error", 0);
    }

    @Override
    public boolean checkValidity(Object[] fieldList) {
        Field[] fields = new Field[fieldList.length];
        for (int i = 0; i < fieldList.length; ++i) {
            fields[i] = (Field)fieldList[i];
        }
        for (Field field : fields) {
            int defaultValue;
            int numBits = field.getNumBits();
            Field.Type type = field.getType();
            if (numBits == 0 && type == Field.Type.ignored) {
                this.displayError("Field " + field.getName() + " has 0 bits" + " and type \"ignored\".\nA 0-bit field must" + " have one of the other types.");
            }
            if (type != Field.Type.required && ((double)(defaultValue = field.getDefaultValue()) < Math.pow(2.0, numBits) * -1.0 / 2.0 || (double)defaultValue > Math.pow(2.0, numBits) - 1.0)) {
                this.displayError("The Field " + field.getName() + "'s" + " defaultValue " + defaultValue + " does not" + " fit\nin the " + numBits + " bits of the field.");
            }
            if (field.getValues().size() > 0 && (field.getRelativity() != Field.Relativity.absolute || numBits == 0)) {
                this.displayError("The Field " + field.getName() + " can" + " have a list of values only if" + " its\nrelativity is absolute and it has" + " a positive number of bits.");
            }
            List<FieldValue> values = field.getValues();
            for (FieldValue value : values) {
                long v;
                double min;
                double max;
                if (field.isSigned()) {
                    max = Math.pow(2.0, numBits) - 1.0;
                    min = Math.pow(2.0, numBits) * -1.0 / 2.0;
                } else {
                    max = Math.pow(2.0, numBits) - 1.0;
                    min = 0.0;
                }
                if (!((double)(v = value.getValue()) > max) && !((double)v < min)) continue;
                this.displayError(value.getName() + " is a value that does not fit in field \"" + field.getName() + "\".");
                return false;
            }
            if (field.getName().indexOf(32) != -1) {
                this.displayError("The field: \"" + field.getName() + "\" cannot" + " have spaces in the name.");
                return false;
            }
            if (field.getName().length() == 0) {
                this.displayError("All field names must have at least one character.");
                return false;
            }
            for (Field otherField : fields) {
                String n = field.getName();
                String sub = otherField.getName();
                if (field.equals(otherField) || !n.equals(sub)) continue;
                this.displayError("No two fields can share the same name");
                return false;
            }
            if (numBits >= 0 && numBits <= 64) continue;
            this.displayError("The field \"" + field.getName() + "\" must have between 0 and 63 bits.");
            return false;
        }
        return true;
    }

    public void setClones(List<Field> fieldList) {
        Field[] fields = new Field[fieldList.size()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = fieldList.get(i);
        }
        this.clones = fields;
    }

    public void updateCurrentFieldsFromClones() {
        this.machine.setFields(this.createNewFieldList(this.clones));
    }

    private List<Field> createNewFieldList(Field[] clones) {
        ArrayList<Field> newFields = new ArrayList<Field>();
        for (Field newField : clones) {
            Field oldField = this.assocList.get(newField);
            if (oldField != null) {
                newField.copyDataTo(oldField);
                newFields.add(oldField);
                continue;
            }
            newFields.add(newField);
        }
        return newFields;
    }
}

