/*
 * Decompiled with CFR 0.152.
 */
package cpusim;

import cpusim.Machine;
import cpusim.MachineInstruction;
import cpusim.util.Factory;
import cpusim.util.Validate;
import cpusim.util.ValidationException;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class MachineInstrFactory
implements Factory {
    private Machine machine;
    private MachineInstruction prototype;
    private JDialog parentFrame;

    public MachineInstrFactory(Machine m, JDialog parent) {
        this.machine = m;
        this.prototype = new MachineInstruction("?", 0L, "", this.machine);
        this.parentFrame = parent;
    }

    private MachineInstruction getNewMachineInstr(String name) {
        MachineInstruction prototype = this.getPrototype();
        MachineInstruction clone = (MachineInstruction)prototype.clone();
        clone.setName(name);
        return clone;
    }

    private MachineInstruction getPrototype() {
        return this.prototype;
    }

    @Override
    public String getHelpPageID() {
        return "MachineInstructions";
    }

    @Override
    public Object getNewObject(String name) {
        return this.getNewMachineInstr(name);
    }

    @Override
    public Object[] createClones() {
        List<MachineInstruction> instrs = this.machine.getInstructions();
        Object[] clones = new MachineInstruction[instrs.size()];
        for (int i = 0; i < clones.length; ++i) {
            clones[i] = (MachineInstruction)instrs.get(i).clone();
        }
        return clones;
    }

    public long createUniqueOpcode(Object[] list) {
        boolean done;
        long proposedOpcode = 0L;
        block0: do {
            done = true;
            for (Object instr : list) {
                if (((MachineInstruction)instr).getOpcode() != proposedOpcode) continue;
                done = false;
                ++proposedOpcode;
                continue block0;
            }
        } while (!done);
        return proposedOpcode;
    }

    @Override
    public boolean checkValidity(Object[] list) {
        MachineInstruction[] instrs = new MachineInstruction[list.length];
        for (int i = 0; i < instrs.length; ++i) {
            instrs[i] = (MachineInstruction)list[i];
        }
        boolean result = true;
        try {
            Validate.machineInstructions(instrs, this.machine);
        }
        catch (ValidationException e) {
            this.displayError(e.getMessage());
            result = false;
        }
        return result;
    }

    @Override
    public void displayError(String message) {
        JOptionPane.showMessageDialog(this.parentFrame, message, "Error", 0);
    }
}

