/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.module.ConditionBit;
import cpusim.util.Assert;

public class SetCondBit
extends Microinstruction {
    private ConditionBit bit;
    private String value;

    public SetCondBit(String name, ConditionBit bit, String value) {
        super(name);
        this.bit = bit;
        this.value = value;
    }

    public void setBit(ConditionBit b) {
        this.bit = b;
    }

    public ConditionBit getBit() {
        return this.bit;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public Object clone() {
        return new SetCondBit(this.getName(), this.getBit(), this.getValue());
    }

    @Override
    public void copyDataTo(Microinstruction newMicro) {
        Assert.That(newMicro instanceof SetCondBit, "Passed non-SetCondBit to SetCondBit.copyDataTo()");
        SetCondBit newSetCondBit = (SetCondBit)newMicro;
        newSetCondBit.setName(this.getName());
        newSetCondBit.setBit(this.getBit());
        newSetCondBit.setValue(this.getValue());
    }

    @Override
    public boolean uses(Module m) {
        return m == this.bit;
    }

    @Override
    public void execute() {
        this.bit.set(this.value.equals("0") ? 0 : 1);
    }

    @Override
    public String getXMLDescription() {
        return "<SetCondBit name=\"" + this.getHTMLName() + "\" bit=\"" + this.getBit().getID() + "\" value=\"" + this.getValue() + "\" id=\"" + this.getID() + "\" />";
    }

    @Override
    public String getHTMLDescription() {
        return "<TR><TD>" + this.getHTMLName() + "</TD><TD>" + this.getBit().getHTMLName() + "</TD><TD>" + this.getValue() + "</TD></TR>";
    }
}

