/*
 * Decompiled with CFR 0.152.
 */
package cpusim.util;

import cpusim.util.Assert;
import java.math.BigInteger;
import java.util.Vector;

public class Convert {
    private Convert() {
    }

    public static String lengths2Format(int[] fieldLengths) {
        String format = "";
        for (int length : fieldLengths) {
            format = format + length + " ";
        }
        return format.trim();
    }

    public static Vector toVector(Object[] objects) {
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < objects.length; ++i) {
            v.addElement(objects[i]);
        }
        return v;
    }

    public static long fromByteArrayToLong(byte[] bytes) {
        Assert.That(bytes.length <= 8, "Tried to convert an array of more than 8 bytes into a long using Convert.byteArrayToLong.");
        BigInteger bigLong = new BigInteger(bytes);
        return bigLong.longValue();
    }

    public static long fromByteArrayToLong2(byte[] bytes) {
        Assert.That(bytes.length <= 8, "Tried to convert an array of more than 8 bytes into a long using Convert.byteArrayToLong.");
        boolean neg = bytes[0] < 0;
        long value = bytes[0] & 0x7F;
        for (int i = 1; i < bytes.length; ++i) {
            value = value << 8 | (long)(bytes[i] & 0xFF);
        }
        if (neg) {
            value |= Long.MIN_VALUE;
        }
        return value;
    }

    public static byte[] fromLongToByteArray(long value, int numBytes) {
        byte[] byteArray = new byte[numBytes];
        for (int i = numBytes - 1; i >= 0; --i) {
            byteArray[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return byteArray;
    }

    public static String fromLongToTwosComplementString(long value, int numBits) {
        String stringValue;
        if (value < 0L) {
            stringValue = Long.toBinaryString(value).substring(64 - numBits);
        } else {
            stringValue = Long.toBinaryString(value);
            int length = stringValue.length();
            for (int i = 0; i < numBits - length; ++i) {
                stringValue = "0" + stringValue;
            }
        }
        return stringValue;
    }

    public static String fromLongToHexadecimalString(long value, int numBits) {
        if (value < 0L && numBits == 64) {
            String left = Convert.fromLongToHexadecimalString(value >>> 32, 32);
            String right = Convert.fromLongToHexadecimalString(value & Integer.MAX_VALUE, 32);
            return left + right;
        }
        if (value < 0L) {
            value += Convert.powerOfTwo(numBits);
        }
        String stringValue = Long.toString(value, 16);
        int length = stringValue.length();
        for (int i = 0; i < numBits - 4 * length; i += 4) {
            stringValue = "0" + stringValue;
        }
        return stringValue.toUpperCase();
    }

    public static String fromLongToUnsignedDecString(long l, int numBits) {
        if (l < 0L) {
            l += Convert.powerOfTwo(numBits);
        }
        return Long.toString(l, 10);
    }

    public static String fromLongToUnicodeString(long l, int numBits) {
        String result = "";
        for (int i = 0; i < numBits / 16; ++i) {
            char c = (char)(l & 0xFFFFL);
            l >>>= 16;
            result = c + result;
        }
        return result;
    }

    public static String fromLongToAsciiString(long l, int numBits) {
        String result = "";
        for (int i = 0; i < numBits / 8; ++i) {
            char c = (char)(l & 0xFFL);
            l >>>= 8;
            result = c + result;
        }
        return result;
    }

    public static long powerOfTwo(int power) {
        long result = 1L;
        for (int i = 1; i <= power; ++i) {
            result *= 2L;
        }
        return result;
    }

    public static boolean fitsInBits(long value, int numBits) {
        BigInteger two;
        BigInteger bigNum = BigInteger.valueOf(value);
        return bigNum.compareTo((two = BigInteger.valueOf(2L)).pow(numBits)) < 0 && bigNum.compareTo(two.pow(numBits - 1).negate()) >= 0;
    }

    public static void checkFitsInBits(long inputLong, int numBits) {
        if (!Convert.fitsInBits(inputLong, numBits)) {
            throw new NumberFormatException("The number " + inputLong + " won't fit in " + numBits + " bits.");
        }
    }

    public static long fromDecimalStringToLong(String s, int numBits) {
        BigInteger bigNum;
        try {
            bigNum = new BigInteger(s);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("The input \"" + s + "\" is " + "not a valid integer.");
        }
        Convert.checkFitsInBits(bigNum.longValue(), numBits);
        return bigNum.longValue();
    }

    public static long fromBinaryStringToLong(String s, int numBits) throws NumberFormatException {
        if (s.charAt(0) == '-') {
            throw new NumberFormatException("Negative signs are not allowed in binary");
        }
        BigInteger bigNum = new BigInteger(s, 2);
        if (bigNum.compareTo(new BigInteger("2").pow(numBits - 1)) < 0) {
            return bigNum.longValue();
        }
        if (bigNum.compareTo(new BigInteger("2").pow(numBits)) < 0) {
            return bigNum.subtract(new BigInteger("2").pow(numBits)).longValue();
        }
        throw new NumberFormatException("value won't fit in the given bits");
    }

    public static long fromHexadecimalStringToLong(String s, int numBits) throws NumberFormatException {
        if (s.charAt(0) == '-') {
            throw new NumberFormatException("Negative signs are not allowed in hex in CPU Sim.");
        }
        BigInteger bigNum = new BigInteger(s, 16);
        if (bigNum.compareTo(new BigInteger("2").pow(numBits - 1)) < 0) {
            return bigNum.longValue();
        }
        if (bigNum.compareTo(new BigInteger("2").pow(numBits)) < 0) {
            return bigNum.subtract(new BigInteger("2").pow(numBits)).longValue();
        }
        throw new NumberFormatException("value won't fit in the given bits");
    }

    public static long fromUnsignedDecStringToLong(String s, int numBits) throws NumberFormatException {
        BigInteger bigNum = null;
        try {
            bigNum = new BigInteger(s);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("The input \"" + s + "\" is " + "not a valid integer.");
        }
        if (bigNum.compareTo(new BigInteger("2").pow(numBits)) < 0) {
            return bigNum.longValue();
        }
        throw new NumberFormatException("The number " + s + " won't fit in " + numBits + " bits.");
    }

    public static long fromAsciiStringToLong(String s, int numBits) throws NumberFormatException {
        if (s.length() * 8 > numBits) {
            throw new NumberFormatException("value won't fit in the given bits");
        }
        long result = 0L;
        for (int i = 0; i < s.length(); ++i) {
            result = (result << 8) + (long)s.charAt(i);
        }
        return result;
    }

    public static long fromUnicodeStringToLong(String s, int numBits) throws NumberFormatException {
        if (s.length() * 16 > numBits) {
            throw new NumberFormatException("value won't fit in the given bits");
        }
        long result = 0L;
        for (int i = 0; i < s.length(); ++i) {
            result = (result << 16) + (long)s.codePointAt(i);
        }
        return result;
    }

    public static long fromAnyBaseStringToLong(String string) throws NumberFormatException {
        while (string.startsWith(" ")) {
            string = string.substring(1);
        }
        if (string.startsWith("'")) {
            char c = string.charAt(1);
            return c;
        }
        if (string.startsWith("+")) {
            string = string.substring(1);
        }
        int radix = 10;
        if (string.startsWith("0b")) {
            radix = 2;
            string = string.substring(2);
        } else if (string.startsWith("-0b")) {
            radix = 2;
            string = "-" + string.substring(3);
        } else if (string.startsWith("0x")) {
            radix = 16;
            string = string.substring(2);
        } else if (string.startsWith("-0x")) {
            radix = 16;
            string = "-" + string.substring(3);
        }
        return Long.parseLong(string, radix);
    }

    public static String insertSpacesInString(String origString, int charGroupSize) {
        String builder = "";
        for (int i = origString.length(); i > 0; i -= charGroupSize) {
            builder = i > charGroupSize ? "  " + origString.substring(i - charGroupSize, i) + builder : origString.substring(0, i) + builder;
        }
        return builder;
    }

    public static String removeAllWhiteSpace(String origString) {
        String newString = "";
        char[] arrayOrigString = origString.toCharArray();
        for (int i = 0; i < origString.length(); ++i) {
            if (Character.isWhitespace(arrayOrigString[i])) continue;
            newString = newString + arrayOrigString[i];
        }
        return newString;
    }
}

