/*
 * Decompiled with CFR 0.152.
 */
package cpusim.assembler;

import cpusim.MachineInstruction;
import cpusim.assembler.AssemblyException;
import cpusim.assembler.Token;
import cpusim.util.SourceLine;
import java.util.ArrayList;
import java.util.List;

public class InstructionCall {
    public List<Token> labels;
    public MachineInstruction machineInstruction;
    public List<Token> operands;
    public String comment;
    public SourceLine sourceLine;
    private int cellSize;

    public InstructionCall(int s) {
        this.cellSize = s;
        this.operands = new ArrayList<Token>();
        this.labels = new ArrayList<Token>();
        this.machineInstruction = null;
        this.comment = "";
        this.sourceLine = null;
    }

    public long getOpcode() {
        return this.machineInstruction.getOpcode();
    }

    public int getLength() {
        int length;
        if (this.machineInstruction != null) {
            return this.machineInstruction.length();
        }
        try {
            length = Integer.parseInt(this.operands.get((int)0).contents);
        }
        catch (NumberFormatException e) {
            throw new AssemblyException("Error: The number " + this.operands.get((int)0).contents + " could not be parsed as an integer--" + "\n       It is probably too large", this.operands.get(0));
        }
        return length * this.cellSize;
    }
}

