/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.module.Register;
import cpusim.scrollabledesktop.BaseInternalFrame;
import cpusim.util.Assert;
import cpusim.util.CPUSimConstants;
import cpusim.util.ExtendedJTable;
import cpusim.util.MBNTableCellEditor;
import cpusim.util.MBNTableCellRenderer;
import cpusim.util.OOTableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class RegistersWindow
extends BaseInternalFrame
implements CPUSimConstants {
    private ExtendedJTable registerTable;
    private int currentBase;
    private int[] numBits;
    private MBNTableCellEditor valueCellEditor;
    private MBNTableCellRenderer valueCellRenderer;
    private Register[] registers;
    private JComboBox baseChoices;

    public RegistersWindow(Vector registerVector, String name) {
        this(registerVector.toArray(new Register[0]), name, null, null);
    }

    public RegistersWindow(Register[] theRegisters, String name, InternalFrameListener activateNonAssemblerWindowListener, VetoableChangeListener vetoSelectionListener) {
        super(name, true, true, true, true);
        int initialHeight = 95 + 16 * theRegisters.length;
        if (initialHeight > 500) {
            initialHeight = 500;
        }
        this.setSize(300, initialHeight);
        Container contentPane = this.getContentPane();
        this.currentBase = 0;
        this.registers = theRegisters;
        this.numBits = new int[this.registers.length];
        for (int i = 0; i < this.numBits.length; ++i) {
            this.numBits[i] = this.registers[i].getWidth();
        }
        this.valueCellEditor = new MBNTableCellEditor(this.numBits);
        this.valueCellRenderer = new MBNTableCellRenderer(this.numBits);
        HashMap<String, MBNTableCellEditor> editors = new HashMap<String, MBNTableCellEditor>();
        editors.put("value", this.valueCellEditor);
        HashMap<String, MBNTableCellRenderer> renderers = new HashMap<String, MBNTableCellRenderer>();
        renderers.put("value", this.valueCellRenderer);
        RegistersTableModel model = null;
        try {
            model = new RegistersTableModel(this.registers);
            model.setColumns(new String[]{"name", "width", "value"});
        }
        catch (IntrospectionException e) {
            Assert.That(false, "Beans introspection exception thrown when trying to create the ExtendedJTable for the RegistersWindow with message: " + e.getMessage());
        }
        this.registerTable = new ExtendedJTable((TableModel)model, editors, renderers);
        this.registerTable.setSelectionMode(0);
        this.registerTable.getOOModel().setReadOnly(new String[]{"name", "width"});
        this.registerTable.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.registerTable.getColumnModel().getColumn(1).setPreferredWidth(40);
        this.registerTable.getColumnModel().getColumn(2).setPreferredWidth(240);
        contentPane.add((Component)new JScrollPane(this.registerTable), "Center");
        contentPane.add((Component)this.createBaseChoicesPanel(), "North");
        this.setDefaultCloseOperation(1);
        this.addVetoableChangeListener(vetoSelectionListener);
        this.addInternalFrameListener(activateNonAssemblerWindowListener);
        this.setVisible(true);
    }

    public String getBaseString() {
        return DISPLAY_MODE_NAMES[this.currentBase];
    }

    public void setBase(String newBaseString) {
        int newBase = newBaseString.equals("Decimal") ? 0 : (newBaseString.equals("Binary") ? 1 : (newBaseString.equals("Ascii") ? 4 : (newBaseString.equals("Unicode") ? 5 : (newBaseString.equals("Unsigned Dec") ? 3 : 2))));
        if (newBase == this.currentBase) {
            return;
        }
        this.valueCellEditor.setMode(newBase);
        this.valueCellRenderer.setMode(newBase);
        this.currentBase = newBase;
        this.registerTable.repaint();
        this.baseChoices.setSelectedIndex(newBase);
    }

    public void updateDataDisplay() {
        this.registerTable.getOOModel().fireTableDataChanged();
    }

    public void setTableFont(Font tableFont) {
        for (int i = 0; i < this.registerTable.getColumnCount(); ++i) {
            DefaultCellEditor editor = (DefaultCellEditor)this.registerTable.getCellEditor(0, i);
            editor.getComponent().setFont(tableFont);
        }
        this.registerTable.setRowHeight(tableFont.getSize() + 4);
        this.registerTable.setFont(tableFont);
    }

    public void updateRegistersTable(Vector newRegisters) {
        this.updateRegistersTable(newRegisters.toArray(new Register[0]));
    }

    public void updateRegistersTable(Register[] newRegisters) {
        this.registers = newRegisters;
        this.numBits = new int[this.registers.length];
        for (int i = 0; i < this.numBits.length; ++i) {
            this.numBits[i] = this.registers[i].getWidth();
        }
        this.valueCellEditor.setNumBits(this.numBits);
        this.valueCellRenderer.setNumBits(this.numBits);
        this.registerTable.getOOModel().updateObjects(this.registers);
        this.registerTable.repaint();
    }

    public boolean finishCurrentEditing() {
        TableCellEditor editor = this.registerTable.getCellEditor();
        return editor == null || editor.stopCellEditing();
    }

    public void cancelCurrentEditing() {
        TableCellEditor editor = this.registerTable.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
    }

    public void outlineRows(Set<Register> registerSet) {
        HashSet<Integer> rowSet = new HashSet<Integer>();
        for (int i = 0; i < this.registers.length; ++i) {
            if (!registerSet.contains(this.registers[i])) continue;
            rowSet.add(i);
        }
        this.valueCellRenderer.setOutlineRows(rowSet);
    }

    private JPanel createBaseChoicesPanel() {
        JPanel thePanel = new JPanel();
        this.baseChoices = new JComboBox<String>(new String[]{"Decimal", "Binary", "Hexadecimal", "Unsigned Dec", "Ascii", "Unicode"});
        this.baseChoices.addActionListener(new BasesComboListener());
        JLabel label = new JLabel("Base:");
        thePanel.add(label);
        thePanel.add(this.baseChoices);
        return thePanel;
    }

    class BasesComboListener
    implements ActionListener {
        BasesComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellEditor editor = RegistersWindow.this.registerTable.getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                RegistersWindow.this.baseChoices.setSelectedIndex(RegistersWindow.this.currentBase);
                return;
            }
            int newBase = RegistersWindow.this.baseChoices.getSelectedIndex();
            if (newBase == RegistersWindow.this.currentBase) {
                return;
            }
            RegistersWindow.this.valueCellEditor.setMode(newBase);
            RegistersWindow.this.valueCellRenderer.setMode(newBase);
            RegistersWindow.this.currentBase = newBase;
            RegistersWindow.this.registerTable.repaint();
        }
    }

    static class RegistersTableModel
    extends OOTableModel {
        RegistersTableModel(Register[] registers) throws IntrospectionException {
            super(registers);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (!event.getPropertyName().equals("value")) {
                super.propertyChange(event);
            }
        }
    }
}

