/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.microinstruction.MicroFactory;
import cpusim.microinstruction.Shift;
import cpusim.module.Register;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

public class ShiftFactory
extends MicroFactory {
    private Vector currentMicros;
    private Shift prototype;

    public ShiftFactory(Machine machine) {
        super(machine);
        this.currentMicros = machine.getMicros("shift");
        Register r = machine.getAllRegisters().size() == 0 ? null : (Register)machine.getAllRegisters().elementAt(0);
        this.prototype = new Shift("???", r, r, "left", 1, "logical");
        this.clones = (Microinstruction[])this.createClones();
    }

    @Override
    public HashMap getCellEditors() {
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        Vector registers = this.machine.getAllRegisters();
        JComboBox sourcesCombo = new JComboBox(registers);
        editors.put("source", new DefaultCellEditor(sourcesCombo));
        JComboBox destinationsCombo = new JComboBox(registers);
        editors.put("destination", new DefaultCellEditor(destinationsCombo));
        JComboBox<String> typesCombo = new JComboBox<String>(Shift.TYPES);
        editors.put("type", new DefaultCellEditor(typesCombo));
        JComboBox<String> directionsCombo = new JComboBox<String>(Shift.DIRECTIONS);
        editors.put("direction", new DefaultCellEditor(directionsCombo));
        return editors;
    }

    @Override
    Microinstruction getPrototype() {
        return this.prototype;
    }

    @Override
    Class getMicroClass() {
        return Shift.class;
    }

    @Override
    public Vector getCurrentMicros() {
        return this.currentMicros;
    }

    @Override
    public String toString() {
        return "Shift";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "source", "destination", "type", "direction", "distance"};
    }

    @Override
    public boolean checkValidity(Object[] micros) {
        Microinstruction[] shifts = new Shift[micros.length];
        for (int i = 0; i < shifts.length; ++i) {
            shifts[i] = (Shift)micros[i];
        }
        return this.allNamesAreUnique(shifts) && !this.someNamesAreEmpty(shifts) && this.noNegativeDistances((Shift[])shifts) && this.registersHaveEqualWidths((Shift[])shifts);
    }

    public boolean noNegativeDistances(Shift[] shifts) {
        for (int i = 0; i < shifts.length; ++i) {
            if (shifts[i].getDistance() > 0) continue;
            this.displayError("The microinstruction \"" + shifts[i].getName() + "\" has a negative or zero shift distance.\nShift distances " + "must be positive.");
            return false;
        }
        return true;
    }

    public boolean registersHaveEqualWidths(Shift[] shifts) {
        for (int i = 0; i < shifts.length; ++i) {
            if (shifts[i].getSource().getWidth() == shifts[i].getDestination().getWidth()) continue;
            this.displayError("The microinstruction " + shifts[i].getName() + " has different-sized registers designated " + "for source and destination.\nBoth registers " + "must have the same number of bits.");
            return false;
        }
        return true;
    }

    @Override
    public void updateCurrentMicrosFromClones() {
        this.machine.setMicros("shift", this.createNewMicroList(this.clones));
    }

    @Override
    public void setClones(Object[] newClones) {
        Shift[] shifts = new Shift[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            shifts[i] = (Shift)newClones[i];
        }
        this.clones = shifts;
    }

    @Override
    public boolean newMicrosAreAllowed() {
        return this.machine.getModule("registers").size() > 0 || this.machine.getModule("registerArrays").size() > 0;
    }

    @Override
    public String getHelpPageID() {
        return "Shift";
    }
}

