/*
 * Decompiled with CFR 0.152.
 */
package cpusim.syntax;

import cpusim.syntax.InputHandler;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;

public class DefaultInputHandler
extends InputHandler {
    String osName;
    private Hashtable bindings;
    private Hashtable currentBindings;

    public DefaultInputHandler() {
        this.bindings = this.currentBindings = new Hashtable();
        this.osName = System.getProperty("os.name");
    }

    @Override
    public void addDefaultKeyBindings() {
        this.addKeyBinding("BACK_SPACE", BACKSPACE);
        this.addKeyBinding("C+BACK_SPACE", BACKSPACE_WORD);
        this.addKeyBinding("DELETE", DELETE);
        this.addKeyBinding("C+DELETE", DELETE_WORD);
        this.addKeyBinding("ENTER", INSERT_BREAK);
        this.addKeyBinding("TAB", INSERT_TAB);
        this.addKeyBinding("INSERT", OVERWRITE);
        this.addKeyBinding("C+\\", TOGGLE_RECT);
        this.addKeyBinding("HOME", HOME);
        this.addKeyBinding("END", END);
        this.addKeyBinding("S+HOME", SELECT_HOME);
        this.addKeyBinding("S+END", SELECT_END);
        this.addKeyBinding("C+HOME", DOCUMENT_HOME);
        this.addKeyBinding("C+END", DOCUMENT_END);
        this.addKeyBinding("CS+HOME", SELECT_DOC_HOME);
        this.addKeyBinding("CS+END", SELECT_DOC_END);
        this.addKeyBinding("PAGE_UP", PREV_PAGE);
        this.addKeyBinding("PAGE_DOWN", NEXT_PAGE);
        this.addKeyBinding("S+PAGE_UP", SELECT_PREV_PAGE);
        this.addKeyBinding("S+PAGE_DOWN", SELECT_NEXT_PAGE);
        this.addKeyBinding("LEFT", PREV_CHAR);
        this.addKeyBinding("S+LEFT", SELECT_PREV_CHAR);
        this.addKeyBinding("C+LEFT", PREV_WORD);
        this.addKeyBinding("CS+LEFT", SELECT_PREV_WORD);
        this.addKeyBinding("RIGHT", NEXT_CHAR);
        this.addKeyBinding("S+RIGHT", SELECT_NEXT_CHAR);
        this.addKeyBinding("C+RIGHT", NEXT_WORD);
        this.addKeyBinding("CS+RIGHT", SELECT_NEXT_WORD);
        this.addKeyBinding("UP", PREV_LINE);
        this.addKeyBinding("S+UP", SELECT_PREV_LINE);
        this.addKeyBinding("DOWN", NEXT_LINE);
        this.addKeyBinding("S+DOWN", SELECT_NEXT_LINE);
        this.addKeyBinding("C+ENTER", REPEAT);
        this.addKeyBinding("C+O", OPEN_TEXT);
        this.addKeyBinding("C+N", NEW_TEXT);
        this.addKeyBinding("C+W", CLOSE_TEXT);
        this.addKeyBinding("C+S", SAVE_TEXT);
        this.addKeyBinding("CS+S", SAVE_TEXT_AS);
        this.addKeyBinding("C+L", NEW_MACHINE);
        this.addKeyBinding("C+U", OPEN_MACHINE);
        this.addKeyBinding("C+B", SAVE_MACHINE);
        this.addKeyBinding("CS+B", SAVE_MACHINE_AS);
        this.addKeyBinding("C+P", PRINT);
        this.addKeyBinding("C+X", CUT);
        this.addKeyBinding("C+C", COPY);
        this.addKeyBinding("C+V", PASTE);
        this.addKeyBinding("C+A", SELECT_ALL);
        this.addKeyBinding("C+F", FIND);
        this.addKeyBinding("C+H", REPLACE);
        this.addKeyBinding("C+Z", UNDO);
        this.addKeyBinding("C+Y", REDO);
        this.addKeyBinding("CS+Z", REDO);
        this.addKeyBinding("C+T", PREFERENCES);
        this.addKeyBinding("C+I", MACHINE_INSTRUCTIONS);
        this.addKeyBinding("C+M", MICROINSTRUCTIONS);
        this.addKeyBinding("C+K", HARDWARE);
        this.addKeyBinding("C+E", EQUS);
        this.addKeyBinding("C+D", DEBUG_MODE);
        this.addKeyBinding("C+[", ASSEMBLE);
        this.addKeyBinding("C+]", ASSEMBLE_AND_LOAD);
        this.addKeyBinding("C+G", CLEAR_ASSEMBLE_LOAD_AND_RUN);
        this.addKeyBinding("C+.", STOP);
        this.addKeyBinding("C+R", CLEAR_EVERYTHING);
        this.addKeyBinding("C+U", RUN);
        this.addKeyBinding("C+J", IO_OPTIONS);
        this.addKeyBinding("A+F", FILEMENU);
        this.addKeyBinding("A+E", EDITMENU);
        this.addKeyBinding("A+M", MODIFYMENU);
        this.addKeyBinding("A+x", EXECUTEMENU);
        this.addKeyBinding("A+V", VIEWMENU);
        this.addKeyBinding("A+T", TEXTMENU);
        this.addKeyBinding("A+H", HELPMENU);
        this.addKeyBinding("A+G", GO_BUTTON);
        this.addKeyBinding("A+S", STEP_BY_INSTR_BUTTON);
        this.addKeyBinding("A+p", STEP_BY_MICRO_BUTTON);
        this.addKeyBinding("A+B", BACKUP_ONE_INSTR_BUTTON);
        this.addKeyBinding("A+k", BACKUP_ONE_MICRO_BUTTON);
        this.addKeyBinding("A+R", START_OVER_BUTTON);
    }

    @Override
    public void addKeyBinding(String keyBinding, ActionListener action) {
        Hashtable current = this.bindings;
        StringTokenizer st = new StringTokenizer(keyBinding);
        while (st.hasMoreTokens()) {
            KeyStroke keyStroke = DefaultInputHandler.parseKeyStroke(st.nextToken());
            if (keyStroke == null) {
                return;
            }
            if (st.hasMoreTokens()) {
                Object o = current.get(keyStroke);
                if (o instanceof Hashtable) {
                    current = (Hashtable)o;
                    continue;
                }
                o = new Hashtable();
                current.put(keyStroke, o);
                current = (Hashtable)o;
                continue;
            }
            current.put(keyStroke, action);
        }
    }

    @Override
    public void removeKeyBinding(String keyBinding) {
        throw new InternalError("Not yet implemented");
    }

    @Override
    public void removeAllKeyBindings() {
        this.bindings.clear();
    }

    @Override
    public InputHandler copy() {
        return new DefaultInputHandler(this);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        int modifiers = evt.getModifiers();
        if (keyCode == 17 || keyCode == 16 || keyCode == 18 || keyCode == 157) {
            return;
        }
        if ((modifiers & 0xFFFFFFFE) != 0 || evt.isActionKey() || keyCode == 8 || keyCode == 127 || keyCode == 10 || keyCode == 9 || keyCode == 27) {
            if (this.grabAction != null) {
                this.handleGrabAction(evt);
                return;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
            Object o = this.currentBindings.get(keyStroke);
            if (o == null) {
                if (this.currentBindings != this.bindings) {
                    Toolkit.getDefaultToolkit().beep();
                    this.repeatCount = 0;
                    this.repeat = false;
                    evt.consume();
                }
                this.currentBindings = this.bindings;
                return;
            }
            if (o instanceof ActionListener) {
                this.currentBindings = this.bindings;
                this.executeAction((ActionListener)o, evt.getSource(), null);
                evt.consume();
                return;
            }
            if (o instanceof Hashtable) {
                this.currentBindings = (Hashtable)o;
                evt.consume();
                return;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        int modifiers = evt.getModifiers();
        char c = evt.getKeyChar();
        if (c != '\uffff' && (modifiers & 8) == 0 && (modifiers & 2) == 0 && (modifiers & 4) == 0 && c >= ' ' && c != '\u007f') {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(Character.toUpperCase(c));
            Object o = this.currentBindings.get(keyStroke);
            if (o instanceof Hashtable) {
                this.currentBindings = (Hashtable)o;
                return;
            }
            if (o instanceof ActionListener) {
                this.currentBindings = this.bindings;
                this.executeAction((ActionListener)o, evt.getSource(), String.valueOf(c));
                return;
            }
            this.currentBindings = this.bindings;
            if (this.grabAction != null) {
                this.handleGrabAction(evt);
                return;
            }
            if (this.repeat && Character.isDigit(c)) {
                this.repeatCount *= 10;
                this.repeatCount += c - 48;
                return;
            }
            this.executeAction(INSERT_CHAR, evt.getSource(), String.valueOf(evt.getKeyChar()));
            this.repeatCount = 0;
            this.repeat = false;
        }
    }

    public static KeyStroke parseKeyStroke(String keyStroke) {
        int ch;
        String key;
        if (keyStroke == null) {
            return null;
        }
        int modifiers = 0;
        int index = keyStroke.indexOf(43);
        if (index != -1) {
            String osName = System.getProperty("os.name");
            block8: for (int i = 0; i < index; ++i) {
                switch (Character.toUpperCase(keyStroke.charAt(i))) {
                    case 'A': {
                        modifiers |= 8;
                        continue block8;
                    }
                    case 'C': {
                        if (osName.indexOf("Mac") != -1) {
                            modifiers |= 4;
                            continue block8;
                        }
                        modifiers |= 2;
                        continue block8;
                    }
                    case 'M': {
                        modifiers |= 4;
                        continue block8;
                    }
                    case 'S': {
                        modifiers |= 1;
                    }
                }
            }
        }
        if ((key = keyStroke.substring(index + 1)).length() == 1) {
            ch = Character.toUpperCase(key.charAt(0));
            if (modifiers == 0) {
                return KeyStroke.getKeyStroke((char)ch);
            }
            return KeyStroke.getKeyStroke(ch, modifiers);
        }
        if (key.length() == 0) {
            System.err.println("Invalid key stroke: " + keyStroke);
            return null;
        }
        try {
            ch = KeyEvent.class.getField("VK_".concat(key)).getInt(null);
        }
        catch (Exception e) {
            System.err.println("Invalid key stroke: " + keyStroke);
            return null;
        }
        return KeyStroke.getKeyStroke(ch, modifiers);
    }

    private DefaultInputHandler(DefaultInputHandler copy) {
        this.bindings = this.currentBindings = copy.bindings;
    }
}

