/*
 * Decompiled with CFR 0.152.
 */
package cpusim.util;

import cpusim.util.CPUSimConstants;
import cpusim.util.Convert;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.lang.reflect.Constructor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class HexTableCellEditor
extends DefaultCellEditor
implements CPUSimConstants {
    Class[] argTypes = new Class[]{String.class};
    Constructor constructor;
    Object value;

    public HexTableCellEditor() {
        super(new JTextField());
        ((JTextField)this.getComponent()).setHorizontalAlignment(4);
    }

    @Override
    public boolean stopCellEditing() {
        String s = (String)super.getCellEditorValue();
        try {
            s = Long.toString(Convert.fromHexadecimalStringToLong(s, 64));
            this.value = this.constructor.newInstance(s);
        }
        catch (Exception e) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        return super.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = null;
        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
        try {
            Class<Object> type = table.getColumnClass(column);
            if (type == Object.class) {
                type = String.class;
            }
            this.constructor = type.getConstructor(this.argTypes);
        }
        catch (Exception e) {
            return null;
        }
        value = Long.toHexString((Long)value).toUpperCase();
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }
}

