/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GDimension;
import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GRectangle;
import acm.graphics.GResizable;
import acm.graphics.GScalable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class GRect
extends GObject
implements GFillable,
GResizable,
GScalable {
    private double frameWidth;
    private double frameHeight;
    private boolean isFilled;
    private Color fillColor;
    static final long serialVersionUID = 1L;

    public GRect(double width, double height) {
        this(0.0, 0.0, width, height);
    }

    public GRect(double x, double y, double width, double height) {
        this.frameWidth = width;
        this.frameHeight = height;
        this.setLocation(x, y);
    }

    @Override
    public void paint(Graphics g) {
        Rectangle r = this.getAWTBounds();
        if (this.isFilled()) {
            g.setColor(this.getFillColor());
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(this.getColor());
        }
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setFilled(boolean fill) {
        this.isFilled = fill;
        this.repaint();
    }

    @Override
    public boolean isFilled() {
        return this.isFilled;
    }

    @Override
    public void setFillColor(Color color) {
        this.fillColor = color;
        this.repaint();
    }

    @Override
    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    @Override
    public void setSize(double width, double height) {
        this.frameWidth = width;
        this.frameHeight = height;
        this.repaint();
    }

    @Override
    public final void setSize(GDimension size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public GDimension getSize() {
        return new GDimension(this.frameWidth, this.frameHeight);
    }

    @Override
    public void setBounds(double x, double y, double width, double height) {
        this.frameWidth = width;
        this.frameHeight = height;
        this.setLocation(x, y);
    }

    @Override
    public final void setBounds(GRectangle bounds) {
        this.setBounds(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    @Override
    public GRectangle getBounds() {
        return new GRectangle(this.getX(), this.getY(), this.frameWidth, this.frameHeight);
    }

    @Override
    public double getWidth() {
        return this.frameWidth;
    }

    @Override
    public double getHeight() {
        return this.frameHeight;
    }

    @Override
    public void scale(double sx, double sy) {
        this.frameWidth *= sx;
        this.frameHeight *= sy;
        this.repaint();
    }

    @Override
    public final void scale(double sf) {
        this.scale(sf, sf);
    }

    protected Rectangle getAWTBounds() {
        return new Rectangle(GMath.round(this.getX()), GMath.round(this.getY()), GMath.round(this.frameWidth), GMath.round(this.frameHeight));
    }
}

