/*
 * Decompiled with CFR 0.152.
 */
package cpusim.assembler;

import cpusim.assembler.AssemblyException;
import cpusim.assembler.Token;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Stack;

public class StreamObject {
    public Stack<Token> tokenStack;
    public String filename;
    public char currentChar;
    public int lineNumber;
    public int columnNumber;
    public int offset;
    public int prevLineNumber;
    public int prevColumnNumber;
    public int prevOffset;
    public BufferedReader reader;

    public StreamObject(String path, BufferedReader r, Stack<Token> stack, char ch, int l, int c, int o, int pl, int pc, int po) {
        this.currentChar = ch;
        this.tokenStack = stack;
        this.filename = path;
        this.lineNumber = l;
        this.columnNumber = c;
        this.offset = o;
        this.prevColumnNumber = pc;
        this.prevLineNumber = pl;
        this.prevOffset = po;
        this.reader = r;
    }

    public StreamObject(String path, Token token) {
        this.tokenStack = new Stack();
        this.filename = path;
        this.lineNumber = 0;
        this.columnNumber = 0;
        this.offset = 0;
        this.prevColumnNumber = 0;
        this.prevLineNumber = 0;
        this.prevOffset = 0;
        this.reader = this.getReader(path, token);
    }

    private BufferedReader getReader(String path, Token token) {
        BufferedReader bufferedReader;
        try {
            File file = new File(path);
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new AssemblyException("Error: File \"" + path + "\" not found", token);
        }
        catch (IOException ioe) {
            throw new AssemblyException("Error: Trouble reading from file " + path, token);
        }
        return bufferedReader;
    }
}

