/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.microinstruction.Branch;
import cpusim.microinstruction.MicroFactory;
import cpusim.util.Validate;
import cpusim.util.ValidationException;
import java.util.HashMap;
import java.util.Vector;

public class BranchFactory
extends MicroFactory {
    private Vector currentMicros;
    private Branch prototype;

    public BranchFactory(Machine machine) {
        super(machine);
        this.currentMicros = machine.getMicros("branch");
        this.prototype = new Branch("???", 0, machine.getControlUnit());
        this.clones = (Microinstruction[])this.createClones();
    }

    @Override
    public HashMap getCellEditors() {
        HashMap editors = new HashMap();
        return editors;
    }

    @Override
    Microinstruction getPrototype() {
        return this.prototype;
    }

    @Override
    Class getMicroClass() {
        return Branch.class;
    }

    @Override
    public Vector getCurrentMicros() {
        return this.currentMicros;
    }

    @Override
    public String toString() {
        return "Branch";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "amount"};
    }

    @Override
    public void updateCurrentMicrosFromClones() {
        this.machine.setMicros("branch", this.createNewMicroList(this.clones));
    }

    @Override
    public void setClones(Object[] newClones) {
        Branch[] branches = new Branch[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            branches[i] = (Branch)newClones[i];
        }
        this.clones = branches;
    }

    @Override
    public boolean checkValidity(Object[] micros) {
        try {
            Validate.allNamesAreUnique(micros);
            Validate.allNamesAreNonEmpty(micros);
        }
        catch (ValidationException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean newMicrosAreAllowed() {
        return true;
    }

    @Override
    public String getHelpPageID() {
        return "Branch";
    }
}

