/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.module.ConditionBit;
import cpusim.module.Register;
import cpusim.util.Assert;
import cpusim.util.CPUSimConstants;
import java.math.BigInteger;

public class Increment
extends Microinstruction
implements CPUSimConstants {
    private long delta;
    private Register register;
    private ConditionBit overflowBit;

    public Increment(String name, long delta, Register register, ConditionBit overflowBit) {
        super(name);
        this.delta = delta;
        this.register = register;
        this.overflowBit = overflowBit;
        Assert.That(overflowBit != null, "Passed null for overflowBit to Increment's constructor");
        Assert.That(register != null, "Passed null for register to Increment's constructor");
    }

    public void setDelta(long newDelta) {
        this.delta = newDelta;
    }

    public void setRegister(Register newRegister) {
        this.register = newRegister;
    }

    public void setOverflowBit(ConditionBit newBit) {
        this.overflowBit = newBit;
    }

    public long getDelta() {
        return this.delta;
    }

    public Register getRegister() {
        return this.register;
    }

    public ConditionBit getOverflowBit() {
        return this.overflowBit;
    }

    @Override
    public Object clone() {
        return new Increment(this.getName(), this.delta, this.register, this.overflowBit);
    }

    @Override
    public void copyDataTo(Microinstruction newMicro) {
        Assert.That(newMicro instanceof Increment, "Passed non-Increment to Increment.copyDataTo()");
        Increment newIncr = (Increment)newMicro;
        newIncr.setName(this.getName());
        newIncr.delta = this.delta;
        newIncr.register = this.register;
        newIncr.overflowBit = this.overflowBit;
    }

    @Override
    public boolean uses(Module m) {
        return m == this.register || m == this.overflowBit;
    }

    @Override
    public void execute() {
        BigInteger bigValue = BigInteger.valueOf(this.register.getValue());
        BigInteger bigDelta = BigInteger.valueOf(this.delta);
        BigInteger bigResult = null;
        bigResult = bigValue.add(bigDelta);
        int width = this.register.getWidth();
        BigInteger twoToWidthMinusOne = BigInteger.valueOf(2L).pow(width - 1);
        if (bigResult.compareTo(twoToWidthMinusOne) >= 0 || bigResult.compareTo(twoToWidthMinusOne.negate()) < 0) {
            this.overflowBit.set(1);
        }
        long result = bigResult.longValue();
        this.register.setValue(result << 64 - width >> 64 - width);
    }

    @Override
    public String getXMLDescription() {
        return "<Increment name=\"" + this.getHTMLName() + "\" register=\"" + this.getRegister().getID() + (this.overflowBit != CPUSimConstants.NO_CONDITIONBIT ? "\" overflowBit=\"" + this.getOverflowBit().getID() : "") + "\" delta=\"" + this.getDelta() + "\" id=\"" + this.getID() + "\" />";
    }

    @Override
    public String getHTMLDescription() {
        return "<TR><TD>" + this.getHTMLName() + "</TD><TD>" + this.getRegister().getHTMLName() + "</TD><TD>" + this.getOverflowBit().getHTMLName() + "</TD><TD>" + this.getDelta() + "</TD></TR>";
    }
}

