/*
 * Decompiled with CFR 0.152.
 */
package cpusim.syntax;

import cpusim.gui.ActionListenerFor;
import cpusim.syntax.JEditTextArea;
import cpusim.syntax.TextUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;

public abstract class InputHandler
extends KeyAdapter {
    public static final String SMART_HOME_END_PROPERTY = "InputHandler.homeEnd";
    public static final ActionListener BACKSPACE = new backspace();
    public static final ActionListener BACKSPACE_WORD = new backspace_word();
    public static final ActionListener DELETE = new delete();
    public static final ActionListener DELETE_WORD = new delete_word();
    public static final ActionListener END = new end(false);
    public static final ActionListener DOCUMENT_END = new document_end(false);
    public static final ActionListener SELECT_END = new end(true);
    public static final ActionListener SELECT_DOC_END = new document_end(true);
    public static final ActionListener INSERT_BREAK = new insert_break();
    public static final ActionListener INSERT_TAB = new insert_tab();
    public static final ActionListener HOME = new home(false);
    public static final ActionListener DOCUMENT_HOME = new document_home(false);
    public static final ActionListener SELECT_HOME = new home(true);
    public static final ActionListener SELECT_DOC_HOME = new document_home(true);
    public static final ActionListener NEXT_CHAR = new next_char(false);
    public static final ActionListener NEXT_LINE = new next_line(false);
    public static final ActionListener NEXT_PAGE = new next_page(false);
    public static final ActionListener NEXT_WORD = new next_word(false);
    public static final ActionListener SELECT_NEXT_CHAR = new next_char(true);
    public static final ActionListener SELECT_NEXT_LINE = new next_line(true);
    public static final ActionListener SELECT_NEXT_PAGE = new next_page(true);
    public static final ActionListener SELECT_NEXT_WORD = new next_word(true);
    public static final ActionListener OVERWRITE = new overwrite();
    public static final ActionListener PREV_CHAR = new prev_char(false);
    public static final ActionListener PREV_LINE = new prev_line(false);
    public static final ActionListener PREV_PAGE = new prev_page(false);
    public static final ActionListener PREV_WORD = new prev_word(false);
    public static final ActionListener SELECT_PREV_CHAR = new prev_char(true);
    public static final ActionListener SELECT_PREV_LINE = new prev_line(true);
    public static final ActionListener SELECT_PREV_PAGE = new prev_page(true);
    public static final ActionListener SELECT_PREV_WORD = new prev_word(true);
    public static final ActionListener REPEAT = new repeat();
    public static final ActionListener TOGGLE_RECT = new toggle_rect();
    public static final int COPY_VAL = 0;
    public static final int CUT_VAL = 1;
    public static final int PASTE_VAL = 2;
    public static final int SELECT_ALL_VAL = 3;
    public static final int SAVE_VAL = 0;
    public static final int SAVE_AS_VAL = 1;
    public static final ActionListener INSERT_CHAR = new insert_char();
    public static final ActionListener OPEN_TEXT = new ActionListenerFor.OpenText();
    public static final ActionListener NEW_TEXT = new ActionListenerFor.NewText();
    public static final ActionListener CLOSE_TEXT = new ActionListenerFor.CloseInternalTextFrame();
    public static final ActionListener SAVE_TEXT = new ActionListenerFor.SavingText(0);
    public static final ActionListener SAVE_TEXT_AS = new ActionListenerFor.SavingText(1);
    public static final ActionListener OPEN_MACHINE = new ActionListenerFor.OpenMachine();
    public static final ActionListener NEW_MACHINE = new ActionListenerFor.NewMachine();
    public static final ActionListener SAVE_MACHINE = new ActionListenerFor.SavingMachine(0);
    public static final ActionListener SAVE_MACHINE_AS = new ActionListenerFor.SavingMachine(1);
    public static final ActionListener PRINT = new ActionListenerFor.Print();
    public static final ActionListener CUT = new ActionListenerFor.TextEdit(1);
    public static final ActionListener COPY = new ActionListenerFor.TextEdit(0);
    public static final ActionListener PASTE = new ActionListenerFor.TextEdit(2);
    public static final ActionListener SELECT_ALL = new ActionListenerFor.TextEdit(3);
    public static final ActionListener FIND = new ActionListenerFor.Find();
    public static final ActionListener REPLACE = new ActionListenerFor.Replace();
    public static final ActionListener UNDO = new ActionListenerFor.Undo();
    public static final ActionListener REDO = new ActionListenerFor.RedoListener();
    public static final ActionListener PREFERENCES = new ActionListenerFor.Preferences();
    public static final ActionListener MACHINE_INSTRUCTIONS = new ActionListenerFor.MachineInstructions();
    public static final ActionListener MICROINSTRUCTIONS = new ActionListenerFor.Microinstructions();
    public static final ActionListener HARDWARE = new ActionListenerFor.HardwareModules();
    public static final ActionListener EQUS = new ActionListenerFor.EQUs();
    public static final ActionListener DEBUG_MODE = new ActionListenerFor.DebugMode();
    public static final ActionListener ASSEMBLE = new ActionListenerFor.Assemble();
    public static final ActionListener ASSEMBLE_AND_LOAD = new ActionListenerFor.AssembleAndLoad();
    public static final ActionListener CLEAR_ASSEMBLE_LOAD_AND_RUN = new ActionListenerFor.ClearAssembleLoadAndRun();
    public static final ActionListener RUN = new ActionListenerFor.Run();
    public static final ActionListener STOP = new ActionListenerFor.StopListener();
    public static final ActionListener CLEAR_EVERYTHING = new ActionListenerFor.ResetEverything();
    public static final ActionListener IO_OPTIONS = new ActionListenerFor.IOConnections();
    public static final ActionListener FILEMENU = new ActionListenerFor.FileMenu();
    public static final ActionListener EDITMENU = new ActionListenerFor.EditMenu();
    public static final ActionListener MODIFYMENU = new ActionListenerFor.ModifyMenu();
    public static final ActionListener EXECUTEMENU = new ActionListenerFor.ExecuteMenu();
    public static final ActionListener VIEWMENU = new ActionListenerFor.ViewMenu();
    public static final ActionListener TEXTMENU = new ActionListenerFor.TextMenu();
    public static final ActionListener HELPMENU = new ActionListenerFor.HelpMenu();
    public static final ActionListener GO_BUTTON = new ActionListenerFor.GoButton();
    public static final ActionListener STEP_BY_INSTR_BUTTON = new ActionListenerFor.StepByInstrButton();
    public static final ActionListener STEP_BY_MICRO_BUTTON = new ActionListenerFor.StepByMicroButton();
    public static final ActionListener BACKUP_ONE_INSTR_BUTTON = new ActionListenerFor.BackupOneInstrButton();
    public static final ActionListener BACKUP_ONE_MICRO_BUTTON = new ActionListenerFor.BackupOneMicroButton();
    public static final ActionListener START_OVER_BUTTON = new ActionListenerFor.StartOverButton();
    protected ActionListener grabAction;
    protected boolean repeat;
    protected int repeatCount;
    protected MacroRecorder recorder;

    public abstract void addDefaultKeyBindings();

    public abstract void addKeyBinding(String var1, ActionListener var2);

    public abstract void removeKeyBinding(String var1);

    public abstract void removeAllKeyBindings();

    public void grabNextKeyStroke(ActionListener listener) {
        this.grabAction = listener;
    }

    public boolean isRepeatEnabled() {
        return this.repeat;
    }

    public void setRepeatEnabled(boolean repeat2) {
        this.repeat = repeat2;
    }

    public int getRepeatCount() {
        return this.repeat ? Math.max(1, this.repeatCount) : 1;
    }

    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    public MacroRecorder getMacroRecorder() {
        return this.recorder;
    }

    public void setMacroRecorder(MacroRecorder recorder) {
        this.recorder = recorder;
    }

    public abstract InputHandler copy();

    public void executeAction(ActionListener listener, Object source, String actionCommand) {
        ActionEvent evt = new ActionEvent(source, 1001, actionCommand);
        if (listener instanceof Wrapper) {
            listener.actionPerformed(evt);
            return;
        }
        boolean _repeat = this.repeat;
        int _repeatCount = this.getRepeatCount();
        if (listener instanceof NonRepeatable) {
            listener.actionPerformed(evt);
        } else {
            for (int i = 0; i < Math.max(1, this.repeatCount); ++i) {
                listener.actionPerformed(evt);
            }
        }
        if (this.grabAction == null) {
            if (this.recorder != null && !(listener instanceof NonRecordable)) {
                if (_repeatCount != 1) {
                    this.recorder.actionPerformed(REPEAT, String.valueOf(_repeatCount));
                }
                this.recorder.actionPerformed(listener, actionCommand);
            }
            if (_repeat) {
                this.repeat = false;
                this.repeatCount = 0;
            }
        }
    }

    public static JEditTextArea getTextArea(EventObject evt) {
        Object o;
        if (evt != null && (o = evt.getSource()) instanceof Component) {
            Component c = (Component)o;
            while (true) {
                if (c instanceof JEditTextArea) {
                    return (JEditTextArea)c;
                }
                if (c == null) break;
                if (c instanceof JPopupMenu) {
                    c = ((JPopupMenu)c).getInvoker();
                    continue;
                }
                c = c.getParent();
            }
        }
        System.err.println("BUG: getTextArea() returning null");
        System.err.println("Report this to Slava Pestov <sp@gjt.org>");
        return null;
    }

    protected void handleGrabAction(KeyEvent evt) {
        ActionListener _grabAction = this.grabAction;
        this.grabAction = null;
        this.executeAction(_grabAction, evt.getSource(), String.valueOf(evt.getKeyChar()));
    }

    public static class insert_char
    implements ActionListener,
    NonRepeatable {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            String str = evt.getActionCommand();
            int repeatCount = textArea.getInputHandler().getRepeatCount();
            if (textArea.isEditable()) {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < repeatCount; ++i) {
                    buf.append(str);
                }
                textArea.overwriteSetSelectedText(buf.toString());
            } else {
                textArea.getToolkit().beep();
            }
        }
    }

    public static class toggle_rect
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea;
            textArea.setSelectionRectangular(!(textArea = InputHandler.getTextArea(evt)).isSelectionRectangular());
        }
    }

    public static class repeat
    implements ActionListener,
    NonRecordable {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            textArea.getInputHandler().setRepeatEnabled(true);
            String actionCommand = evt.getActionCommand();
            if (actionCommand != null) {
                textArea.getInputHandler().setRepeatCount(Integer.parseInt(actionCommand));
            }
        }
    }

    public static class prev_word
    implements ActionListener {
        private boolean select;

        public prev_word(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int line = textArea.getCaretLine();
            int lineStart = textArea.getLineStartOffset(line);
            String lineText = textArea.getLineText(textArea.getCaretLine());
            if ((caret -= lineStart) == 0) {
                if (lineStart == 0) {
                    textArea.getToolkit().beep();
                    return;
                }
                --caret;
            } else {
                String noWordSep = (String)textArea.getSyntaxDocument().getProperty("noWordSep");
                caret = TextUtilities.findWordStart(lineText, caret, noWordSep);
            }
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), lineStart + caret);
            } else {
                textArea.setCaretPosition(lineStart + caret);
            }
        }
    }

    public static class prev_page
    implements ActionListener {
        private boolean select;

        public prev_page(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int firstLine = textArea.getFirstLine();
            int visibleLines = textArea.getVisibleLines();
            int line = textArea.getCaretLine();
            if (firstLine < visibleLines) {
                firstLine = visibleLines;
            }
            textArea.setFirstLine(firstLine - visibleLines);
            int caret = textArea.getLineStartOffset(Math.max(0, line - visibleLines));
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret);
            } else {
                textArea.setCaretPosition(caret);
            }
        }
    }

    public static class prev_line
    implements ActionListener {
        private boolean select;

        public prev_line(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int line = textArea.getCaretLine();
            if (line == 0) {
                textArea.getToolkit().beep();
                return;
            }
            int magic = textArea.getMagicCaretPosition();
            if (magic == -1) {
                magic = textArea.offsetToX(line, caret - textArea.getLineStartOffset(line));
            }
            caret = textArea.getLineStartOffset(line - 1) + textArea.xToOffset(line - 1, magic);
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret);
            } else {
                textArea.setCaretPosition(caret);
            }
            textArea.setMagicCaretPosition(magic);
        }
    }

    public static class prev_char
    implements ActionListener {
        private boolean select;

        public prev_char(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            if (caret == 0) {
                textArea.getToolkit().beep();
                return;
            }
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret - 1);
            } else {
                textArea.setCaretPosition(caret - 1);
            }
        }
    }

    public static class overwrite
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea;
            textArea.setOverwriteEnabled(!(textArea = InputHandler.getTextArea(evt)).isOverwriteEnabled());
        }
    }

    public static class next_word
    implements ActionListener {
        private boolean select;

        public next_word(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String lineText;
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int line = textArea.getCaretLine();
            int lineStart = textArea.getLineStartOffset(line);
            if ((caret -= lineStart) == (lineText = textArea.getLineText(textArea.getCaretLine())).length()) {
                if (lineStart + caret == textArea.getSyntaxDocumentLength()) {
                    textArea.getToolkit().beep();
                    return;
                }
                ++caret;
            } else {
                String noWordSep = (String)textArea.getSyntaxDocument().getProperty("noWordSep");
                caret = TextUtilities.findWordEnd(lineText, caret, noWordSep);
            }
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), lineStart + caret);
            } else {
                textArea.setCaretPosition(lineStart + caret);
            }
        }
    }

    public static class next_page
    implements ActionListener {
        private boolean select;

        public next_page(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int lineCount = textArea.getLineCount();
            int firstLine = textArea.getFirstLine();
            int visibleLines = textArea.getVisibleLines();
            int line = textArea.getCaretLine();
            if ((firstLine += visibleLines) + visibleLines >= lineCount - 1) {
                firstLine = lineCount - visibleLines;
            }
            textArea.setFirstLine(firstLine);
            int caret = textArea.getLineStartOffset(Math.min(textArea.getLineCount() - 1, line + visibleLines));
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret);
            } else {
                textArea.setCaretPosition(caret);
            }
        }
    }

    public static class next_line
    implements ActionListener {
        private boolean select;

        public next_line(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int line = textArea.getCaretLine();
            if (line == textArea.getLineCount() - 1) {
                textArea.getToolkit().beep();
                return;
            }
            int magic = textArea.getMagicCaretPosition();
            if (magic == -1) {
                magic = textArea.offsetToX(line, caret - textArea.getLineStartOffset(line));
            }
            caret = textArea.getLineStartOffset(line + 1) + textArea.xToOffset(line + 1, magic);
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret);
            } else {
                textArea.setCaretPosition(caret);
            }
            textArea.setMagicCaretPosition(magic);
        }
    }

    public static class next_char
    implements ActionListener {
        private boolean select;

        public next_char(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            if (caret == textArea.getSyntaxDocumentLength()) {
                textArea.getToolkit().beep();
                return;
            }
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret + 1);
            } else {
                textArea.setCaretPosition(caret + 1);
            }
        }
    }

    public static class insert_tab
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            if (!textArea.isEditable()) {
                textArea.getToolkit().beep();
                return;
            }
            textArea.overwriteSetSelectedText("\t");
        }
    }

    public static class insert_break
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            if (!textArea.isEditable()) {
                textArea.getToolkit().beep();
                return;
            }
            textArea.setSelectedText("\n");
        }
    }

    public static class document_home
    implements ActionListener {
        private boolean select;

        public document_home(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), 0);
            } else {
                textArea.setCaretPosition(0);
            }
        }
    }

    public static class home
    implements ActionListener {
        private boolean select;

        public home(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int firstLine = textArea.getFirstLine();
            int firstOfLine = textArea.getLineStartOffset(textArea.getCaretLine());
            int firstVisibleLine = firstLine == 0 ? 0 : firstLine + textArea.getElectricScroll();
            int firstVisible = textArea.getLineStartOffset(firstVisibleLine);
            if (caret == 0) {
                textArea.getToolkit().beep();
                return;
            }
            caret = !Boolean.TRUE.equals(textArea.getClientProperty(InputHandler.SMART_HOME_END_PROPERTY)) ? firstOfLine : (caret == firstVisible ? 0 : (caret == firstOfLine ? firstVisible : firstOfLine));
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret);
            } else {
                textArea.setCaretPosition(caret);
            }
        }
    }

    public static class document_end
    implements ActionListener {
        private boolean select;

        public document_end(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), textArea.getSyntaxDocumentLength());
            } else {
                textArea.setCaretPosition(textArea.getSyntaxDocumentLength());
            }
        }
    }

    public static class end
    implements ActionListener {
        private boolean select;

        public end(boolean select) {
            this.select = select;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int caret = textArea.getCaretPosition();
            int lastOfLine = textArea.getLineEndOffset(textArea.getCaretLine()) - 1;
            int lastVisibleLine = textArea.getFirstLine() + textArea.getVisibleLines();
            lastVisibleLine = lastVisibleLine >= textArea.getLineCount() ? Math.min(textArea.getLineCount() - 1, lastVisibleLine) : (lastVisibleLine -= textArea.getElectricScroll() + 1);
            int lastVisible = textArea.getLineEndOffset(lastVisibleLine) - 1;
            int lastDocument = textArea.getSyntaxDocumentLength();
            if (caret == lastDocument) {
                textArea.getToolkit().beep();
                return;
            }
            caret = !Boolean.TRUE.equals(textArea.getClientProperty(InputHandler.SMART_HOME_END_PROPERTY)) ? lastOfLine : (caret == lastVisible ? lastDocument : (caret == lastOfLine ? lastVisible : lastOfLine));
            if (this.select) {
                textArea.select(textArea.getMarkPosition(), caret);
            } else {
                textArea.setCaretPosition(caret);
            }
        }
    }

    public static class delete_word
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            String lineText;
            int line;
            int lineStart;
            int caret;
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int start = textArea.getSelectionStart();
            if (start != textArea.getSelectionEnd()) {
                textArea.setSelectedText("");
            }
            if ((caret = start - (lineStart = textArea.getLineStartOffset(line = textArea.getCaretLine()))) == (lineText = textArea.getLineText(textArea.getCaretLine())).length()) {
                if (lineStart + caret == textArea.getSyntaxDocumentLength()) {
                    textArea.getToolkit().beep();
                    return;
                }
                ++caret;
            } else {
                String noWordSep = (String)textArea.getSyntaxDocument().getProperty("noWordSep");
                caret = TextUtilities.findWordEnd(lineText, caret, noWordSep);
            }
            try {
                textArea.getSyntaxDocument().remove(start, caret + lineStart - start);
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
        }
    }

    public static class delete
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            if (!textArea.isEditable()) {
                textArea.getToolkit().beep();
                return;
            }
            if (textArea.getSelectionStart() != textArea.getSelectionEnd()) {
                textArea.setSelectedText("");
            } else {
                int caret = textArea.getCaretPosition();
                if (caret == textArea.getSyntaxDocumentLength()) {
                    textArea.getToolkit().beep();
                    return;
                }
                try {
                    textArea.getSyntaxDocument().remove(caret, 1);
                }
                catch (BadLocationException bl) {
                    bl.printStackTrace();
                }
            }
        }
    }

    public static class backspace_word
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            int start = textArea.getSelectionStart();
            if (start != textArea.getSelectionEnd()) {
                textArea.setSelectedText("");
            }
            int line = textArea.getCaretLine();
            int lineStart = textArea.getLineStartOffset(line);
            int caret = start - lineStart;
            String lineText = textArea.getLineText(textArea.getCaretLine());
            if (caret == 0) {
                if (lineStart == 0) {
                    textArea.getToolkit().beep();
                    return;
                }
                --caret;
            } else {
                String noWordSep = (String)textArea.getSyntaxDocument().getProperty("noWordSep");
                caret = TextUtilities.findWordStart(lineText, caret, noWordSep);
            }
            try {
                textArea.getSyntaxDocument().remove(caret + lineStart, start - (caret + lineStart));
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
        }
    }

    public static class backspace
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea(evt);
            if (!textArea.isEditable()) {
                textArea.getToolkit().beep();
                return;
            }
            if (textArea.getSelectionStart() != textArea.getSelectionEnd()) {
                textArea.setSelectedText("");
            } else {
                int caret = textArea.getCaretPosition();
                if (caret == 0) {
                    textArea.getToolkit().beep();
                    return;
                }
                try {
                    textArea.getSyntaxDocument().remove(caret - 1, 1);
                }
                catch (BadLocationException bl) {
                    bl.printStackTrace();
                }
            }
        }
    }

    public static interface MacroRecorder {
        public void actionPerformed(ActionListener var1, String var2);
    }

    public static interface Wrapper {
    }

    public static interface NonRecordable {
    }

    public static interface NonRepeatable {
    }
}

