/* TextBox: This class extends the Panel component from java.awt to */
/*    provide a standard Static  graphic and rectangles look     */


import java.awt.*;

public class TextBox extends Panel {
   Image     image;
   boolean   fgColor;
   boolean   fill;
   Rectangle rect;
   public TextBox (Image im) {
      image=im;
   }
   public TextBox (Rectangle rc,boolean fillit,boolean fg) {
      rect=rc;
      fgColor=fg;
      fill=fillit;
   }

   public Insets insets () {
      return new Insets (0, 0, 0, 0);
   }

   public void paint (Graphics g) {
      Dimension d=size();
      if (image != null) {
         g.drawImage(image,
             (d.width -image.getWidth(null))/2,
             (d.height-image.getHeight(null))/2,
             this);
      }
      if (rect!=null) {
         if (fgColor) {
            g.setColor (getForeground ());
         } else {
            g.setColor (getBackground ());
         }
         if (fill) {
            g.fillRect (0,0,d.width-1,d.height-1);
         } else {
            g.drawRect (0,0,d.width-1,d.height-1);
         }
      }
   }

   private String title;
}
