/* DetailsCanvas: This class paints a details view.  It is used by the */
/*    DataContainer object.                                            */

package extend.awt;

import java.awt.*;

public class DetailsCanvas extends Canvas {

   protected DetailsCanvas (DataContainer dc, Scrollbar hScroll, boolean freeList) {

      setBackground (Color.white);

      parent = dc;
      scrollBar = hScroll;
      left = 0;
      freeSpotList = freeList;
   }

   protected void setColumns (int first, int last) {

      firstColumn = first;
      lastColumn = last;
   }

   public void paint (Graphics g) {

      FontMetrics fm = getFontMetrics (getFont ());
      int [] widths = determineColumnWidths (fm);

      top = 0;

      if (freeSpotList)
         parent.clearHotSpotList ();

      if (parent.getTitles () != null)
         paintTitles (g, fm, widths);

      parent.drawDataArea (g, top, size ());

      if (parent.getRoot () != null)
         paintTheData (g, fm, widths);

      if (totalWidth (widths) < size ().width)
         scrollBar.disable ();
      else {

         int ticks = size ().width / 10;
         int totalTicks = totalWidth (widths) / 10;
         scrollBar.enable ();
         scrollBar.setValues (scrollBar.getValue (), ticks, 0, totalTicks - ticks);
      }
   }

   private int [] determineColumnWidths (FontMetrics fm) {

      int [] widths = null;
      ContainerItem item = parent.getRoot ();

      widths = setWidths (widths, parent.getTitles (), fm);

      if (item != null)
         item = item.getFirst ();

      while (item != null) {

         widths = setWidths (widths, item.getColumns (), fm);

         item = item.getNext ();
      }

      return widths;
   }

   private int [] setWidths (int [] widths, Object [] data, FontMetrics fm) {

      if (data != null) {

         if (widths == null)

            widths = new int [data.length];

         else if (widths.length < data.length) {

            int [] newOne = new int [data.length];

            System.arraycopy (widths, 0, newOne, 0, widths.length);

            widths = newOne;
         }

         for (int loop = 0; loop < data.length; loop++) {

            if (data [loop] != null) {

               int width = Utilities.itemWidth (fm, data [loop], this);

               if (width > widths [loop])
                  widths [loop] = width;
            }   
         }
      }

      return widths;
   }

   private int totalWidth (int [] widths) {

      int result = 0;
      int max = (lastColumn == All_Columns) ? widths.length : lastColumn + 1;

      if (widths != null)
         for (int loop = firstColumn; loop < max; loop++)
            result += widths [loop] + 12;

      return result;
   }

   private void paintTitles (Graphics g, FontMetrics fm, int [] widths) {

      Object [] titles = parent.getTitles ();
      int lHeight = Utilities.lineHeight (fm, titles, this);
      int bottom = top + lHeight;
      int x = left;
      int max = (lastColumn == All_Columns) ? titles.length : lastColumn + 1;

      g.setColor (Color.lightGray);
      g.fillRect (0, 0, size ().width, bottom + 6);

      for (int loop = firstColumn; loop < max; loop++) {

         g.setColor (Color.darkGray);
         g.drawLine (x, top, x + widths [loop] + 8, top);
//       g.drawLine (x, top + 1, x + widths [loop] + 7, top + 1);
         g.drawLine (x, top + 1, x, bottom + 3);
//       g.drawLine (x + 1, top + 2, x + 1, bottom + 2);

         g.setColor (Color.white);
//       g.drawLine (x + 2, bottom + 2, x + widths [loop] + 8, bottom + 2);
         g.drawLine (x + 1, bottom + 3, x + widths [loop] + 8, bottom + 3);
         g.drawLine (x + widths [loop] + 8, top + 1,
                     x + widths [loop] + 8, bottom + 1);
//       g.drawLine (x + widths [loop] + 7, top + 2,
//                   x + widths [loop] + 7, bottom + 1);

         g.setColor (Color.black);

         if (titles [loop] != null)
            if (titles [loop] instanceof Image)
               g.drawImage ((Image) (titles [loop]), x + 4, top + 4, this);
            else
               g.drawString (titles [loop].toString (), x + 4, bottom - 1);

         x += widths [loop] + 12;
      }

      top = bottom + 6;
   }

   private void paintTheData (Graphics g, FontMetrics fm, int [] widths) {

      ContainerItem item = parent.getRoot ();
      int lines = 0;
      int lHeight;
      int y = top;
      int width = 0;
      int [] attributes = parent.getAttributes ();
      int max = (lastColumn == All_Columns) ? widths.length : lastColumn + 1;

      if (attributes != null) {

         int x = left + 4;

         g.setColor (Color.darkGray);

         for (int loop = firstColumn; loop < max; loop++) {

            x += widths [loop] + 12;

            if (((attributes [loop] >> 2) % 2) == 1)
               g.drawLine (x - 6, top, x - 6, size ().height);
         }
      }

      if (item != null)
         item = item.getItem (parent.getFirst ());

      while ((item != null) && (y < size ().height - 20)) {

         lHeight = Utilities.lineHeight (fm, item.getColumns (), this);
         y += lHeight;

         g.setColor (Color.black);

         if (item.isSelected ()) {

            g.setColor (new Color (0, 0, 64));
            g.fillRect (2, y - lHeight + 4, size ().width - 4, lHeight);
            g.setColor (Color.white);
         }

         parent.addHotSpot (2, y - lHeight, size ().width - 4, lHeight, item,
                            DataContainer.Selectable, this);

         if (item.getColumns () != null)
            drawColumns (g, fm, item.getColumns (), widths, y, attributes,
                         lHeight);

         lines++;

         item = item.getNext ();
      }

      parent.setLines (lines);
   }

   private void drawColumns (Graphics g, FontMetrics fm, Object [] cols,
                             int [] widths, int y, int [] attributes,
                             int lHeight) {

      int x = left + 4;
      int tx = 0;
      int just = DataContainer.Left_Justify;
      int max = (lastColumn == All_Columns) ? cols.length : lastColumn + 1;
      int delta = (lHeight - fm.getHeight ()) / 2;

      for (int loop = firstColumn; loop < max; loop++) {

         int width = 0;

         if (cols [loop] != null)
            width = Utilities.itemWidth (fm, cols [loop], this);

         if (attributes != null)
            just = attributes [loop] % 4;

         switch (just) {

            case DataContainer.Left_Justify: 
               tx = x;
               break;

            case DataContainer.Center_Justify:
               tx = x + ((widths [loop] - width) / 2);
               break;

            case DataContainer.Right_Justify:
               tx = x + widths [loop] - width;
               break;
         }

         if (cols [loop] != null)
            if (cols [loop] instanceof Image)
               g.drawImage ((Image) (cols [loop]), tx, y - lHeight + 4, this);
            else
               g.drawString (cols [loop].toString (), tx, y - delta);

         x += widths [loop] + 12;
      }
   }

   protected void horizontalScroll () {

      left = -(scrollBar.getValue () * 10);
   }

   private DataContainer parent;
   private int firstColumn;
   private int lastColumn;
   private Scrollbar scrollBar;
   private int top;
   private int left;
   private boolean freeSpotList;

   protected static final int All_Columns = -1;
}
