/* HotSpot: This class provides a list of places on a control where the */
/*    mouse may be clicked.                                             */

package extend.awt;

import java.awt.*;

public class HotSpot {

   public HotSpot (Rectangle source, Object ref, int kind) {

      area = source;
      reference = ref;
      type = kind;
   }

   public void add (HotSpot tail) {

      HotSpot work = this;

      while (work.next != null)
         work = work.next;

      work.next = tail;
   }

   public void chop () {next = null;}

   public HotSpot hit (int x, int y) {

      HotSpot result = this;
      boolean notDone = true;

      while (notDone) {

         notDone = !(result.area.inside (x, y));

         if (notDone) {

            result = result.next;
            notDone = (result != null);
         }
      }

      return result;
   }

   public int getType () {return type;}

   public Object getReference () {return reference;}

   private Rectangle area;
   private Object reference;
   private int type;
   private HotSpot next;
}
