/* NBSimpleLook: This class implements the sizing and painting methods for */
/*    the Simple notebook style.                                           */

package extend.awt;

import java.awt.*;

public class NBSimpleLook implements NBRenderer {

   protected NBSimpleLook (Notebook nb) {

      parent = nb;
      first = 0;
   }

   public Insets insets (FontMetrics fm, Dimension d) {

      int top = 4;
      int left = 4;
      int right = 4;
      int bottom = 4;

      switch (parent.getOrientation ()) {

         case Notebook.Top:
            top = determineVerticalNeeds (fm);
            break;

         case Notebook.Left:
            left = maxWidth (fm);
            break;

         case Notebook.Right:
            right = maxWidth (fm);
            break;

         case Notebook.Bottom:
            bottom = determineVerticalNeeds (fm);
            break;
      }

      return (space = new Insets (top, left, bottom, right));
   }

   private int determineVerticalNeeds (FontMetrics fm) {

      Object [] tabs = parent.getTabs ();
      Dimension d = parent.size ();
      int rows = ((totalWidth (fm, tabs) - 1) / (d.width - 1)) + 1;
      int index = 0;
      int sum = 0;
      int width = 0;

      if (rows < 1)

         return 0;

      else {

         groups = new int [rows];

         for (int loop = 0; loop < tabs.length; loop++) {

            width = Utilities.itemWidth (fm, tabs [loop], parent) +
                    fm.stringWidth ("  ") + 4;

            if (width + sum > d.width) {

               groups [index] = loop;
               index++;
               sum = 0;
            }

            sum += width;
         }

         groups [index] = tabs.length;

         return (Utilities.lineHeight (fm, tabs, parent) + 6) *
                rows + 6;
      }
   }

   private int totalWidth (FontMetrics fm, Object [] tabs) {

      int sum = 0;

      if (tabs != null) 
         for (int loop = 0; loop < tabs.length; loop++)
            sum += Utilities.itemWidth (fm, tabs [loop], parent) +
                   fm.stringWidth ("  ") + 4;

      return sum;
   }

   private int maxWidth (FontMetrics fm) {

      Object [] tabs = parent.getTabs ();
      int max = 0;

      if (tabs != null) 
         for (int loop = 0; loop < tabs.length; loop++)
            max = Math.max (max, Utilities.itemWidth (fm, tabs [loop], parent) +
                                 fm.stringWidth ("  "));

      return (max + 6);
   }

   public void paintTheLook (Graphics g, FontMetrics fm, Dimension d) {

      g.setColor (Color.darkGray);
      g.drawLine (d.width - space.right, space.top - 1,
                  d.width - space.right, d.height - space.bottom);
      g.drawLine (d.width - space.right + 1, space.top - 2,
                  d.width - space.right + 1, d.height - space.bottom);
      g.drawLine (space.left - 1, d.height - space.bottom,
                  d.width - space.right + 1, d.height - space.bottom);
      g.drawLine (space.left - 2, d.height - space.bottom + 1,
                  d.width - space.right + 1, d.height - space.bottom + 1);

      g.setColor (Color.white);
      g.drawLine (space.left - 1, space.top - 1,
                  space.left - 1, d.height - space.bottom);
      g.drawLine (space.left - 2, space.top - 1,
                  space.left - 2, d.height - space.bottom + 1);
      g.drawLine (space.left - 2, space.top - 1,
                  d.width - space.right, space.top - 1);
      g.drawLine (space.left - 2, space.top - 2,
                  d.width - space.right + 1, space.top - 2);

      switch (parent.getOrientation ()) {

         case Notebook.Top:
            drawTabs (g, fm, new Point (4, space.top - 5));
            break;

         case Notebook.Left:
            drawTabs (g, fm, new Point (space.left - 2, space.top + 2));
            break;

         case Notebook.Right:
            drawTabs (g, fm, new Point (d.width - space.left - space.right + 2,
                      space.top + 2));
            break;

         case Notebook.Bottom:
            drawTabs (g, fm, new Point (4, d.height - space.bottom));
            break;
      }
   }

   private void drawTabs (Graphics g, FontMetrics fm, Point location) {

      Object [] tabs = parent.getTabs ();
      int orientation = parent.getOrientation ();
      Color [] bgColors = parent.getBgColors ();
      Color [] fgColors = parent.getFgColors ();
      int lHeight = Utilities.lineHeight (fm, tabs, parent);
      Point p = new Point (location.x, location.y);
      int item = 0;
      int max = parent.size ().height - space.bottom;
      boolean atEnd = false;

      if (orientation == Notebook.Top || orientation == Notebook.Bottom) {

         for (index = 0; parent.getCurrentTab () >= groups [index]; index++);
         index = (index + 1) % groups.length;
         item = (index == 0) ? 0 : groups [index - 1];

         location.y += ((lHeight + 6) * (groups.length - 1)) *
                       ((orientation == Notebook.Top) ? -1 : 1);

         p.y = location.y;

      } else {

         item = first;

         if (first > 0)
            drawUpArrow (g, fm, orientation, p);
      }

      for (int loop = 0; loop < tabs.length && !atEnd; loop++) {

         switch (orientation) {

            case Notebook.Top:
               if (item == groups [index] || (item == 0 && loop > 0)) {

                  location.y += lHeight + 6;
                  p.x = location.x;
                  p.y = location.y;
                  index = (index + 1) % groups.length;
               }

               drawNorthTab (g, fm, tabs [item], bgColors [item],
                             fgColors [item], p, item, lHeight);
               break;

            case Notebook.Left:
               drawWestTab (g, fm, tabs [item], bgColors [item],
                            fgColors [item], p, item, lHeight);

               if (item < (tabs.length - 1))
                  if (lHeight + 7 +
                      ((item == tabs.length - 2) ?
                        0 : fm.getHeight ()) > max - p.y) {

                      drawDownArrow (g, fm, orientation, item);
                      atEnd = true;
                  }

               if (!atEnd)
                  atEnd = (item == tabs.length - 1);

               break;
  
            case Notebook.Right:
               drawEastTab (g, fm, tabs [item], bgColors [item],
                            fgColors [item], p, item, lHeight);

               if (item < (tabs.length - 1))
                  if (lHeight + 7 +
                      ((item == tabs.length - 2) ?
                        0 : fm.getHeight ()) > max - p.y) {

                      drawDownArrow (g, fm, orientation, loop);
                      atEnd = true;
                  }

               if (!atEnd)
                  atEnd = (item == tabs.length - 1);

               break;
  
            case Notebook.Bottom:
               if (item == groups [index] || (item == 0 && loop > 0)) {

                  location.y -= lHeight + 6;
                  p.x = location.x;
                  p.y = location.y;
                  index = (index + 1) % groups.length;
               }

               drawSouthTab (g, fm, tabs [item], bgColors [item],
                             fgColors [item], p, item, lHeight);
               break;
         }

         item = (item + 1) % tabs.length;
      }
   }

   private int widthOfTab (int which, int x) {

      int count = groups [index] - ((index == 0) ? 0 : groups [index - 1]);
      int width;

      if (which == groups [index] - 1)
         width = parent.size ().width - x - 8;
      else
         width = ((parent.size ().width - 4) / count) - 4;

      return width;
   }

   private void drawNorthTab (Graphics g, FontMetrics fm, Object tab,
                              Color bgc, Color fgc, Point p, int index,
                              int lHeight) {

      int currentTab = parent.getCurrentTab ();
      boolean thisIsIt = (index == currentTab);
      int ly = p.y - lHeight - ((thisIsIt) ? 2 : 0) - 2;
      int dx = (groups.length == 1) ?
               Utilities.itemWidth (fm, tab, parent) + fm.stringWidth ("  ") :
               widthOfTab (index, p.x);
      int delta = (lHeight - fm.getHeight ()) / 2;
      int ax = (thisIsIt) ? 2 : 0;
      int tx = p.x + ((dx - Utilities.itemWidth (fm, tab, parent)) / 2) + 3;

      g.setColor (Color.white);

      if (index != currentTab + 1) {

         g.drawLine (p.x - ax, p.y + 2, p.x - ax, ly);
         g.drawLine (p.x - ax + 1, p.y + 2, p.x - ax + 1, ly);
      }

      g.drawLine (p.x - ax + 2, ly, p.x + ax + dx + 1, ly);
      g.drawLine (p.x - ax + 2, ly - 1, p.x + ax + dx + 1, ly - 1);

      g.setColor (Color.darkGray);

      g.drawLine (p.x + ax + dx + 2, ly, p.x + ax + dx + 2, p.y + ax + 2);
      g.drawLine (p.x + ax + dx + 3, ly + 1, p.x + ax + dx + 3, p.y + ax + 2);

      g.setColor (bgc);

      g.fillRect (p.x + 3 - ((thisIsIt) ? 2 : 0), ly + 2,
                  dx - 2 + ((thisIsIt) ? 4 : 0), lHeight);

      g.setColor (fgc);

      if (tab instanceof Image)
         g.drawImage ((Image) tab, tx, p.y - lHeight + 4 - ((thisIsIt) ? 2 : 0), parent);
      else
         g.drawString (tab.toString (), tx, p.y - delta - ((thisIsIt) ? 2 : 0) - 2);

      if (thisIsIt) {

         g.setColor (Color.lightGray);

         g.drawLine (p.x, space.top - 1, p.x + dx + 3, space.top - 1);
         g.drawLine (p.x, space.top - 2, p.x + dx + 3, space.top - 2);
      }

      parent.addHotSpot (p.x + 2, ly, dx + 2, lHeight, Notebook.Tab_Click,
                         new Integer (index));

      p.x += (dx + 4);
   }

   private void drawWestTab (Graphics g, FontMetrics fm, Object tab,
                             Color bgc, Color fgc, Point p, int index,
                             int lHeight) {

      int currentTab = parent.getCurrentTab ();
      boolean thisIsIt = (index == currentTab);
      int lx = space.left - 4;
      int dy = lHeight + 2;
      int delta = (lHeight - fm.getHeight ()) / 2;
      int ax = (thisIsIt) ? 0 : 2;
      int ay = (thisIsIt) ? 2 : 0;

      g.setColor (Color.white);

      if (index != currentTab + 1) {

         g.drawLine (ax, p.y - ay, lx + 1, p.y - ay);
         g.drawLine (ax, p.y - ay + 1, lx + 1, p.y - ay + 1);
      }

      g.drawLine (ax, p.y - ay + 2, ax, p.y + dy + ay + 3);
      g.drawLine (ax + 1, p.y - ay + 2, ax + 1, p.y + dy + ay + 2);

      g.setColor (Color.darkGray);

      g.drawLine (ax + 1, p.y + dy + ay + 3, lx + 1, p.y + dy + ay + 3);
      g.drawLine (ax, p.y + dy + ay + 4, lx + 1, p.y + dy + ay + 4);

      g.setColor (bgc);

      g.fillRect (ax + 3, p.y + 3 - (thisIsIt ? 2 : 0),
                  lx - 4, dy + (thisIsIt ? 3 : -1));

      g.setColor (fgc);

      if (tab instanceof Image)
         g.drawImage ((Image) tab, ax + 6, p.y + 4, parent);
      else
         g.drawString (tab.toString (), ax + 6, p.y + dy - delta - 3);

      if (thisIsIt) {

         g.setColor (Color.lightGray);

         g.drawLine (lx + 2, p.y, lx + 2, p.y + dy + ay + 2);
         g.drawLine (lx + 3, p.y, lx + 3, p.y + dy + ay + 2);
      }

      parent.addHotSpot (ax + 2, p.y, lx, dy, Notebook.Tab_Click,
                        new Integer (index));

      p.y += (dy + 5);
   }

   private void drawEastTab (Graphics g, FontMetrics fm, Object tab,
                             Color bgc, Color fgc, Point p, int index,
                             int lHeight) {

      int currentTab = parent.getCurrentTab ();
      boolean thisIsIt = (index == currentTab);
      int lx = p.x + space.right - 2;
      int dy = lHeight + 2;
      int delta = (lHeight - fm.getHeight ()) / 2;
      int ay = (thisIsIt) ? 2 : 0;

      if (index != currentTab + 1) {

         g.setColor (Color.white);

         g.drawLine (p.x + 4, p.y - ay, lx + ay, p.y - ay);
         g.drawLine (p.x + 4 - ((thisIsIt) ? 1 : 0), p.y - ay + 1, lx + ay - 1, p.y - ay + 1);
      }

      g.setColor (Color.darkGray);

      g.drawLine (lx + ay - 1, p.y - ay + 2, lx + ay - 1, p.y + dy + ay + 2);
      g.drawLine (lx + ay, p.y - ay + 1, lx + ay, p.y + dy + ay + 2);

      g.drawLine (p.x + 4, p.y + dy + ay + 3, lx + ay, p.y + dy + ay + 3);
      g.drawLine (p.x + 4, p.y + dy + ay + 4, lx + ay, p.y + dy + ay + 4);

      g.setColor (bgc);

      g.fillRect (p.x + 6 + ((thisIsIt) ? 2 : 0), p.y + 3 - (thisIsIt ? 2 : 0),
                  lx - p.x - 8, dy + (thisIsIt ? 3 : -1));

      g.setColor (fgc);

      if (tab instanceof Image)
         g.drawImage ((Image) tab, p.x + 8 + ((thisIsIt) ? 2 : 0), p.y + 4, parent);
      else
         g.drawString (tab.toString (), p.x + 8 + ((thisIsIt) ? 2 : 0), p.y + dy - delta - 3);

      if (thisIsIt) {

         g.setColor (Color.lightGray);

         g.drawLine (p.x + 2, p.y, p.x + 2, p.y + dy + ay + 2);
         g.drawLine (p.x + 3, p.y, p.x + 3, p.y + dy + ay + 2);
      }

      parent.addHotSpot (p.x + 4, p.y, lx - p.x, dy, Notebook.Tab_Click,
                         new Integer (index));

      p.y += (dy + 5);
   }

   private void drawSouthTab (Graphics g, FontMetrics fm, Object tab,
                              Color bgc, Color fgc, Point p, int index,
                              int lHeight) {

      int currentTab = parent.getCurrentTab ();
      boolean thisIsIt = (index == currentTab);
      int ly = p.y + lHeight + ((thisIsIt) ? 2 : 0) + 8;
      int dx = (groups.length == 1) ?
               Utilities.itemWidth (fm, tab, parent) + fm.stringWidth ("  ") :
               widthOfTab (index, p.x);
      int delta = (lHeight - fm.getHeight ()) / 2;
      int ax = (thisIsIt) ? 2 : 0;
      int tx = p.x + ((dx - Utilities.itemWidth (fm, tab, parent)) / 2) + 3;

      g.setColor (Color.white);

      if (index != currentTab + 1) {

         g.drawLine (p.x - ax, p.y + 2, p.x - ax, ly);
         g.drawLine (p.x - ax + 1, p.y + 2, p.x - ax + 1, ly);

         if (index == currentTab)
            g.drawLine (p.x - ax + 1, p.y + 1, p.x - ax + 1, p.y + 1);

         if (index == 0 && index == currentTab)
            g.drawLine (p.x - ax, p.y + 1, p.x - ax + 1, p.y);
      }

      g.setColor (Color.darkGray);

      g.drawLine (p.x - ax + 1, ly, p.x + ax + dx + 1, ly);
      g.drawLine (p.x - ax + 2, ly - 1, p.x + ax + dx + 1, ly - 1);
      g.drawLine (p.x + ax + dx + 2, ly, p.x + ax + dx + 2, p.y + 2);
      g.drawLine (p.x + ax + dx + 3, ly - 1, p.x + ax + dx + 3, p.y + 2);

      g.setColor (Color.lightGray);

      g.drawLine (p.x + 2, ly - 2, p.x + ax + dx, ly - 2);

      g.setColor (bgc);

      g.fillRect (p.x + 3 - ((thisIsIt) ? 2 : 0), p.y + 4 + ((thisIsIt) ? 2 : 0),
                  dx - 2 + ((thisIsIt) ? 4 : 0), lHeight + 2);

      g.setColor (fgc);

      if (tab instanceof Image)
         g.drawImage ((Image) tab, tx, p.y + 8 - ((thisIsIt) ? 0 : 2), parent);
      else
         g.drawString (tab.toString (), tx, ly - delta - ((thisIsIt) ? 1 : 2) - 5);

      if (thisIsIt) {

         g.setColor (Color.lightGray);

         g.drawLine (p.x, p.y, p.x + dx + 3, p.y);
         g.drawLine (p.x, p.y + 1, p.x + dx + 3, p.y + 1);
      }

      parent.addHotSpot (p.x + 2, p.y, dx + 2, lHeight,
                         Notebook.Tab_Click, new Integer (index));

      p.x += (dx + 4);
   }

   private void drawUpArrow (Graphics g, FontMetrics fm, int side, Point p) {

      int width = fm.getHeight ();
      int x = (side == Notebook.Left) ? space.left - width - 2 :
                                         parent.size ().width - space.right + 2;
      int y = p.y - 2;

      drawArrowFrame (g, x, y, width);
      drawArrow (g, x, y, width, 1);

      parent.addHotSpot (x, y, width, width, Notebook.Up_Click, null);

      p.y = y + width;
   }

   private void drawDownArrow (Graphics g, FontMetrics fm, int side, int which) {

      int width = fm.getHeight ();
      int x = (side == Notebook.Left) ? space.left - width - 2 :
                                         parent.size ().width - space.right + 2;
      int y = parent.size ().height - width - 2;

      drawArrowFrame (g, x, y, width);
      drawArrow (g, x, y + width - 1, width, -1);

      parent.addHotSpot (x, y, width, width, Notebook.Down_Click, null);
   }

   private void drawArrowFrame (Graphics g, int x, int y, int width) {

      g.setColor (Color.darkGray);
      g.drawLine (x, y, x + width - 1, y);
      g.drawLine (x, y, x, y + width - 1);
      g.drawLine (x + 1, y + 1, x + width - 2, y + 1);
      g.drawLine (x + 1, y + 1, x + 1, y + width - 2);

      g.setColor (Color.white);
      g.drawLine (x + 2, y + width - 2, x + width - 1, y + width - 2);
      g.drawLine (x + 1, y + width - 1, x + width - 1, y + width - 1);
      g.drawLine (x + width - 2, y + 2, x + width - 2, y + width - 1);
      g.drawLine (x + width - 1, y + 1, x + width - 1, y + width - 1);
   }

   private void drawArrow (Graphics g, int x, int y, int width, int dir) {

      int [] px = new int [7];
      int [] py = new int [7];

      px [0] = x + (width / 2);   py [0] = y + (4 * dir);
      px [1] = x + width - 4;     py [1] = y + (width / 2 * dir);
      px [2] = px [0] + 2;        py [2] = py [1];
      px [3] = px [2];            py [3] = y + ((width - 4) * dir);
      px [4] = px [0] - 2;        py [4] = py [3];
      px [5] = px [4];            py [5] = py [2];
      px [6] = x + 3;             py [6] = py [1];

      g.setColor (Color.black);
      g.fillPolygon (px, py, 7);
   }

   public void scroll (int amount) {

      first += amount;
   }

   public void setButtonState (int which, boolean newState) {}

   public void setPaging (String text) {}

   private Notebook parent;
   private Insets space;
   private int [] groups;
   private int index;
   private int first;
}
