/* TestBed: This class provides a Frame window in which new GUI components */
/*    may be developed.                                                    */

import java.awt.*;
import extend.awt.*;
import extend.util.*;

public class TestBed extends Frame {

   public TestBed () {

      setTitle ("Java GUI Testbed");
      setBackground (Color.lightGray);
      resize (550, 375);

      ADate today = new ADate ();

      work = new DataContainer (DataContainer.Details_View);
      work.setSelectionType (DataContainer.Forced_Single_Selection);

      work.setTitle ("Golf World Tee Times");

      work.setColumnData ("Date", DataContainer.Center_Justify,
                          DataContainer.No_Vertical_Line);
      work.setColumnData ("Time", DataContainer.Center_Justify,
                          DataContainer.Vertical_Line);
      work.setColumnData (null, DataContainer.Center_Justify,
                          DataContainer.Vertical_Line);
      work.setColumnData ("Group", DataContainer.Left_Justify,
                          DataContainer.Vertical_Line);
      work.setColumnData ("Number", DataContainer.Right_Justify,
                          DataContainer.Vertical_Line);

      work.setSplitBar (1, 33);

      Image icon = Toolkit.getDefaultToolkit ().getImage ("Cust.gif");
      Image bullet = Toolkit.getDefaultToolkit ().getImage ("Ball2.gif");
      Image icon2 = Toolkit.getDefaultToolkit ().getImage ("printer.gif");

      ContainerItem first = new ContainerItem (icon, "The Player 1 Party");
      work.setRoot (first);

      first.setColumn (0, today);
      first.setColumn (1, "7:00");
      first.setColumn (2, icon2);
      first.setColumn (3, "Player 1");
      first.setColumn (4, "4");

      int hours = 7;
      int minutes = 0;
      ContainerItem next = new ContainerItem (icon, "Blah");
      String s;

      for (int loop = 2; loop <= 5; loop++) {

         next = new ContainerItem (icon, "The Player " + loop + " Party");
         next.addToEnd (first);

         minutes += 18;
         if (minutes > 59) {
            hours++;
            minutes -= 60;
         }

         s = "" + minutes;
         if (s.length () == 1) s = "0" + s;

         next.setColumn (0, today);
         next.setColumn (1, hours + ":" + s);
         next.setColumn (2, bullet);
         next.setColumn (3, "Player " + loop);
         next.setColumn (4, "4");
      }

      first.setChildList (new ContainerItem (null, "This is a child"));
      ContainerItem test = new ContainerItem (null, "This is another child");
      next.setExpanded (true);
      next.setChildList (test);
      test.setChildList (new ContainerItem (null, "This is level 3"));
      test.setExpanded (true);
      new ContainerItem (null, "Another level 3").addToEnd (test.getFirstChild ());
      new ContainerItem (null, "This is level 2").addToEnd (test);
      new ContainerItem (null, "Last\nlevel 1").addToEnd (test);

      add ("Center", work);

      Panel p = new Panel ();
      p.add (new Button ("Icon View"));
      p.add (new Button ("List View"));
      p.add (new Button ("Tree View"));
      p.add (new Button ("Details View"));
      p.add (new Button ("Sel all"));
      p.add (new Button ("Desel all"));
      add ("South", p);
   }

   public boolean handleEvent (Event event) {

      if (event.id == Event.WINDOW_DESTROY) {

         dispose ();
         System.exit (0);

      } else if (event.id == Event.LIST_SELECT) {

         System.out.println ("Item selected: " + ((ContainerItem) event.arg).textFor ());
         
      } else if (event.id == Event.LIST_DESELECT) {

         System.out.println ("Item deselected: " + ((ContainerItem) event.arg).textFor ());
         
      } else if (event.id == Event.ACTION_EVENT) {

         if (event.arg instanceof ContainerItem)
            System.out.println ("Item doubleclicked: " + ((ContainerItem) event.arg).textFor ());
         else
            return super.handleEvent (event);
         
      } else
         return super.handleEvent (event);

      return true;
   }
      
   public boolean action (Event event, Object arg) {

      if (arg.equals ("Icon View")) {

         work.setView (DataContainer.Icon_View);

      } else if (arg.equals ("List View")) {

         work.setView (DataContainer.List_View);

      } else if (arg.equals ("Tree View")) {

         work.setView (DataContainer.Tree_View);

      } else if (arg.equals ("Details View")) {

         work.setView (DataContainer.Details_View);

      } else if (arg.equals ("Sel all")) {

         work.setAllSelection (true);

      } else if (arg.equals ("Desel all")) {

         work.setAllSelection (false);

      } else
         return super.action (event, arg);

      return true;
   }

   public static void main (String [] args) {

      TestBed tb = new TestBed ();

      tb.show ();
   }

   private DataContainer work;
}
