/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResetCommand
extends GitCommand<Ref> {
    private String ref = "HEAD";
    private ResetType mode;
    private Collection<String> filepaths = new LinkedList<String>();

    public ResetCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Ref call() throws IOException {
        Ref r;
        this.checkCallable();
        try {
            RevCommit commit;
            ObjectId commitId;
            RepositoryState state = this.repo.getRepositoryState();
            boolean merging = state.equals((Object)RepositoryState.MERGING) || state.equals((Object)RepositoryState.MERGING_RESOLVED);
            boolean cherryPicking = state.equals((Object)RepositoryState.CHERRY_PICKING) || state.equals((Object)RepositoryState.CHERRY_PICKING_RESOLVED);
            try {
                commitId = this.repo.resolve(this.ref);
                if (commitId == null) {
                    throw new JGitInternalException("Invalid ref " + this.ref + " specified");
                }
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotRead, this.ref), e);
            }
            RevWalk rw = new RevWalk(this.repo);
            try {
                commit = rw.parseCommit(commitId);
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotReadCommit, commitId.toString()), e);
            }
            finally {
                rw.release();
            }
            if (!this.filepaths.isEmpty()) {
                this.resetIndexForPaths(commit);
                this.setCallable(false);
                return this.repo.getRef("HEAD");
            }
            RefUpdate ru = this.repo.updateRef("HEAD");
            ru.setNewObjectId(commitId);
            String refName = Repository.shortenRefName(this.ref);
            String message = refName + ": updating " + "HEAD";
            ru.setRefLogMessage(message, false);
            if (ru.forceUpdate() == RefUpdate.Result.LOCK_FAILURE) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotLock, ru.getName()));
            }
            switch (this.mode) {
                case HARD: {
                    this.checkoutIndex(commit);
                    break;
                }
                case MIXED: {
                    this.resetIndex(commit);
                    break;
                }
                case SOFT: {
                    break;
                }
                case KEEP: 
                case MERGE: {
                    throw new UnsupportedOperationException();
                }
            }
            if (this.mode != ResetType.SOFT) {
                if (merging) {
                    this.resetMerge();
                } else if (cherryPicking) {
                    this.resetCherryPick();
                }
            }
            this.setCallable(false);
            r = ru.getRef();
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfResetCommand, e);
        }
        return r;
    }

    public ResetCommand setRef(String ref) {
        this.ref = ref;
        return this;
    }

    public ResetCommand setMode(ResetType mode) {
        if (!this.filepaths.isEmpty()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "[--mixed | --soft | --hard]", "<paths>..."));
        }
        this.mode = mode;
        return this;
    }

    public ResetCommand addPath(String file) {
        if (this.mode != null) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "<paths>...", "[--mixed | --soft | --hard]"));
        }
        this.filepaths.add(file);
        return this;
    }

    private void resetIndexForPaths(RevCommit commit) {
        DirCache dc = null;
        try {
            dc = this.repo.lockDirCache();
            DirCacheEditor edit = dc.editor();
            TreeWalk tw = new TreeWalk(this.repo);
            tw.addTree(new DirCacheIterator(dc));
            tw.addTree(commit.getTree());
            tw.setFilter(PathFilterGroup.createFromStrings(this.filepaths));
            tw.setRecursive(true);
            while (tw.next()) {
                String path = tw.getPathString();
                CanonicalTreeParser tree = tw.getTree(1, CanonicalTreeParser.class);
                if (tree == null) {
                    edit.add(new DirCacheEditor.DeletePath(path));
                    continue;
                }
                final FileMode entryFileMode = tree.getEntryFileMode();
                final ObjectId entryObjectId = tree.getEntryObjectId();
                edit.add(new DirCacheEditor.PathEdit(path){

                    public void apply(DirCacheEntry ent) {
                        ent.setFileMode(entryFileMode);
                        ent.setObjectId(entryObjectId);
                        ent.setLastModified(0L);
                    }
                });
            }
            edit.commit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
    }

    private void resetIndex(RevCommit commit) throws IOException {
        DirCache dc = null;
        try {
            dc = this.repo.lockDirCache();
            dc.clear();
            DirCacheBuilder dcb = dc.builder();
            dcb.addTree(new byte[0], 0, this.repo.newObjectReader(), commit.getTree());
            dcb.commit();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
    }

    private void checkoutIndex(RevCommit commit) throws IOException {
        DirCache dc = null;
        try {
            dc = this.repo.lockDirCache();
            DirCacheCheckout checkout = new DirCacheCheckout(this.repo, dc, commit.getTree());
            checkout.setFailOnConflict(false);
            checkout.checkout();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
    }

    private void resetMerge() throws IOException {
        this.repo.writeMergeHeads(null);
        this.repo.writeMergeCommitMsg(null);
    }

    private void resetCherryPick() throws IOException {
        this.repo.writeCherryPickHead(null);
        this.repo.writeMergeCommitMsg(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResetType {
        SOFT,
        MIXED,
        HARD,
        MERGE,
        KEEP;

    }
}

