/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNXMLCommand;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNPropertiesCommand
extends SVNXMLCommand
implements ISVNPropertyHandler {
    private Map myRevisionProperties;
    private Map myURLProperties;
    private Map myPathProperties;

    protected SVNPropertiesCommand(String name, String[] aliases) {
        super(name, aliases);
        this.clearCollectedProperties();
    }

    protected void clearCollectedProperties() {
        this.myRevisionProperties = new LinkedHashMap();
        this.myURLProperties = new LinkedHashMap();
        this.myPathProperties = new LinkedHashMap();
    }

    protected SVNURL getRevpropURL(SVNRevision revision, Collection targets) throws SVNException {
        SVNErrorMessage err;
        if (revision != SVNRevision.HEAD && revision.getDate() == null && revision.getNumber() < 0L) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Must specify revision as a number, a date or 'HEAD' when operating on revision property");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if (targets.size() != 1) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Wrong number of targets specified");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        String target = (String)targets.iterator().next();
        return this.getSVNEnvironment().getURLFromTarget(target);
    }

    public void handleProperty(File path, SVNPropertyData property) throws SVNException {
        if (!this.myPathProperties.containsKey(path)) {
            this.myPathProperties.put(path, new LinkedList());
        }
        ((Collection)this.myPathProperties.get(path)).add(property);
    }

    public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
        if (!this.myURLProperties.containsKey(url)) {
            this.myURLProperties.put(url, new LinkedList());
        }
        ((Collection)this.myURLProperties.get(url)).add(property);
    }

    public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
        Long key = new Long(revision);
        if (!this.myRevisionProperties.containsKey(key)) {
            this.myRevisionProperties.put(key, new LinkedList());
        }
        ((Collection)this.myRevisionProperties.get(new Long(revision))).add(property);
    }

    protected SVNPropertyData getRevisionProperty(long revision) {
        Long key = new Long(revision);
        if (this.myRevisionProperties.containsKey(key)) {
            return (SVNPropertyData)((List)this.myRevisionProperties.get(new Long(revision))).get(0);
        }
        return null;
    }

    protected SVNPropertyData getPathProperty(File path) {
        if (this.myPathProperties.containsKey(path)) {
            return (SVNPropertyData)((List)this.myPathProperties.get(path)).get(0);
        }
        return null;
    }

    protected SVNPropertyData getURLProperty(SVNURL url) {
        if (this.myURLProperties.containsKey(url)) {
            return (SVNPropertyData)((List)this.myURLProperties.get(url)).get(0);
        }
        return null;
    }

    protected Map getURLProperties() {
        return this.myURLProperties;
    }

    protected Map getPathProperties() {
        return this.myPathProperties;
    }

    protected Map getRevisionProperties() {
        return this.myRevisionProperties;
    }

    protected void printProplist(List props) {
        for (SVNPropertyData property : props) {
            this.getSVNEnvironment().getOut().println("  " + property.getName());
            if (!this.getSVNEnvironment().isVerbose()) continue;
            this.printProperty(property.getValue(), true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void printProperty(SVNPropertyValue value, boolean isPropListLike) {
        if (value.isString()) {
            String stringValue = value.getString();
            if (isPropListLike) {
                stringValue = stringValue + '\n';
                String[] lines = SVNCommandUtil.breakToLines(stringValue);
                for (int i = 0; lines != null && i < lines.length; ++i) {
                    String line = lines[i];
                    this.getSVNEnvironment().getOut().print("    ");
                    this.getSVNEnvironment().getOut().print(line);
                }
                return;
            } else {
                this.getSVNEnvironment().getOut().print(stringValue);
            }
            return;
        } else {
            try {
                if (isPropListLike) {
                    this.getSVNEnvironment().getOut().print("    ");
                }
                this.getSVNEnvironment().getOut().write(value.getBytes());
                if (!isPropListLike) return;
                this.getSVNEnvironment().getOut().println();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void checkBooleanProperty(String name, SVNPropertyValue value) throws SVNException {
        if (!SVNProperty.isBooleanProperty(name)) {
            return;
        }
        String stringValue = value.getString().trim();
        if ("".equals(stringValue) || "off".equalsIgnoreCase(stringValue) || "no".equalsIgnoreCase(stringValue) || "false".equalsIgnoreCase(stringValue)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_PROPERTY_VALUE, "To turn off the {0} property, use ''svn propdel'';\nsetting the property to ''{1}'' will not turn it off.", new Object[]{name, value});
            this.getSVNEnvironment().handleWarning(err, new SVNErrorCode[]{SVNErrorCode.BAD_PROPERTY_VALUE}, this.getSVNEnvironment().isQuiet());
        }
    }
}

