/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNChangelistHandler;
import org.tmatesoft.svn.core.wc.SVNChangelistClient;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class SVNUpdateCommand
extends SVNCommand {
    public SVNUpdateCommand() {
        super("update", new String[]{"up"});
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.NON_RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.SET_DEPTH);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.DIFF3_CMD);
        options.add(SVNOption.FORCE);
        options.add(SVNOption.IGNORE_EXTERNALS);
        options.add(SVNOption.CHANGELIST);
        options.add(SVNOption.EDITOR_CMD);
        options.add(SVNOption.ACCEPT);
        return options;
    }

    public void run() throws SVNException {
        List<String> targets = new LinkedList();
        if (this.getSVNEnvironment().getTargets() != null) {
            targets.addAll(this.getSVNEnvironment().getTargets());
        }
        if ((targets = this.getSVNEnvironment().combineTargets(targets, true)).isEmpty()) {
            targets.add("");
        }
        LinkedList<File> fileTargets = new LinkedList<File>();
        for (String targetName : targets) {
            SVNPath target = new SVNPath(targetName);
            fileTargets.add(target.getFile());
        }
        if (this.getSVNEnvironment().getChangelists() != null) {
            Collection changeLists = this.getSVNEnvironment().getChangelistsCollection();
            SVNDepth clDepth = this.getSVNEnvironment().getDepth();
            if (clDepth == SVNDepth.UNKNOWN) {
                clDepth = SVNDepth.INFINITY;
            }
            SVNChangelistClient changelistClient = this.getSVNEnvironment().getClientManager().getChangelistClient();
            final LinkedList targetPaths = new LinkedList();
            ISVNChangelistHandler handler = new ISVNChangelistHandler(){

                public void handle(File path, String changelistName) {
                    targetPaths.add(path.getAbsolutePath());
                }
            };
            changelistClient.doGetChangeListPaths(changeLists, fileTargets, clDepth, handler);
            targets = targetPaths;
        }
        SVNUpdateClient client = this.getSVNEnvironment().getClientManager().getUpdateClient();
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler(new SVNNotifyPrinter(this.getSVNEnvironment()));
        }
        SVNDepth depth = this.getSVNEnvironment().getDepth();
        boolean depthIsSticky = false;
        if (this.getSVNEnvironment().getSetDepth() != SVNDepth.UNKNOWN) {
            depth = this.getSVNEnvironment().getSetDepth();
            depthIsSticky = true;
        }
        ArrayList<File> files = new ArrayList<File>(targets.size());
        for (String targetName : targets) {
            SVNPath target = new SVNPath(targetName);
            if (!target.isFile()) {
                this.getSVNEnvironment().getOut().println("Skipped '" + targetName + "'");
                continue;
            }
            files.add(target.getFile());
        }
        File[] filesArray = files.toArray(new File[files.size()]);
        client.doUpdate(filesArray, this.getSVNEnvironment().getStartRevision(), depth, this.getSVNEnvironment().isForce(), depthIsSticky);
    }
}

