/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnlook;

import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import org.tmatesoft.svn.cli.svnlook.SVNLookOption;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLookCatCommand
extends SVNLookCommand {
    protected SVNLookCatCommand() {
        super("cat", null);
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNLookOption> options = new LinkedList<SVNLookOption>();
        options.add(SVNLookOption.REVISION);
        options.add(SVNLookOption.TRANSACTION);
        return options;
    }

    public void run() throws SVNException {
        SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
        String path = environment.getFirstArgument();
        if (environment.getFirstArgument() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing repository path argument");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        SVNLookClient client = environment.getClientManager().getLookClient();
        if (environment.isRevision()) {
            client.doCat(environment.getRepositoryFile(), path, this.getRevisionObject(), (OutputStream)environment.getOut());
        } else {
            client.doCat(environment.getRepositoryFile(), path, environment.getTransaction(), (OutputStream)environment.getOut());
        }
    }
}

