/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnlook;

import java.util.Collection;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import org.tmatesoft.svn.cli.svnlook.SVNLookOption;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.admin.ISVNHistoryHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminPath;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;

public class SVNLookHistoryCommand
extends SVNLookCommand
implements ISVNHistoryHandler {
    public SVNLookHistoryCommand() {
        super("history", null);
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNLookOption> options = new LinkedList<SVNLookOption>();
        options.add(SVNLookOption.REVISION);
        options.add(SVNLookOption.SHOW_IDS);
        options.add(SVNLookOption.LIMIT);
        return options;
    }

    public void run() throws SVNException {
        SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
        if (environment.isShowIDs()) {
            environment.getOut().println("REVISION   PATH <ID>");
            environment.getOut().println("--------   ---------");
        } else {
            environment.getOut().println("REVISION   PATH");
            environment.getOut().println("--------   ----");
        }
        SVNLookClient client = environment.getClientManager().getLookClient();
        client.doGetHistory(environment.getRepositoryFile(), environment.getFirstArgument(), this.getRevisionObject(), environment.isShowIDs(), environment.getLimit(), this);
    }

    public void handlePath(SVNAdminPath path) throws SVNException {
        if (path != null) {
            SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
            if (environment.isShowIDs()) {
                environment.getOut().println(path.getRevision() + "   " + path.getPath() + " <" + path.getNodeID() + ">");
            } else {
                environment.getOut().println(path.getRevision() + "   " + path.getPath());
            }
        }
    }
}

