/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class Sticky {
    private JComponent _target;
    private static final StrickyMouseMotionListener STICKY_MOUSE_MOTION_LISTENER = new StrickyMouseMotionListener();

    public Sticky(JList list) {
        this._target = list;
        this.install();
    }

    public Sticky(JTree tree) {
        this._target = tree;
        this.install();
    }

    public Sticky(JTable table) {
        this._target = table;
        this.install();
    }

    public void install() {
        this._target.addMouseMotionListener(STICKY_MOUSE_MOTION_LISTENER);
    }

    public void uninstall() {
        this._target.removeMouseMotionListener(STICKY_MOUSE_MOTION_LISTENER);
    }

    private static void updateListSelectionForEvent(MouseEvent anEvent, JList list, boolean shouldScroll) {
        Point location = anEvent.getPoint();
        if (list == null) {
            return;
        }
        int index = list.locationToIndex(location);
        if (index == -1) {
            if (location.y < 0) {
                index = 0;
            } else {
                int n = index = list.getModel() == null ? 0 : list.getModel().getSize() - 1;
            }
        }
        if (list.getSelectedIndex() != index && index >= 0 && index < list.getModel().getSize()) {
            list.setSelectedIndex(index);
            if (shouldScroll) {
                list.ensureIndexIsVisible(index);
            }
        }
    }

    private static void updateTreeSelectionForEvent(MouseEvent anEvent, JTree tree, boolean shouldScroll) {
        Point location = anEvent.getPoint();
        if (tree == null) {
            return;
        }
        int index = tree.getRowForLocation(location.x, location.y);
        if (index != -1) {
            TreePath pathForRow = tree.getPathForRow(index);
            if (tree.getSelectionPath() != pathForRow) {
                tree.setSelectionRow(index);
                if (shouldScroll) {
                    tree.makeVisible(pathForRow);
                }
            }
        }
    }

    private static void updateTableSelectionForEvent(MouseEvent anEvent, JTable table, boolean shouldScroll) {
        Point location = anEvent.getPoint();
        if (table == null) {
            return;
        }
        int index = table.rowAtPoint(location);
        if (index == -1) {
            if (location.y < 0) {
                index = 0;
            } else {
                int n = index = table.getModel() == null ? 0 : table.getModel().getRowCount() - 1;
            }
        }
        if (table.getSelectedRow() != index) {
            table.getSelectionModel().setSelectionInterval(index, index);
            if (shouldScroll) {
                JideSwingUtilities.ensureRowVisible(table, index);
            }
        }
    }

    private static class StrickyMouseMotionListener
    extends MouseMotionAdapter {
        private StrickyMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent anEvent) {
            if (anEvent.getSource() instanceof JList) {
                JList list = (JList)anEvent.getSource();
                Point location = anEvent.getPoint();
                Rectangle r = new Rectangle();
                list.computeVisibleRect(r);
                if (r.contains(location)) {
                    Sticky.updateListSelectionForEvent(anEvent, list, false);
                }
            } else if (anEvent.getSource() instanceof JTree) {
                JTree tree = (JTree)anEvent.getSource();
                Point location = anEvent.getPoint();
                Rectangle r = new Rectangle();
                tree.computeVisibleRect(r);
                if (r.contains(location)) {
                    Sticky.updateTreeSelectionForEvent(anEvent, tree, false);
                }
            } else if (anEvent.getSource() instanceof JTable) {
                JTable table = (JTable)anEvent.getSource();
                Point location = anEvent.getPoint();
                Rectangle r = new Rectangle();
                table.computeVisibleRect(r);
                if (r.contains(location)) {
                    Sticky.updateTableSelectionForEvent(anEvent, table, false);
                }
            }
        }
    }
}

