/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;

public class TristateCheckBox
extends JCheckBox {
    public static final State NOT_SELECTED = new State();
    public static final State SELECTED = new State();
    public static final State DONT_CARE = new State();
    private final TristateDecorator model;

    public TristateCheckBox(String text, Icon icon, State initial) {
        super(text, icon);
        super.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TristateCheckBox.this.grabFocus();
                TristateCheckBox.this.model.setState(TristateCheckBox.this.getNextState(TristateCheckBox.this.model.getState()));
            }
        });
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("pressed", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TristateCheckBox.this.grabFocus();
                TristateCheckBox.this.model.setState(TristateCheckBox.this.getNextState(TristateCheckBox.this.model.getState()));
            }
        });
        map.put("released", null);
        SwingUtilities.replaceUIActionMap(this, map);
        this.model = new TristateDecorator(this.getModel());
        this.setModel(this.model);
        this.setState(initial);
    }

    public TristateCheckBox(String text, State initial) {
        this(text, null, initial);
    }

    public TristateCheckBox(String text) {
        this(text, DONT_CARE);
    }

    public TristateCheckBox() {
        this((String)null);
    }

    public void addMouseListener(MouseListener l) {
    }

    public void setState(State state) {
        this.model.setState(state);
        if (LookAndFeelFactory.isSyntheticaLnfInstalled() && (UIManager.getLookAndFeel().getClass().getName().startsWith("de.javasoft.plaf.synthetica.Synthetica") || LookAndFeelFactory.isLnfInUse("de.javasoft.plaf.synthetica.SyntheticaLookAndFeel"))) {
            if (state == DONT_CARE) {
                this.setName("HalfSelected");
            } else {
                this.setName("");
            }
        }
    }

    public State getState() {
        return this.model.getState();
    }

    public void setSelected(boolean b2) {
        if (b2) {
            this.setState(SELECTED);
        } else {
            this.setState(NOT_SELECTED);
        }
    }

    protected State getNextState(State current) {
        if (current == NOT_SELECTED) {
            return SELECTED;
        }
        if (current == SELECTED) {
            return DONT_CARE;
        }
        return NOT_SELECTED;
    }

    private class TristateDecorator
    implements ButtonModel {
        private final ButtonModel other;
        private State _state;

        private TristateDecorator(ButtonModel other) {
            this.other = other;
        }

        private void setState(State state) {
            if (state == NOT_SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(false);
            } else if (state == SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(true);
            } else {
                this.other.setArmed(true);
                this.setPressed(true);
                this.setSelected(true);
            }
            this._state = state;
        }

        private State getState() {
            return this._state == null ? DONT_CARE : this._state;
        }

        public void setArmed(boolean b2) {
        }

        public void setEnabled(boolean b2) {
            TristateCheckBox.this.setFocusable(b2);
            this.other.setEnabled(b2);
        }

        public boolean isArmed() {
            return this.other.isArmed();
        }

        public boolean isSelected() {
            return this.other.isSelected();
        }

        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        public boolean isPressed() {
            return this.other.isPressed();
        }

        public boolean isRollover() {
            return this.other.isRollover();
        }

        public void setSelected(boolean b2) {
            this.other.setSelected(b2);
        }

        public void setPressed(boolean b2) {
            this.other.setPressed(b2);
        }

        public void setRollover(boolean b2) {
            this.other.setRollover(b2);
        }

        public void setMnemonic(int key) {
            this.other.setMnemonic(key);
        }

        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        public void setActionCommand(String s) {
            this.other.setActionCommand(s);
        }

        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        public void setGroup(ButtonGroup group) {
            this.other.setGroup(group);
        }

        public void addActionListener(ActionListener l) {
            this.other.addActionListener(l);
        }

        public void removeActionListener(ActionListener l) {
            this.other.removeActionListener(l);
        }

        public void addItemListener(ItemListener l) {
            this.other.addItemListener(l);
        }

        public void removeItemListener(ItemListener l) {
            this.other.removeItemListener(l);
        }

        public void addChangeListener(ChangeListener l) {
            this.other.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.other.removeChangeListener(l);
        }

        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }

    public static class State {
        private State() {
        }
    }
}

