/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.subsystem;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.subsystem.SubsystemMessageStore;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SubsystemOutputStream
extends OutputStream {
    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    SubsystemMessageStore messageStore;
    int messageStart = 0;

    public SubsystemOutputStream(SubsystemMessageStore subsystemMessageStore) {
        this.messageStore = subsystemMessageStore;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.processMessage();
    }

    public void write(int n) throws IOException {
        this.buffer.write(n);
    }

    private void processMessage() throws IOException {
        int n;
        if (this.buffer.size() > this.messageStart + 4 && (n = (int)ByteArrayReader.readInt(this.buffer.toByteArray(), this.messageStart)) <= this.buffer.size() - 4) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer.toByteArray(), this.messageStart + 4, byArray, 0, n);
            try {
                this.messageStore.addMessage(byArray);
            }
            catch (InvalidMessageException invalidMessageException) {
                throw new IOException("An invalid message was encountered in the outputstream: " + invalidMessageException.getMessage());
            }
            if (n == this.buffer.size() - 4) {
                this.buffer.reset();
                this.messageStart = 0;
            } else {
                this.messageStart = n + 4;
            }
        }
    }
}

