/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.MessageNotAvailableException;
import com.sshtools.j2ssh.transport.MessageNotRegisteredException;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.SshMessageListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SshMessageStore {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$transport$SshMessageStore == null ? (class$com$sshtools$j2ssh$transport$SshMessageStore = SshMessageStore.class$("com.sshtools.j2ssh.transport.SshMessageStore")) : class$com$sshtools$j2ssh$transport$SshMessageStore));
    private List messages = new ArrayList();
    private Map register = new HashMap();
    private Map asyncronous = new HashMap();
    private boolean isClosed = false;
    private int[] singleIdFilter = new int[1];
    private int interrupt = 5000;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$SshMessageStore;

    public boolean isClosed() {
        return this.isClosed;
    }

    public synchronized SshMessage getMessage(int[] nArray) throws MessageStoreEOFException, InterruptedException {
        try {
            return this.getMessage(nArray, 0);
        }
        catch (MessageNotAvailableException messageNotAvailableException) {
            throw new MessageStoreEOFException();
        }
    }

    public synchronized SshMessage getMessage(int[] nArray, int n) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        if (this.messages.size() <= 0 && this.isClosed) {
            throw new MessageStoreEOFException();
        }
        if (nArray == null) {
            return this.nextMessage();
        }
        boolean bl = true;
        if (n < 0) {
            n = 0;
        }
        while (this.messages.size() > 0 || !this.isClosed) {
            SshMessage sshMessage = this.lookupMessage(nArray, true);
            if (sshMessage != null) {
                return sshMessage;
            }
            if (!bl && n > 0) {
                throw new MessageNotAvailableException();
            }
            if (!this.isClosed) {
                this.wait(n == 0 ? (long)this.interrupt : (long)n);
            }
            bl = false;
        }
        throw new MessageStoreEOFException();
    }

    public synchronized SshMessage getMessage(int n) throws MessageStoreEOFException, InterruptedException {
        try {
            return this.getMessage(n, 0);
        }
        catch (MessageNotAvailableException messageNotAvailableException) {
            throw new MessageStoreEOFException();
        }
    }

    public synchronized SshMessage getMessage(int n, int n2) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        this.singleIdFilter[0] = n;
        return this.getMessage(this.singleIdFilter, n2);
    }

    public boolean hasMessages() {
        return this.messages.size() > 0;
    }

    public int size() {
        return this.messages.size();
    }

    public boolean isRegisteredMessage(Integer n) {
        return this.register.containsKey(n);
    }

    public void addMessage(byte[] byArray) throws MessageNotRegisteredException, InvalidMessageException, IOException {
        Integer n = new Integer(byArray[5]);
        if (!this.isRegisteredMessage(n)) {
            throw new MessageNotRegisteredException(n);
        }
        Class clazz = (Class)this.register.get(SshMessage.getMessageId(byArray));
        try {
            SshMessage sshMessage = (SshMessage)clazz.newInstance();
            sshMessage.fromByteArray(new ByteArrayReader(byArray));
            this.addMessage(sshMessage);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidMessageException("Illegal access for implementation class " + clazz.getName());
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidMessageException("Instantiation failed for class " + clazz.getName());
        }
    }

    public synchronized void addMessage(SshMessage sshMessage) throws MessageNotRegisteredException, IOException {
        Integer n = new Integer(sshMessage.getMessageId());
        if (this.asyncronous.containsKey(n)) {
            ((SshMessageListener)this.asyncronous.get(n)).onMessageReceived(sshMessage);
        } else {
            this.messages.add(this.messages.size(), sshMessage);
            this.notifyAll();
        }
    }

    public synchronized void close() {
        this.isClosed = true;
        this.notifyAll();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized SshMessage nextMessage() throws MessageStoreEOFException, InterruptedException {
        if (this.messages.size() > 0 || !this.isClosed) ** GOTO lbl4
        throw new MessageStoreEOFException();
lbl-1000:
        // 1 sources

        {
            this.wait(this.interrupt);
lbl4:
            // 2 sources

            ** while (this.messages.size() <= 0 && !this.isClosed)
        }
lbl5:
        // 1 sources

        if (this.messages.size() > 0) {
            return (SshMessage)this.messages.remove(0);
        }
        throw new MessageStoreEOFException();
    }

    public synchronized void breakWaiting() {
        this.notifyAll();
    }

    public synchronized SshMessage peekMessage(int[] nArray) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        return this.peekMessage(nArray, 0);
    }

    public synchronized SshMessage peekMessage(int[] nArray, int n) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        SshMessage sshMessage = this.lookupMessage(nArray, false);
        if (sshMessage != null) {
            return sshMessage;
        }
        if (n > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No message so waiting for " + String.valueOf(n) + " milliseconds"));
            }
            this.wait(n);
            sshMessage = this.lookupMessage(nArray, false);
            if (sshMessage != null) {
                return sshMessage;
            }
        }
        if (this.isClosed) {
            throw new MessageStoreEOFException();
        }
        throw new MessageNotAvailableException();
    }

    private SshMessage lookupMessage(int[] nArray, boolean bl) {
        int n = 0;
        while (n < this.messages.size()) {
            SshMessage sshMessage = (SshMessage)this.messages.get(n);
            int n2 = 0;
            while (n2 < nArray.length) {
                if (sshMessage.getMessageId() == nArray[n2]) {
                    if (bl) {
                        this.messages.remove(sshMessage);
                    }
                    return sshMessage;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public synchronized SshMessage peekMessage(int n) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        return this.peekMessage(n, 0);
    }

    public synchronized void removeMessage(SshMessage sshMessage) {
        this.messages.remove(sshMessage);
    }

    public synchronized SshMessage peekMessage(int n, int n2) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        this.singleIdFilter[0] = n;
        return this.peekMessage(this.singleIdFilter, n2);
    }

    public void registerMessage(int n, Class clazz) {
        Integer n2 = new Integer(n);
        this.register.put(n2, clazz);
    }

    public void registerMessage(int n, Class clazz, SshMessageListener sshMessageListener) {
        Integer n2 = new Integer(n);
        this.register.put(n2, clazz);
        this.asyncronous.put(n2, sshMessageListener);
    }

    public Object[] getRegisteredMessageIds() {
        return this.register.keySet().toArray();
    }

    public SshMessage createMessage(byte[] byArray) throws MessageNotRegisteredException, InvalidMessageException {
        Integer n = SshMessage.getMessageId(byArray);
        if (!this.isRegisteredMessage(n)) {
            throw new MessageNotRegisteredException(n);
        }
        Class clazz = (Class)this.register.get(SshMessage.getMessageId(byArray));
        try {
            SshMessage sshMessage = (SshMessage)clazz.newInstance();
            sshMessage.fromByteArray(new ByteArrayReader(byArray));
            return sshMessage;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidMessageException("Illegal access for implementation class " + clazz.getName());
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidMessageException("Instantiation failed for class " + clazz.getName());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

