/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey.rsa;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.rsa.SshRsaPrivateKey;
import com.sshtools.j2ssh.transport.publickey.rsa.SshRsaPublicKey;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class SshRsaKeyPair
extends SshKeyPair {
    private RSAPrivateKey prvKey;
    private RSAPublicKey pubKey;

    public SshPrivateKey decodePrivateKey(byte[] byArray) throws InvalidSshKeyException {
        return new SshRsaPrivateKey(byArray);
    }

    public SshPublicKey decodePublicKey(byte[] byArray) throws InvalidSshKeyException {
        return new SshRsaPublicKey(byArray);
    }

    public void generate(int n) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(n, ConfigurationLoader.getRND());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.setPrivateKey(new SshRsaPrivateKey((RSAPrivateKey)keyPair.getPrivate(), (RSAPublicKey)keyPair.getPublic()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.prvKey = null;
            this.pubKey = null;
        }
    }
}

