/*
 * Decompiled with CFR 0.152.
 */
package com.ice.config.editor;

import com.ice.config.ConfigureEditor;
import com.ice.config.ConfigureSpec;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class ConfigBooleanEditor
extends ConfigureEditor {
    protected JRadioButton tButton;
    protected JRadioButton fButton;
    protected ButtonGroup group;

    public ConfigBooleanEditor() {
        super("Boolean");
    }

    public void edit(UserPrefs prefs, ConfigureSpec spec) {
        super.edit(prefs, spec);
        boolean val = prefs.getBoolean(spec.getPropertyName(), false);
        if (val) {
            this.tButton.setSelected(true);
        } else {
            this.fButton.setSelected(true);
        }
    }

    public void saveChanges(UserPrefs prefs, ConfigureSpec spec) {
        boolean oldVal;
        String propName = spec.getPropertyName();
        boolean newVal = this.tButton.isSelected();
        if (newVal != (oldVal = prefs.getBoolean(propName, false))) {
            prefs.setBoolean(propName, newVal);
        }
    }

    public void requestInitialFocus() {
        this.tButton.requestFocus();
    }

    protected JPanel createEditPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new EmptyBorder(5, 25, 5, 5));
        boolean col = false;
        int row = 0;
        this.tButton = new JRadioButton("True");
        AWTUtilities.constrain(result, this.tButton, 2, 17, 0, row++, 1, 1, 1.0, 0.0);
        this.fButton = new JRadioButton("False");
        AWTUtilities.constrain(result, this.fButton, 2, 17, 0, row++, 1, 1, 1.0, 0.0);
        this.group = new ButtonGroup();
        this.group.add(this.tButton);
        this.group.add(this.fButton);
        return result;
    }
}

