/*
 * Decompiled with CFR 0.152.
 */
package com.ice.config.editor;

import com.ice.config.ConfigureEditor;
import com.ice.config.ConfigureSpec;
import com.ice.pref.UserPrefs;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class ConfigChoiceEditor
extends ConfigureEditor {
    protected JPanel radioPanel;
    protected ButtonGroup group;
    protected JRadioButton[] choiceButtons;

    public ConfigChoiceEditor() {
        super("Choice");
    }

    public void edit(UserPrefs prefs, ConfigureSpec spec) {
        super.edit(prefs, spec);
        this.radioPanel.removeAll();
        String propName = spec.getPropertyName();
        String choice = prefs.getProperty(propName, null);
        this.group = new ButtonGroup();
        String[] choices = spec.getChoices();
        this.choiceButtons = new JRadioButton[choices.length];
        int i = 0;
        while (i < choices.length) {
            JRadioButton radio;
            this.choiceButtons[i] = radio = new JRadioButton(choices[i]);
            this.group.add(radio);
            this.radioPanel.add(radio);
            radio.setSelected(false);
            if (choice != null) {
                if (choice.equals(choices[i])) {
                    radio.setSelected(true);
                }
            } else if (i == 0) {
                radio.setSelected(true);
            }
            ++i;
        }
        this.radioPanel.validate();
        this.radioPanel.repaint(250L);
    }

    public void saveChanges(UserPrefs prefs, ConfigureSpec spec) {
        String propName = spec.getPropertyName();
        String oldChoice = prefs.getProperty(propName, null);
        int i = 0;
        while (i < this.choiceButtons.length) {
            if (this.choiceButtons[i].isSelected()) {
                String newChoice = this.choiceButtons[i].getText();
                prefs.setProperty(propName, newChoice);
                break;
            }
            ++i;
        }
    }

    public void requestInitialFocus() {
    }

    protected JPanel createEditPanel() {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        result.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.radioPanel = result;
        return this.radioPanel;
    }
}

