/*
 * Decompiled with CFR 0.152.
 */
package com.ice.config.editor;

import com.ice.config.ConfigureEditor;
import com.ice.config.ConfigureSpec;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class ConfigStringEditor
extends ConfigureEditor {
    protected JTextField strField;

    public ConfigStringEditor() {
        super("String");
    }

    public void requestInitialFocus() {
        this.strField.requestFocus();
        this.strField.selectAll();
    }

    protected JPanel createEditPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new EmptyBorder(5, 3, 3, 3));
        boolean col = false;
        int row = 0;
        this.strField = new JTextField("");
        AWTUtilities.constrain(result, this.strField, 2, 17, 0, row++, 1, 1, 1.0, 0.0, new Insets(3, 0, 0, 0));
        return result;
    }

    public void edit(UserPrefs prefs, ConfigureSpec spec) {
        super.edit(prefs, spec);
        String val = prefs.getProperty(spec.getPropertyName(), null);
        if (val != null) {
            this.strField.setText(val);
        } else {
            this.strField.setText("");
        }
    }

    public void saveChanges(UserPrefs prefs, ConfigureSpec spec) {
        String propName = spec.getPropertyName();
        String oldVal = prefs.getProperty(propName, "");
        String newVal = this.strField.getText();
        if (!newVal.equals(oldVal)) {
            prefs.setProperty(propName, newVal);
        }
    }
}

