/*
 * Decompiled with CFR 0.152.
 */
package com.ice.cvsc;

import com.ice.cvsc.CVSArgumentVector;
import com.ice.cvsc.CVSCUtilities;
import com.ice.cvsc.CVSEntry;
import com.ice.cvsc.CVSEntryVector;
import com.ice.cvsc.CVSLog;
import com.ice.cvsc.CVSNotifyItem;
import com.ice.cvsc.CVSRequest;
import com.ice.cvsc.CVSResponse;
import com.ice.cvsc.CVSResponseItem;
import com.ice.cvsc.CVSTracer;
import com.ice.cvsc.CVSUserInterface;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;

public class CVSClient
implements HostKeyVerification {
    public static final String RCS_ID = "$Id: CVSClient.java,v 2.20 2003/07/27 04:32:56 time Exp $";
    public static final String RCS_REV = "$Revision: 2.20 $";
    public static final int DEFAULT_SSH_PORT = 22;
    public static final int DEFAULT_RSH_PORT = 514;
    public static final int DEFAULT_CVS_PORT = 2401;
    public static final int DEFAULT_DIR_PORT = 2402;
    public static final String DEFAULT_TEMP_PATH = ".";
    public static final int TRANSLATE_NONE = 0;
    public static final int TRANSLATE_ASCII = 1;
    private static final int MIN_GZIP_SIZE = 1024;
    private static final int MAX_FILE_SIZE = 1000000;
    private static final boolean LIMIT_FILE_SIZE = false;
    private Object canLock;
    private boolean canceled;
    private String hostName;
    private int port;
    private int tempCounter;
    private boolean usingGZIP;
    private boolean serverIsOpen;
    private boolean tracingTCPData;
    private Process process;
    private Socket socket;
    private InputStream instream;
    private OutputStream outstream;
    private String tempPath;
    private String reason;
    private String recentEntryRepository;
    private Hashtable dirHash;
    private boolean supportMultipleInterfaces = false;
    SshClient sshClient = null;
    SessionChannelClient sshSession = null;

    public CVSClient() {
        this.InitFields();
    }

    public CVSClient(String hostName, int port) {
        this.InitFields();
        this.port = port;
        this.hostName = hostName;
    }

    private void InitFields() {
        this.canceled = false;
        this.canLock = new Object();
        this.hostName = null;
        this.port = 2401;
        this.tempPath = DEFAULT_TEMP_PATH;
        this.tempCounter = (int)(System.currentTimeMillis() % 0xFFFFFFFL);
        this.serverIsOpen = false;
        this.tracingTCPData = false;
        this.socket = null;
        this.instream = null;
        this.outstream = null;
        this.reason = "";
        this.recentEntryRepository = "";
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean getMultipleInterfaceSupport() {
        return this.supportMultipleInterfaces;
    }

    public void setMultipleInterfaceSupport(boolean flag) {
        this.supportMultipleInterfaces = flag;
        CVSTracer.traceIf(flag, "Supporting multiple interfaces.");
    }

    public String getTempDirectory() {
        return this.tempPath;
    }

    public void setTempDirectory(String tempPath) {
        this.tempPath = tempPath;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean isServerOpen() {
        return this.serverIsOpen;
    }

    public boolean sendCVSRootDirectory(CVSRequest request) {
        boolean result = true;
        result = this.sendLine("Root " + request.getRootDirectory());
        return result;
    }

    public boolean sendRootRepository(CVSRequest request) {
        boolean result = true;
        result = this.sendLine("Directory .");
        result = this.sendLine(request.getRootRepository());
        return result;
    }

    public boolean sendEntryRepository(CVSRequest request, CVSEntry entry) {
        boolean result = true;
        CVSTracer.traceIf(request.traceRequest, "sendEntryRepository: " + entry.dumpString());
        String localDir = CVSCUtilities.stripFinalSlash(entry.getLocalDirectory());
        CVSTracer.traceIf(request.traceRequest, "sendEntryRepository: localDir = '" + localDir + "'");
        if (!localDir.equals(this.recentEntryRepository)) {
            String dirStr = localDir;
            String repStr = entry.getRepository();
            CVSTracer.traceIf(request.traceRequest, "sendEntryRepository: INITIAL \n  dirStr = '" + dirStr + "'\n" + "  repStr = '" + repStr + "'");
            Vector<String> v = new Vector<String>();
            String stickyStr = this.getStickTag(request, dirStr);
            if (stickyStr.length() > 0) {
                v.addElement(stickyStr);
            }
            v.addElement(entry.getRepository());
            v.addElement("Directory " + localDir);
            this.dirHash.put(localDir, entry.getRepository());
            int pi = 0;
            while (true) {
                int idxD = dirStr.lastIndexOf("/");
                int idxR = repStr.lastIndexOf("/");
                if (idxD < 0 || idxR < 0) {
                    int i = v.size() - 1;
                    while (i >= 0) {
                        result = this.sendLine((String)v.elementAt(i));
                        --i;
                    }
                    break;
                }
                dirStr = dirStr.substring(0, idxD);
                repStr = repStr.substring(0, idxR);
                CVSTracer.traceIf(request.traceRequest, "sendEntryRepository: PART [" + pi + "]\n" + "  dirStr = '" + dirStr + "'\n" + "  repStr = '" + repStr + "'");
                if (this.dirHash.get(dirStr) == null) {
                    stickyStr = this.getStickTag(request, dirStr);
                    if (stickyStr.length() > 0) {
                        v.addElement(stickyStr);
                    }
                    v.addElement(repStr);
                    v.addElement("Directory " + dirStr);
                    this.dirHash.put(dirStr, repStr);
                }
                ++pi;
            }
            result = this.sendSticky(request, entry);
            result = this.sendStatic(request, entry);
            this.recentEntryRepository = localDir;
        }
        return result;
    }

    public boolean sendCVSArgument(String argument) {
        boolean result = true;
        result = this.sendLine("Argument " + argument);
        return result;
    }

    public boolean sendCVSModule(CVSRequest request) {
        boolean result = true;
        result = this.sendCVSArgument(DEFAULT_TEMP_PATH);
        return result;
    }

    public boolean sendSetVariables(CVSRequest request) {
        boolean result = true;
        String[] vars = request.getSetVariables();
        if (vars != null) {
            int i = 0;
            while (result && i < vars.length) {
                result = this.sendLine("Set " + vars[i]);
                ++i;
            }
        }
        return result;
    }

    public boolean sendModified(CVSRequest request, CVSEntry entry, File entryFile, boolean empty, int trans) {
        boolean result = true;
        result = this.sendEntryRepository(request, entry);
        if (result) {
            result = this.sendLine("Modified " + entry.getName());
        }
        if (result) {
            result = this.sendLine(entry.getModeLine());
        }
        if (result) {
            if (empty) {
                result = this.sendLine("0");
            } else {
                switch (trans) {
                    case 1: {
                        result = this.sendFileAscii(entry, entryFile, request.gzipFileMode);
                        break;
                    }
                    default: {
                        result = this.sendFileRaw(entry, entryFile, request.gzipFileMode);
                    }
                }
            }
        }
        if (!result) {
            CVSLog.logMsg("CVSClient.sendModified: ERROR sending file: " + this.getReason());
        }
        return result;
    }

    public boolean sendLostEntry(CVSRequest request, CVSEntry entry, boolean useUnchanged) {
        boolean result = true;
        CVSTracer.trace("sendLostEntry: '" + entry.getName() + "'");
        if (!useUnchanged && (result = this.sendEntryRepository(request, entry))) {
            result = this.sendLine("Lost " + entry.getName());
        }
        return result;
    }

    public boolean sendUnchangedEntry(CVSRequest request, CVSEntry entry, boolean useUnchanged) {
        boolean result = true;
        CVSTracer.trace("sendUnchangedEntry: '" + entry.getName() + "'");
        if (useUnchanged && (result = this.sendEntryRepository(request, entry))) {
            result = this.sendLine("Unchanged " + entry.getName());
        }
        return result;
    }

    public boolean sendCVSEntry(CVSRequest request, CVSEntry entry, File entryFile) {
        boolean result = true;
        boolean fileExists = false;
        boolean fileIsModified = false;
        CVSTracer.traceIf(request.traceRequest, "sendCVSEntry: " + entry.dumpString());
        if (entry.isDirectory()) {
            result = this.sendEntryRepository(request, entry);
            if (result) {
                result = this.sendLine("Directory " + CVSCUtilities.stripFinalSlash(entry.getFullName()));
                if (result) {
                    String localDir = CVSCUtilities.stripFinalSlash(entry.getLocalDirectory());
                    result = this.sendLine(entry.getRepository());
                    result = this.sendSticky(request, localDir);
                }
                this.recentEntryRepository = entry.getFullName();
            }
            return result;
        }
        if (entryFile.exists()) {
            fileExists = true;
            fileIsModified = entry.isLocalFileModified(entryFile);
        }
        int trans = CVSCUtilities.computeTranslation(entry);
        if (!request.sendEntries) {
            if ((fileIsModified || entry.isNewUserFile() || request.forceModifieds) && (request.sendModifieds || request.forceModifieds) && (result = this.sendEntryRepository(request, entry))) {
                request.getUserInterface().uiDisplayProgressMsg("Uploading file '" + entry.getFullName() + "'...");
                result = this.sendModified(request, entry, entryFile, request.sendEmptyMods, trans);
            }
            return result;
        }
        String entryStr = entry.getServerEntryLine(entryFile.exists(), fileIsModified);
        result = this.sendEntryRepository(request, entry);
        if (result) {
            result = this.sendLine("Entry " + entryStr);
        }
        if (result) {
            if (fileExists) {
                if (fileIsModified || entry.isNewUserFile() || request.forceModifieds) {
                    if (request.sendModifieds || entry.isNewUserFile() || request.forceModifieds) {
                        request.getUserInterface().uiDisplayProgressMsg("Uploading file '" + entry.getName() + "'...");
                        boolean sendEmpties = request.sendEmptyMods;
                        if (entry.isInConflict()) {
                            sendEmpties = false;
                        }
                        result = this.sendModified(request, entry, entryFile, sendEmpties, trans);
                    } else {
                        result = this.sendUnchangedEntry(request, entry, request.useUnchanged);
                    }
                } else {
                    result = this.sendUnchangedEntry(request, entry, request.useUnchanged);
                }
            } else {
                result = this.sendLostEntry(request, entry, request.useUnchanged);
            }
        }
        return result;
    }

    public boolean sendCVSEntries(CVSRequest request) {
        boolean result = true;
        int count = request.getEntries().size();
        CVSEntryVector entries = request.getEntries();
        int i = 0;
        while (result && i < count) {
            CVSEntry entry = (CVSEntry)entries.elementAt(i);
            File entryFile = request.getLocalFile(entry);
            result = this.sendCVSEntry(request, entry, entryFile);
            if (this.isCanceled()) break;
            ++i;
        }
        return result;
    }

    public String getStickTag(CVSRequest request, String localDir) {
        String result = "";
        Hashtable stickys = request.getStickys();
        if (stickys != null) {
            result = (String)stickys.get(localDir);
        }
        return result == null ? "" : result;
    }

    public boolean sendSticky(CVSRequest request, CVSEntry entry) {
        return this.sendSticky(request, entry.getLocalDirectory());
    }

    public boolean sendSticky(CVSRequest request, String localDir) {
        String tagSpec;
        boolean result = true;
        Hashtable stickys = request.getStickys();
        if (stickys != null && (tagSpec = (String)stickys.get(localDir)) != null && tagSpec.length() > 1) {
            result = this.sendLine("Sticky " + tagSpec);
        }
        return result;
    }

    public boolean sendStatic(CVSRequest request, CVSEntry entry) {
        String isStatic;
        boolean result = true;
        Hashtable statics = request.getStatics();
        if (statics != null && (isStatic = (String)statics.get(entry.getLocalDirectory())) != null) {
            result = this.sendLine("Static-directory");
        }
        return result;
    }

    public boolean sendGlobalArguments(CVSArgumentVector arguments) {
        boolean result = true;
        int i = 0;
        while (i < arguments.size()) {
            String argStr = arguments.argumentAt(i);
            result = this.sendLine("Global_option " + argStr);
            ++i;
        }
        return result;
    }

    public boolean sendArguments(CVSArgumentVector arguments) {
        boolean xArg = false;
        boolean result = true;
        int i = 0;
        while (i < arguments.size()) {
            String argStr = arguments.argumentAt(i);
            if (argStr.indexOf(10) < 0) {
                result = this.sendLine("Argument " + argStr);
            } else {
                xArg = false;
                StringTokenizer toker = new StringTokenizer(argStr, "\n");
                while (result) {
                    String argLine;
                    try {
                        argLine = toker.nextToken();
                    }
                    catch (NoSuchElementException ex) {
                        break;
                    }
                    String prefix = xArg ? "Argumentx " : "Argument ";
                    result = this.sendLine(prefix + argLine);
                    xArg = true;
                }
            }
            ++i;
        }
        return result;
    }

    public boolean sendEntriesArguments(CVSRequest request) {
        boolean result = true;
        CVSEntryVector entries = request.getEntries();
        if (entries.size() < 1) {
            return true;
        }
        CVSArgumentVector args = new CVSArgumentVector(entries.size());
        int i = 0;
        while (i < entries.size()) {
            CVSEntry entry = (CVSEntry)entries.elementAt(i);
            String argName = request.execInCurDir ? entry.getName() : entry.getArgumentName();
            argName = CVSCUtilities.stripFinalSlash(argName);
            args.addElement(argName);
            ++i;
        }
        result = this.sendArguments(args);
        return result;
    }

    public boolean sendNotifies(CVSRequest request) {
        String lastWDir = "";
        boolean result = true;
        int num = request.notifies.size();
        int i = 0;
        while (result && i < num) {
            CVSNotifyItem notify = (CVSNotifyItem)request.notifies.elementAt(i);
            String dir = notify.getWorkingDirectory();
            if (dir.endsWith("/")) {
                dir = dir.substring(0, dir.length() - 1);
            }
            if (!lastWDir.equals(dir)) {
                lastWDir = dir;
                result = this.sendLine("Directory .");
                result = this.sendLine(notify.getRepository());
            }
            if (result = this.sendLine("Notify " + notify.getName())) {
                result = this.sendLine(notify.getServerExtra());
            }
            ++i;
        }
        return result;
    }

    public CVSResponse buildErrorResponse(CVSRequest request, CVSResponse response, String message) {
        response.setStatus(1);
        response.appendStderr("The CVS Request failed.\n");
        if (message.length() > 0) {
            response.appendStderr(message + "\n");
        }
        if (this.getReason().length() > 0) {
            response.appendStderr(this.getReason() + "\n");
        }
        CVSTracer.traceIf(request.traceRequest, "CVSClient.buildErrorReponse: " + response.getStderr());
        return response;
    }

    public boolean performLogin(CVSRequest request) {
        CVSTracer.traceIf(request.traceRequest, "AUTHENTICATE: verifyOnly? '" + request.verificationOnly + "' userName '" + request.getUserName() + "' password '" + request.getPassword() + "'");
        this.sendLine("BEGIN " + (request.verificationOnly ? "VERIFICATION" : "AUTH") + " REQUEST");
        this.sendLine(request.getRootDirectory());
        this.sendLine(request.getUserName());
        this.sendLine(request.getPassword());
        this.sendLine("END " + (request.verificationOnly ? "VERIFICATION" : "AUTH") + " REQUEST");
        String reply = this.readLine();
        CVSTracer.traceIf(request.traceRequest, "AUTHENTICATE: REPLY: '" + reply + "'");
        if (reply != null && reply.startsWith("I LOVE YOU")) {
            return true;
        }
        if (reply != null && reply.length() > 0) {
            this.setReason(reply);
        }
        return false;
    }

    public boolean requestValidRequests(CVSRequest request) {
        boolean result = true;
        request.validRequests = null;
        request.useUnchanged = false;
        request.useDirectory = true;
        this.sendLine("valid-requests");
        boolean saveQueue = request.queueResponse;
        request.queueResponse = true;
        CVSResponse validResponse = new CVSResponse();
        this.readAndParseResponse(request, validResponse);
        request.queueResponse = saveQueue;
        if (validResponse.getStatus() == 0) {
            CVSResponseItem item = validResponse.getFirstItemByType(16);
            if (item == null) {
                CVSTracer.traceIf(false, "REQUEST-VALID-REQUESTS: NO VALID-REQUESTS ITEM!!");
            } else {
                String valids;
                request.validRequests = valids = item.getValidRequests();
                int index = valids.indexOf("Directory");
                if (index >= 0) {
                    request.useDirectory = true;
                } else {
                    result = false;
                    CVSTracer.traceIf(true, "WARNING: This server does not support the 'Directory' request.\njCVS will not operate properly with this server.\nPlease update your cvs server to release 1.9 or later.");
                }
                index = valids.indexOf("UseUnchanged");
                if (index >= 0) {
                    request.useUnchanged = true;
                }
            }
        } else {
            request.useDirectory = true;
            CVSTracer.traceIf(true, "Recevied an error from the cvs server while\nrequesting 'valid-requests'. This is not a good sign.\n\n" + validResponse.getStdout() + "\n" + validResponse.getStderr());
        }
        return result;
    }

    public CVSResponse processCVSRequest(CVSRequest request) {
        return this.processCVSRequest(request, new CVSResponse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        Object object = this.canLock;
        synchronized (object) {
            return this.canceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanceled(boolean can) {
        Object object = this.canLock;
        synchronized (object) {
            this.canceled = can;
        }
    }

    public boolean checkForCancel(CVSResponse response) {
        if (this.isCanceled()) {
            response.setStatus(1);
            response.appendStderr("\n*** The CVS request was canceled.\n");
            if (this.serverIsOpen) {
                this.closeServer();
            }
            return true;
        }
        return false;
    }

    public CVSResponse processCVSRequest(CVSRequest request, CVSResponse response) {
        int portNum;
        this.setCanceled(false);
        boolean isok = true;
        String[] vars = request.getSetVariables();
        this.usingGZIP = false;
        this.setReason("");
        this.recentEntryRepository = "";
        this.dirHash = new Hashtable();
        CVSUserInterface ui = request.getUserInterface();
        if (ui == null) {
            CVSClient cVSClient = this;
            cVSClient.getClass();
            ui = cVSClient.new NullCVSUI();
        }
        this.tracingTCPData = request.traceTCPData;
        CVSEntryVector entries = request.getEntries();
        CVSArgumentVector arguments = request.getArguments();
        CVSArgumentVector globalargs = request.getGlobalArguments();
        if (request.traceRequest) {
            CVSTracer.traceIf(true, "======================== CVSClient.processCVSRequest ========================");
            CVSTracer.traceIf(true, "   Command:        " + request.getCommand());
            CVSTracer.traceIf(true, "   Repository:     " + request.getRepository());
            CVSTracer.traceIf(true, "   RootRepository: " + request.getRootRepository());
            CVSTracer.traceIf(true, "   CVSServer:      " + request.getPort() + "@" + request.getHostName());
            CVSTracer.traceIf(true, "   RootDirectory:  " + request.getRootDirectory());
            CVSTracer.traceIf(true, "   LocalDirectory: " + request.getLocalDirectory());
            CVSTracer.traceIf(true, "   Connect Method: " + (request.getConnectionMethod() == 2 ? "RSH" : (request.getConnectionMethod() == 3 ? "SSH" : "INETD")));
            CVSTracer.traceIf(true, "   Rsh Command:    " + request.getRshProcess());
            CVSTracer.traceIf(true, "   Server Command: " + request.getServerCommand());
            CVSTracer.traceIf(true, "   isPServer?      '" + (request.isPServer() ? "true " : "false") + "'" + "   user '" + request.getUserName() + "'" + "   pass '" + request.getPassword() + "'");
            CVSTracer.traceIf(true, "   There are " + (vars == null ? "no" : "" + vars.length) + " user set variables.");
            CVSTracer.traceIf(true, "   NumEntries:      " + (entries == null ? 0 : entries.size()) + "        NumArguments:     " + (arguments == null ? 0 : arguments.size()));
            CVSTracer.traceIf(true, "   GlobalOptions:   " + (globalargs == null ? 0 : globalargs.size()) + "        GzipStreamLevel:  " + request.getGzipStreamLevel());
            CVSTracer.traceIf(true, "   redirectOutput  '" + (request.redirectOutput ? "true " : "false") + "'" + "   execInCurDir    '" + (request.execInCurDir ? "true " : "false") + "'");
            CVSTracer.traceIf(true, "   sendEntries     '" + (request.sendEntries ? "true " : "false") + "'" + "   sendEntryfiles  '" + (request.sendEntryFiles ? "true " : "false") + "'");
            CVSTracer.traceIf(true, "   sendModifieds   '" + (request.sendModifieds ? "true " : "false") + "'" + "   sendEmptyMods   '" + (request.sendEmptyMods ? "true " : "false") + "'");
            CVSTracer.traceIf(true, "   sendArguments   '" + (request.sendArguments ? "true " : "false") + "'" + "   ignoreResult    '" + (request.ignoreResult ? "true " : "false") + "'");
            CVSTracer.traceIf(true, "   sendModule      '" + (request.sendModule ? "true " : "false") + "'" + "   allowOverWrites '" + (request.allowOverWrites ? "true " : "false") + "'");
            CVSTracer.traceIf(true, "   displayReponse  '" + (request.displayReponse ? "true " : "false") + "'" + "   handleUpdated   '" + (request.handleUpdated ? "true " : "false") + "'");
            CVSTracer.traceIf(true, "   handleMerged    '" + (request.handleMerged ? "true " : "false") + "'" + "   handleCopyFile  '" + (request.handleCopyFile ? "true " : "false") + "'");
            CVSTracer.traceIf(true, "   handleEntries   '" + (request.handleEntries ? "true " : "false") + "'" + "   handleFlags     '" + (request.handleFlags ? "true " : "false") + "'");
            CVSTracer.traceIf(true, "   queueResponse   '" + (request.queueResponse ? "true " : "false") + "'" + "   responseHandler '" + (request.responseHandler == null ? "null " : request.responseHandler.getClass().getName()) + "'");
            CVSTracer.traceIf(true, "   includeNotifies '" + (request.includeNotifies ? "true " : "false") + "'" + "   notifiesSize    '" + (request.notifies == null ? "null" : "" + request.notifies.size()) + "'");
            CVSTracer.traceIf(request.traceRequest, "*****************************************************************************");
        }
        if ("ci".equals(request.getCommand()) && request.getArguments().containsArgument("-f")) {
            CVSTracer.traceIf(request.traceRequest, "SPECIAL CASE: Forcing all files to be 'Modified' for '-f' commit.");
            request.forceModifieds = true;
        }
        if ((portNum = request.getPort()) == 0) {
            CVSTracer.traceIf(request.traceRequest, "CVSRequest: default port number to '" + this.port + "'");
            portNum = this.port;
        }
        if (this.checkForCancel(response)) {
            return response;
        }
        CVSTracer.traceIf(request.traceRequest, "CVSRequest: opening server...");
        ui.uiDisplayProgressMsg("Opening server '" + request.getPort() + "@" + request.getHostName() + "'...");
        isok = this.openServer(request);
        CVSTracer.traceIf(request.traceRequest, "CVSRequest: server is " + (isok ? "" : "not ") + "open.");
        if (!isok) {
            String why = this.getReason();
            this.buildErrorResponse(request, response, "Failed to open socket to connect to cvs server '" + request.getPort() + "@" + request.getHostName() + "'.\n" + why);
            ui.uiDisplayProgressMsg("Failed to open '" + request.getPort() + "@" + request.getHostName() + "'.");
            return response;
        }
        if (this.checkForCancel(response)) {
            return response;
        }
        if (request.isPServer()) {
            if (request.getUserName() == null || request.getPassword() == null) {
                this.buildErrorResponse(request, response, "Attempted to connect to a password cvs server without a " + (request.getUserName() == null ? "username" : "password") + ".\n");
                ui.uiDisplayProgressMsg("Incomplete login. Request canceled.");
                return response;
            }
            ui.uiDisplayProgressMsg("Authenticating '" + request.getUserName() + "@" + request.getHostName() + "'...");
            if (!this.performLogin(request)) {
                this.buildErrorResponse(request, response, "Failed authentication with the user name '" + request.getUserName() + "'.\n");
                ui.uiDisplayProgressMsg("Authentication of '" + request.getUserName() + "@" + request.getHostName() + "' failed.");
                return response;
            }
        }
        if (request.verificationOnly) {
            String authResultStr = "Authentication of '" + request.getUserName() + "@" + request.getHostName() + "' succeeded.";
            ui.uiDisplayProgressMsg(authResultStr);
            response.setStatus(0);
            response.appendStderr(authResultStr);
            this.closeServer();
            return response;
        }
        if (this.checkForCancel(response)) {
            return response;
        }
        if (isok) {
            isok = this.requestValidRequests(request);
        }
        CVSTracer.traceIf(request.traceRequest, "Valid Requests:  useUnchanged '" + (request.useUnchanged ? "true" : "false") + "'" + "   useDirectory '" + (request.useDirectory ? "true" : "false") + "'");
        if (this.checkForCancel(response)) {
            return response;
        }
        if (isok && request.sendRootDirectory) {
            CVSTracer.traceIf(request.traceRequest, "CVSRequest: send root directory...");
            if (request.getRootDirectory().length() > 0) {
                isok = this.sendCVSRootDirectory(request);
            }
        }
        if (isok && request.gzipStreamLevel > 0 && request.validRequests != null && request.validRequests.indexOf("Gzip-stream") >= 0) {
            CVSTracer.traceIf(request.traceRequest, "Utilitizing Gzip-stream mode at level 6.");
            this.usingGZIP = true;
            this.sendLine("Gzip-stream 6");
            this.instream = new InflaterInputStream(this.instream);
            this.outstream = new DeflaterOutputStream(this.outstream);
        }
        if (isok) {
            isok = this.sendSetVariables(request);
        }
        ui.uiDisplayProgressMsg("Negotiating cvs protocol...");
        this.sendValidResponses(request, "");
        ui.uiDisplayProgressMsg("Sending command request, '" + request.getCommand() + "'...");
        if (isok && request.allowGzipFileMode && !this.usingGZIP && request.validRequests != null && request.validRequests.indexOf("gzip-file-contents") >= 0) {
            CVSTracer.traceIf(request.traceRequest, "Utilitizing gzip-file-contents mode at level 6.");
            this.sendLine("gzip-file-contents 6");
            request.gzipFileMode = true;
        }
        if (this.checkForCancel(response)) {
            return response;
        }
        CVSArgumentVector globalArgs = request.getGlobalArguments();
        if (isok & globalArgs != null && globalArgs.size() > 0) {
            isok = this.sendGlobalArguments(globalArgs);
        }
        if (isok & request.notifies != null && request.notifies.size() > 0) {
            isok = this.sendNotifies(request);
        }
        if (isok) {
            CVSTracer.traceIf(request.traceRequest, "CVSRequest: send entries...");
            isok = this.sendCVSEntries(request);
        }
        if (this.checkForCancel(response)) {
            return response;
        }
        if (isok && request.sendRootDirectory) {
            if (request.execInCurDir && request.getDirEntry() != null) {
                CVSTracer.traceIf(request.traceRequest, "CVSRequest: send 'current' directory...");
                this.recentEntryRepository = "";
                isok = this.sendEntryRepository(request, request.getDirEntry());
            } else {
                CVSTracer.traceIf(request.traceRequest, "CVSRequest: send root repository...");
                isok = this.sendRootRepository(request);
            }
        }
        if (this.checkForCancel(response)) {
            return response;
        }
        if (isok && request.sendArguments) {
            CVSTracer.traceIf(request.traceRequest, "CVSRequest: send arguments...");
            isok = this.sendArguments(request.getArguments());
        }
        if (this.checkForCancel(response)) {
            return response;
        }
        if (isok && request.sendEntryFiles) {
            CVSTracer.traceIf(request.traceRequest, "CVSRequest: send files...");
            isok = this.sendEntriesArguments(request);
        }
        if (this.checkForCancel(response)) {
            return response;
        }
        if (isok && request.sendModule) {
            CVSTracer.traceIf(request.traceRequest, "CVSRequest: send module name...");
            isok = this.sendCVSModule(request);
        }
        if (isok) {
            CVSTracer.traceIf(request.traceRequest, "CVSRequest: send command '" + request.getCommand() + "'");
            isok = this.sendLine(request.getCommand());
        }
        if (this.checkForCancel(response)) {
            return response;
        }
        try {
            if (this.usingGZIP) {
                ((DeflaterOutputStream)this.outstream).finish();
                this.outstream.flush();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (isok) {
            CVSTracer.traceIf(request.traceRequest, "CVSRequest: reading response...");
            ui.uiDisplayProgressMsg("Reading server response...");
            this.readAndParseResponse(request, response);
        } else {
            CVSTracer.traceIf(request.traceRequest, "CVSRequest: Error sending command request.");
            ui.uiDisplayProgressMsg("Error sending command request...");
            this.buildErrorResponse(request, response, "during processing of cvs request" + (this.getReason().length() < 1 ? "" : ": {" + this.getReason() + "}"));
        }
        ui.uiDisplayProgressMsg("Closing CVS server connection.");
        this.closeServer();
        if (this.checkForCancel(response)) {
            return response;
        }
        CVSTracer.traceIf(request.traceRequest, "**=========================================================================**");
        ui.uiDisplayProgressMsg("Command completed with '" + (response.getStatus() == 0 ? "ok" : "error") + "' status.");
        return response;
    }

    private String generateTempName() {
        ++this.tempCounter;
        String randStr = Long.toHexString(this.tempCounter % 0xFFFFFFF);
        if (randStr.length() > 7) {
            randStr = randStr.substring(randStr.length() - 7);
        }
        String result = "T" + randStr + ".cvs";
        CVSTracer.traceIf(false, "TEMPFILE: counter '" + this.tempCounter + "' name '" + result + "'");
        return result;
    }

    public String generateTempPath() {
        File tFile;
        String path = null;
        while ((tFile = new File(path = this.tempPath + "/" + this.generateTempName())).exists()) {
            CVSTracer.traceWithStack("CVSClient.generateTempPath: ERROR '" + path + "' exists!");
        }
        return path;
    }

    private boolean requestIsQueued(CVSRequest request) {
        return request.queueResponse || request.responseHandler == null;
    }

    private boolean processResponseItem(CVSRequest request, CVSResponse response, CVSResponseItem item) {
        boolean result = true;
        if (request.execInCurDir && request.getDirEntry() != null) {
            String itemPath = item.getPathName();
            String pfxPath = request.getDirEntry().getLocalPathName();
            if (itemPath != null) {
                itemPath = itemPath.startsWith("./") ? pfxPath + itemPath.substring(2) : pfxPath + itemPath;
                item.setPathName(itemPath);
            }
        }
        if (this.requestIsQueued(request)) {
            response.addResponseItem(item);
        } else {
            result = request.responseHandler.handleResponseItem(request, response, item);
        }
        return result;
    }

    public CVSResponse readAndParseResponse(CVSRequest request, CVSResponse response) {
        boolean status = false;
        boolean gotStatus = false;
        String line = null;
        CVSResponseItem currItem = null;
        boolean isok = true;
        while (isok) {
            CVSResponseItem newItem;
            int index;
            if (this.isCanceled()) break;
            line = this.readLine();
            if (line == null) {
                CVSTracer.traceIf(request.traceResponse, "PARSE: End of file on input stream.");
                break;
            }
            CVSTracer.traceIf(false, "CVSClient.readAndParseResponse: INLINE '" + line + "' currItem '" + (currItem == null ? "(null)" : currItem.toString()) + "'");
            if (currItem != null) {
                int itemType = currItem.getType();
                if (currItem.getAddState() == 1) {
                    CVSTracer.traceIf(request.traceResponse, "PARSE: FullPath '" + line + "'");
                    if (line.endsWith("/./")) {
                        line = line.substring(0, line.length() - 2);
                        CVSTracer.traceIf(request.traceResponse, "PARSE: Adjusted FullPath '" + line + "'");
                    }
                    currItem.setRepositoryName(line);
                } else if (currItem.getAddState() == 2) {
                    CVSTracer.traceIf(request.traceResponse, "PARSE: Entry '" + line + "'");
                    currItem.setEntriesLine(line);
                } else if (currItem.getAddState() == 3) {
                    CVSTracer.traceIf(request.traceResponse, "PARSE: Mode '" + line + "'");
                    currItem.setModeLine(line);
                } else if (currItem.getAddState() == 5) {
                    CVSTracer.traceIf(request.traceResponse, "PARSE: Tag Spec '" + line + "'");
                    currItem.setTagSpec(line);
                } else if (currItem.getAddState() == 6) {
                    CVSTracer.traceIf(request.traceResponse, "PARSE: Program Name '" + line + "'");
                    currItem.setProgram(line);
                } else if (currItem.getAddState() == 4) {
                    CVSTracer.traceIf(request.traceResponse, "PARSE: New Name '" + line + "'");
                    currItem.setNewName(line);
                }
                block0 : switch (itemType) {
                    case 6: 
                    case 7: 
                    case 11: 
                    case 14: 
                    case 15: {
                        String itemCmdName = itemType == 6 ? "Created" : (itemType == 7 ? "Merged" : (itemType == 11 ? "Patched" : (itemType == 14 ? "Updated" : "Update-existing")));
                        switch (currItem.getAddState()) {
                            case 1: {
                                currItem.setAddState(2);
                                break block0;
                            }
                            case 2: {
                                currItem.setAddState(3);
                                break block0;
                            }
                            case 3: {
                                currItem.setAddState(7);
                                File file = new File(this.generateTempPath());
                                String name = currItem.getRepositoryName();
                                index = name.lastIndexOf(47);
                                if (index >= 0) {
                                    name = name.substring(index + 1);
                                }
                                name = currItem.getPathName() + name;
                                if (this.requestIsQueued(request)) {
                                    request.getUserInterface().uiDisplayProgressMsg("Downloading file '" + name + "'...");
                                }
                                if (this.retrieveFile(currItem, file)) {
                                    currItem.setFile(file);
                                    isok = this.processResponseItem(request, response, currItem);
                                } else {
                                    response.appendStdErr("ERROR downloading '" + itemCmdName + "' file '" + name + "'\n      into temporary file '" + file.getPath() + "'.\n");
                                    response.appendStdErr("REASON " + this.getReason() + "\n");
                                    status = true;
                                }
                                currItem = null;
                            }
                        }
                        break;
                    }
                    case 1: 
                    case 9: {
                        if (currItem.getAddState() == 1) {
                            currItem.setAddState(2);
                            break;
                        }
                        isok = this.processResponseItem(request, response, currItem);
                        currItem = null;
                        break;
                    }
                    case 5: {
                        if (currItem.getAddState() == 1) {
                            currItem.setAddState(4);
                            break;
                        }
                        isok = this.processResponseItem(request, response, currItem);
                        currItem = null;
                        break;
                    }
                    case 19: {
                        if (currItem.getAddState() == 1) {
                            currItem.setAddState(5);
                            break;
                        }
                        isok = this.processResponseItem(request, response, currItem);
                        currItem = null;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 10: 
                    case 12: 
                    case 13: 
                    case 17: 
                    case 18: 
                    case 20: {
                        isok = this.processResponseItem(request, response, currItem);
                        currItem = null;
                        break;
                    }
                    default: {
                        CVSLog.logMsg("PARSE: ERROR unknown currentItem type '" + currItem.getType() + "'");
                        break;
                    }
                }
                continue;
            }
            if (line.startsWith("ok")) {
                CVSTracer.traceIf(request.traceResponse, "PARSE: ok");
                response.setStatus(0);
                gotStatus = true;
                break;
            }
            if (line.startsWith("error")) {
                CVSTracer.traceIf(request.traceResponse, "PARSE: error '" + line + "'");
                gotStatus = true;
                String errCodeStr = "";
                String errTextStr = "";
                if (line.length() > 6) {
                    if ((line = line.substring(6)).startsWith(" ")) {
                        errCodeStr = "";
                        errTextStr = line.substring(1);
                    } else {
                        index = line.indexOf(32);
                        if (index > 0) {
                            errCodeStr = line.substring(0, index);
                            errTextStr = line.substring(index + 1);
                        } else {
                            errCodeStr = "";
                            errTextStr = line;
                        }
                    }
                }
                response.setErrorStatus(errCodeStr, errTextStr);
                break;
            }
            if (line.startsWith("I LOVE YOU")) {
                CVSLog.logMsg("PARSE: GOT LOVE MESSAGE '" + line + "'");
                continue;
            }
            if (line.startsWith("I HATE YOU")) {
                CVSLog.logMsg("PARSE: GOT HATE MESSAGE '" + line + "'");
                gotStatus = true;
                response.setErrorStatus("-1", "INVALID LOGIN");
                break;
            }
            if (line.startsWith("Updated ")) {
                String pathName = line.substring(8);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Update '" + pathName + "'");
                newItem = new CVSResponseItem(14);
                newItem.setPathName(pathName);
                newItem.setAddState(request.useDirectory ? 1 : 2);
                currItem = newItem;
                continue;
            }
            if (line.startsWith("Merged ")) {
                String pathName = line.substring(7);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Merged '" + pathName + "'");
                newItem = new CVSResponseItem(7);
                newItem.setPathName(pathName);
                newItem.setAddState(request.useDirectory ? 1 : 2);
                currItem = newItem;
                continue;
            }
            if (line.startsWith("Update-existing ")) {
                String pathName = line.substring(16);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Update-existing '" + pathName + "'");
                newItem = new CVSResponseItem(15);
                newItem.setPathName(pathName);
                newItem.setAddState(request.useDirectory ? 1 : 2);
                currItem = newItem;
                continue;
            }
            if (line.startsWith("Created ")) {
                String pathName = line.substring(8);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Created '" + pathName + "'");
                newItem = new CVSResponseItem(6);
                newItem.setPathName(pathName);
                newItem.setAddState(request.useDirectory ? 1 : 2);
                currItem = newItem;
                continue;
            }
            if (line.startsWith("Patched ")) {
                String pathName = line.substring(8);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Patched '" + pathName + "'");
                newItem = new CVSResponseItem(11);
                newItem.setPathName(pathName);
                newItem.setAddState(request.useDirectory ? 1 : 2);
                currItem = newItem;
                continue;
            }
            if (line.startsWith("Checksum ")) {
                String sumStr = line.substring(9);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Checksum '" + sumStr + "'");
                newItem = new CVSResponseItem(2);
                newItem.setChecksum(sumStr);
                isok = this.processResponseItem(request, response, newItem);
                continue;
            }
            if (line.startsWith("Module-expansion ")) {
                String pathName = line.substring(17);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Module-expansion '" + pathName + "'");
                newItem = new CVSResponseItem(8);
                newItem.setPathName(pathName);
                isok = this.processResponseItem(request, response, newItem);
                continue;
            }
            if (line.startsWith("Notified ")) {
                String pathName = line.substring(9);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Notified '" + pathName + "'");
                newItem = new CVSResponseItem(10);
                newItem.setPathName(pathName);
                if (request.useDirectory) {
                    currItem = newItem;
                    newItem.setAddState(1);
                    continue;
                }
                isok = this.processResponseItem(request, response, newItem);
                continue;
            }
            if (line.startsWith("Removed ")) {
                String pathName = line.substring(8);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Removed '" + pathName + "'");
                newItem = new CVSResponseItem(12);
                newItem.setPathName(pathName);
                if (request.useDirectory) {
                    currItem = newItem;
                    newItem.setAddState(1);
                    continue;
                }
                isok = this.processResponseItem(request, response, newItem);
                continue;
            }
            if (line.startsWith("Remove-entry ")) {
                String pathName = line.substring(13);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Remove-entry '" + pathName + "'");
                newItem = new CVSResponseItem(13);
                newItem.setPathName(pathName);
                if (request.useDirectory) {
                    currItem = newItem;
                    newItem.setAddState(1);
                    continue;
                }
                isok = this.processResponseItem(request, response, newItem);
                continue;
            }
            if (line.startsWith("Checked-in ")) {
                String pathName = line.substring(11);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Checked-in '" + pathName + "'");
                newItem = new CVSResponseItem(1);
                newItem.setPathName(pathName);
                newItem.setAddState(request.useDirectory ? 1 : 2);
                currItem = newItem;
                continue;
            }
            if (line.startsWith("New-entry ")) {
                String pathName = line.substring(10);
                CVSTracer.traceIf(request.traceResponse, "PARSE: New-entry '" + pathName + "'");
                newItem = new CVSResponseItem(9);
                newItem.setPathName(pathName);
                newItem.setAddState(request.useDirectory ? 1 : 2);
                currItem = newItem;
                continue;
            }
            if (line.startsWith("Copy-file ")) {
                String pathName = line.substring(10);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Copy-file '" + pathName + "'");
                newItem = new CVSResponseItem(5);
                newItem.setPathName(pathName);
                newItem.setAddState(request.useDirectory ? 1 : 4);
                currItem = newItem;
                continue;
            }
            if (line.startsWith("Set-sticky ")) {
                String pathName = line.substring(11);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Set-sticky '" + pathName + "'");
                newItem = new CVSResponseItem(19);
                newItem.setPathName(pathName);
                newItem.setAddState(request.useDirectory ? 1 : 5);
                currItem = newItem;
                continue;
            }
            if (line.startsWith("Clear-sticky ")) {
                String pathName = line.substring(13);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Clear-sticky '" + pathName + "'");
                newItem = new CVSResponseItem(4);
                newItem.setPathName(pathName);
                if (request.useDirectory) {
                    currItem = newItem;
                    newItem.setAddState(1);
                    continue;
                }
                isok = this.processResponseItem(request, response, newItem);
                continue;
            }
            if (line.startsWith("Set-static-directory ")) {
                String pathName = line.substring(21);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Set-static-directory '" + pathName + "'");
                newItem = new CVSResponseItem(18);
                newItem.setPathName(pathName);
                if (request.useDirectory) {
                    currItem = newItem;
                    newItem.setAddState(1);
                    continue;
                }
                isok = this.processResponseItem(request, response, newItem);
                continue;
            }
            if (line.startsWith("Clear-static-directory ")) {
                String pathName = line.substring(23);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Clear-static-directory '" + pathName + "'");
                newItem = new CVSResponseItem(3);
                newItem.setPathName(pathName);
                if (request.useDirectory) {
                    currItem = newItem;
                    newItem.setAddState(1);
                    continue;
                }
                isok = this.processResponseItem(request, response, newItem);
                continue;
            }
            if (line.startsWith("Set-checkin-prog ")) {
                String pathName = line.substring(17);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Set-checkin-prog '" + pathName + "'");
                newItem = new CVSResponseItem(17);
                newItem.setPathName(pathName);
                newItem.setAddState(6);
                currItem = newItem;
                continue;
            }
            if (line.startsWith("Set-update-prog ")) {
                String pathName = line.substring(16);
                CVSTracer.traceIf(request.traceResponse, "PARSE: Set-update-prog '" + pathName + "'");
                newItem = new CVSResponseItem(20);
                newItem.setPathName(pathName);
                newItem.setAddState(6);
                currItem = newItem;
                continue;
            }
            if (line.startsWith("E ")) {
                if (request.isRedirected()) {
                    request.redirectLine(line.substring(2));
                    continue;
                }
                response.appendStdErr(line.substring(2) + "\n");
                continue;
            }
            if (line.startsWith("M ")) {
                if (request.isRedirected()) {
                    request.redirectLine(line.substring(2));
                    continue;
                }
                response.appendStdOut(line.substring(2) + "\n");
                continue;
            }
            if (line.startsWith("Valid-requests ")) {
                CVSResponseItem newItem2 = new CVSResponseItem(16);
                newItem2.setValidRequests(line.substring(15));
                isok = this.processResponseItem(request, response, newItem2);
                continue;
            }
            response.appendStdErr("WARNING: stray line:\n   '" + line + "'\n");
        }
        if (!this.isCanceled()) {
            if (gotStatus) {
                if (status) {
                    response.setStatus(1);
                }
            } else {
                response.appendStdErr("\n" + this.getReason() + "\nShort response, no status response from server.\n");
                response.setStatus(1);
            }
        }
        return response;
    }

    public boolean retrieveFile(CVSResponseItem item, File file) {
        boolean ok = true;
        boolean use_gzip = false;
        FileOutputStream out = null;
        int fileSize = 0;
        int bytes = 0;
        String line = null;
        line = this.readLine();
        if (line == null) {
            this.setReason("CVSClient.retrieveFile: ERROR size line is null!");
            CVSLog.logMsg(this.getReason());
            ok = false;
        }
        if (ok) {
            if (line.startsWith("z")) {
                item.setGZIPed(true);
                line = line.substring(1);
            }
            try {
                fileSize = Integer.valueOf(line);
            }
            catch (NumberFormatException ex) {
                this.setReason("CVSClient.retrieveFile: ERROR size line is invalid '" + line + "'");
                CVSLog.logMsg(this.getReason());
                ok = false;
            }
        }
        if (ok) {
            try {
                out = new FileOutputStream(file);
            }
            catch (IOException ex) {
                this.setReason("CVSClient.retrieveFile: ERROR opening output file '" + file.getPath() + "'\n    " + ex.getMessage());
                CVSLog.logMsg(this.getReason());
            }
        }
        if (ok) {
            byte[] buffer = new byte[8192];
            int length = fileSize;
            while (length > 0) {
                bytes = length > 8192 ? 8192 : length;
                try {
                    bytes = this.instream.read(buffer, 0, bytes);
                }
                catch (IOException ex) {
                    ok = false;
                    this.setReason("CVSClient.retrieveFile: ERROR reading file data:\n   " + ex.getMessage());
                    CVSLog.logMsg(this.getReason());
                    break;
                }
                if (bytes < 0) break;
                length -= bytes;
                if (out != null) {
                    try {
                        out.write(buffer, 0, bytes);
                    }
                    catch (IOException ex) {
                        ok = false;
                        this.setReason("CVSClient.retrieveFile: ERROR writing output file:\n   " + ex.getMessage());
                        CVSLog.logMsg(this.getReason());
                        try {
                            out.close();
                        }
                        catch (IOException ex2) {
                            // empty catch block
                        }
                        out = null;
                        break;
                    }
                }
                if (this.isCanceled()) break;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    this.setReason("CVSClient.retrieveFile: ERROR closing output file:\n   " + ex.getMessage());
                    CVSLog.logMsg(this.getReason());
                    ok = false;
                }
            }
        }
        return ok && out != null;
    }

    public boolean sendFileContents(InputStream in) {
        boolean result = true;
        byte[] buffer = new byte[16384];
        while (result) {
            int bytes;
            try {
                bytes = in.read(buffer, 0, buffer.length);
            }
            catch (IOException ex) {
                result = false;
                this.setReason("sendFileRaw: ERROR reading input file: " + ex.getMessage());
                CVSLog.logMsg(this.getReason());
                break;
            }
            if (bytes < 0) break;
            try {
                this.outstream.write(buffer, 0, bytes);
            }
            catch (IOException ex) {
                result = false;
                this.setReason("sendFileRaw: ERROR writing file data: " + ex.getMessage());
                CVSLog.logMsg(this.getReason());
                break;
            }
            if (this.isCanceled()) break;
        }
        try {
            this.outstream.flush();
        }
        catch (IOException ex) {
            result = false;
            this.setReason("sendFileRaw: ERROR flushing server connection: " + ex.getMessage());
            CVSLog.logMsg(this.getReason());
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            result = false;
            this.setReason("sendFileRaw: ERROR closing input file: " + ex.getMessage());
            CVSLog.logMsg(this.getReason());
        }
        return result;
    }

    public boolean sendFileRaw(CVSEntry entry, File entryFile, boolean useGzipFile) {
        boolean result;
        block12: {
            result = true;
            boolean usingGzip = false;
            File gzipFile = null;
            BufferedInputStream in = null;
            byte[] buffer = new byte[16384];
            long fileSize = entryFile.length();
            long beginMillis = System.currentTimeMillis();
            try {
                in = new BufferedInputStream(new FileInputStream(entryFile));
            }
            catch (IOException ex) {
                result = false;
            }
            boolean bl = usingGzip = useGzipFile && fileSize > 1024L;
            if (result && usingGzip) {
                try {
                    int bytes;
                    gzipFile = new File(this.generateTempPath());
                    BufferedOutputStream out = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(gzipFile)));
                    while ((bytes = in.read(buffer, 0, buffer.length)) >= 0) {
                        out.write(buffer, 0, bytes);
                        if (!this.isCanceled()) continue;
                    }
                    in.close();
                    out.close();
                    in = new BufferedInputStream(new FileInputStream(gzipFile));
                    fileSize = gzipFile.length();
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                    result = false;
                }
            }
            long endMillis = System.currentTimeMillis();
            if (result) {
                Long sizeLong = new Long(fileSize);
                String sizeStr = sizeLong.toString();
                if (usingGzip) {
                    sizeStr = "z" + sizeStr;
                }
                if (result = this.sendLine(sizeStr)) {
                    result = this.sendFileContents(in);
                } else {
                    this.setReason("sendFileRaw: ERROR writing file size: " + this.getReason());
                    CVSLog.logMsg(this.getReason());
                }
            }
            if (!usingGzip || gzipFile == null || !gzipFile.exists()) break block12;
            try {
                gzipFile.delete();
            }
            catch (SecurityException ex) {
                CVSLog.logMsg("sendFileRaw: WARNING deleting temp file: " + ex.getMessage());
            }
        }
        return result;
    }

    public boolean sendFileAscii(CVSEntry entry, File entryFile, boolean gzipFileMode) {
        boolean result;
        block21: {
            BufferedReader in = null;
            BufferedOutputStream out = null;
            boolean usingGzip = false;
            result = true;
            long beginMillis = System.currentTimeMillis();
            try {
                in = new BufferedReader(new FileReader(entryFile));
            }
            catch (IOException ex) {
                this.setReason("sendFileAscii: can not open input file '" + entryFile.getPath() + "' " + ex.getMessage());
                result = false;
            }
            File tempFile = new File(this.generateTempPath());
            try {
                if (gzipFileMode && entryFile.length() > 1024L) {
                    usingGzip = true;
                    out = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(tempFile)));
                } else {
                    out = new BufferedOutputStream(new FileOutputStream(tempFile));
                }
            }
            catch (IOException ex) {
                result = false;
                this.setReason("sendFileAscii: can not open output file '" + tempFile.getPath() + "' " + ex.getMessage());
                CVSLog.logMsg(this.getReason());
            }
            if (!result) break block21;
            do {
                try {
                    String inLine = this.readAsciiLine(in);
                    if (inLine == null) break;
                    out.write(inLine.getBytes());
                    out.write(10);
                }
                catch (IOException ex) {
                    result = false;
                    this.setReason("sendFileAscii: failed converting into temp file '" + tempFile.getPath() + "' " + ex.getMessage());
                    CVSLog.logMsg(this.getReason());
                }
            } while (!this.isCanceled());
            try {
                in.close();
            }
            catch (IOException ex) {
                result = false;
                this.setReason("sendFileAscii: ERROR closing input file: " + ex.getMessage());
                CVSLog.logMsg(this.getReason());
            }
            try {
                out.close();
            }
            catch (IOException ex) {
                result = false;
                this.setReason("sendFileAscii: ERROR closing input file: " + ex.getMessage());
                CVSLog.logMsg(this.getReason());
            }
            long endMillis = System.currentTimeMillis();
            if (result) {
                Long sizeLong = new Long(tempFile.length());
                String sizeStr = sizeLong.toString();
                if (usingGzip) {
                    sizeStr = "z" + sizeStr;
                }
                if (result = this.sendLine(sizeStr)) {
                    try {
                        BufferedInputStream content = new BufferedInputStream(new FileInputStream(tempFile));
                        result = this.sendFileContents(content);
                    }
                    catch (FileNotFoundException ex) {
                        result = false;
                        this.setReason("sendFileAscii: failed re-opening temp file '" + tempFile.getPath() + "' " + ex.getMessage());
                        CVSLog.logMsg(this.getReason());
                    }
                } else {
                    this.setReason("sendFileRaw: ERROR writing file size: " + this.getReason());
                    CVSLog.logMsg(this.getReason());
                }
                try {
                    tempFile.delete();
                }
                catch (SecurityException ex) {
                    CVSLog.logMsg("sendFileAscii: WARNING deleting temp file: " + ex.getMessage());
                }
            }
        }
        return result;
    }

    public String readAsciiLine(Reader in) {
        String ls = System.getProperty("line.separator");
        int lineSepIdx = 0;
        int lineSepLen = ls.length();
        char[] lineSep = new char[lineSepLen];
        ls.getChars(0, lineSepLen, lineSep, 0);
        StringBuffer line = new StringBuffer(132);
        try {
            while (true) {
                int i;
                int inByte;
                if ((inByte = in.read()) == -1) {
                    i = 0;
                    while (i < lineSepIdx) {
                        line.append(lineSep[i]);
                        ++i;
                    }
                    if (line.length() == 0) {
                        line = null;
                    }
                    break;
                }
                char ch = (char)inByte;
                if (ch == lineSep[lineSepIdx]) {
                    if (++lineSepIdx < lineSepLen) continue;
                    break;
                }
                i = 0;
                while (i < lineSepIdx) {
                    line.append(lineSep[i]);
                    ++i;
                }
                lineSepIdx = 0;
                if (ch == lineSep[lineSepIdx]) {
                    if (++lineSepIdx < lineSepLen) continue;
                    break;
                }
                line.append(ch);
            }
        }
        catch (IOException ex) {
            line = null;
        }
        return line != null ? line.toString() : null;
    }

    public boolean sendValidResponses(CVSRequest request, String additional) {
        boolean result = true;
        result = this.sendLine("Valid-responses E M ok error Valid-requests Created Merged Updated Update-existing Removed Remove-entry New-entry Checked-in Checksum Copy-file Notified Clear-sticky Set-sticky Clear-static-directory Set-static-directory " + additional);
        if (request.useUnchanged) {
            this.sendLine("UseUnchanged");
        }
        return result;
    }

    public boolean sendString(String string) {
        boolean result = true;
        CVSTracer.traceIf(this.tracingTCPData, "CVSClient.SENDString: '" + string + "'");
        try {
            this.outstream.write(string.getBytes());
            this.outstream.flush();
        }
        catch (IOException ex) {
            result = false;
        }
        return result;
    }

    public boolean sendLine(String line) {
        boolean result = true;
        CVSTracer.traceIf(this.tracingTCPData, "CVSClient.SENDLine: '" + line + "'");
        try {
            this.outstream.write((line + "\n").getBytes());
            this.outstream.flush();
        }
        catch (IOException ex) {
            CVSTracer.traceException("SENDLINE: " + line, ex);
            result = false;
        }
        return result;
    }

    public String readLine() {
        StringBuffer line = new StringBuffer(512);
        try {
            while (true) {
                int inByte;
                if ((inByte = this.instream.read()) == -1) {
                    if (line.length() == 0) {
                        line = null;
                    }
                } else {
                    char ch = (char)inByte;
                    if (ch != '\n') {
                        line.append(ch);
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException ex) {
            line = null;
        }
        CVSTracer.traceIf(this.tracingTCPData, "CVSClient.READLine: '" + (line == null ? "(null)" : line.toString()) + "'");
        return line != null ? line.toString() : null;
    }

    public String readResponse() {
        String line;
        StringBuffer result = new StringBuffer("");
        while ((line = this.readLine()) != null) {
            CVSTracer.traceIf(this.tracingTCPData, "CVSClient.READLine: '" + line + "'");
            result.append(line);
            result.append("\n");
            if (!line.startsWith("ok") && !line.startsWith("error")) continue;
            break;
        }
        return result.toString();
    }

    private InetAddress getInterfaceAddress(String host, int port) throws IOException {
        InetAddress interfaceAddress = null;
        try {
            Socket probe = new Socket(host, port);
            interfaceAddress = probe.getLocalAddress();
            probe.close();
        }
        catch (IOException ex) {
            interfaceAddress = InetAddress.getLocalHost();
        }
        return interfaceAddress;
    }

    private Socket bindLocalSocket(CVSRequest request, InetAddress localhost, String host, int port) throws IOException {
        Socket sock = null;
        String errMessage = "could not bind socket between 1025-1152 locally";
        int local = 1025;
        while (sock == null && local < 1152) {
            block4: {
                if (this.isCanceled()) break;
                CVSTracer.traceIf(request.traceRequest, "bindLocalSocket() trying port " + local);
                try {
                    sock = new Socket(host, port, localhost, local);
                }
                catch (IOException ex) {
                    this.socket = null;
                    CVSTracer.traceIf(request.traceRequest, "bindLocalSocket() exception message: " + ex.getMessage());
                    if (ex.getMessage().indexOf("refused") <= -1 && ex.getMessage().indexOf("timed out") <= -1) break block4;
                    errMessage = ex.getMessage();
                    break;
                }
            }
            ++local;
        }
        if (sock == null) {
            throw new IOException(errMessage);
        }
        return sock;
    }

    public boolean verifyHost(String host, SshPublicKey pk) throws TransportProtocolException {
        CVSTracer.traceIf(false, "CVSClient.verifyHost: host '" + host + "', Pk '" + pk + "'");
        return true;
    }

    private void establishSSHConnection(CVSRequest request) throws IOException {
        SshConnectionProperties properties = new SshConnectionProperties();
        CVSTracer.traceIf(request.traceRequest, "CVSClient.establishSSHConnection: creating connection...");
        InetAddress localhost = this.getInterfaceAddress(request.getHostName(), request.getPort());
        properties.setHost(request.getHostName());
        properties.setPort(request.getPort());
        CVSTracer.traceIf(request.traceRequest, "CVSClient.establishSSHConnection: localHost=" + localhost);
        this.sshClient = new SshClient();
        CVSTracer.traceIf(request.traceRequest, "CVSClient.establishSSHConnection: sshClient=" + this.sshClient);
        this.sshClient.connect(properties, (HostKeyVerification)this);
        CVSTracer.traceIf(request.traceRequest, "CVSClient.establishSSHConnection: connected");
        PasswordAuthenticationClient pwdAuth = new PasswordAuthenticationClient();
        pwdAuth.setUsername(request.getUserName());
        pwdAuth.setPassword(request.getPassword());
        int result = this.sshClient.authenticate(pwdAuth);
        CVSTracer.traceIf(request.traceRequest, "CVSClient.authenticate: result=" + result);
        if (result == 2) {
            CVSTracer.traceIf(request.traceRequest, "The authentication failed");
            throw new IOException("ssh authentication failure");
        }
        if (result == 3) {
            CVSTracer.traceIf(request.traceRequest, "The authentication succeeded but anotherauthentication is required");
            throw new IOException("ssh authentication partial");
        }
        if (result == 4) {
            CVSTracer.traceIf(request.traceRequest, "The authentication is complete");
        }
        this.sshSession = this.sshClient.openSessionChannel();
        CVSTracer.traceIf(request.traceRequest, "CVSClient.establishSSHConnection: sshSession=" + this.sshSession);
        boolean ok = this.sshSession.executeCommand(request.getServerCommand());
        CVSTracer.traceIf(request.traceRequest, "CVSClient.establishSSHConnection: command(" + request.getServerCommand() + ") = " + ok);
        if (!ok) {
            CVSTracer.traceIf(request.traceRequest, "CVSClient.establishSSHConnection: executeCommand( '" + request.getServerCommand() + "' failed.");
            throw new IOException("failed to execute command '" + request.getServerCommand() + "'");
        }
        CVSTracer.traceIf(request.traceRequest, "CVSClient.establishSSHConnection: command session established");
    }

    private Socket establishRSHSocket(CVSRequest request) throws IOException {
        Socket sock = null;
        InetAddress localhost = this.getInterfaceAddress(request.getHostName(), request.getPort());
        int local = 512;
        while (sock == null && local < 1024) {
            try {
                sock = new Socket(request.getHostName(), request.getPort(), localhost, local);
            }
            catch (IOException ex) {
                this.socket = null;
            }
            ++local;
        }
        if (sock == null) {
            throw new IOException("Could not bind rsh socket between 512-1023 locally.");
        }
        return sock;
    }

    private boolean openServer(CVSRequest request) {
        boolean result;
        this.socket = null;
        this.process = null;
        this.serverIsOpen = false;
        try {
            CVSTracer.traceIf(request.traceRequest, "CVSClient.openServer: creating connection...");
            result = true;
            switch (request.getConnectionMethod()) {
                case 1: {
                    this.socket = new Socket(request.getHostName(), request.getPort());
                    break;
                }
                case 3: {
                    this.establishSSHConnection(request);
                    break;
                }
                case 2: {
                    if (request.getRshProcess() != null) {
                        int index = request.getServerCommand().indexOf(32);
                        String[] argv = new String[6];
                        argv[0] = request.getRshProcess();
                        argv[1] = request.getHostName();
                        argv[2] = "-l";
                        argv[3] = request.getUserName();
                        if (index < 0) {
                            argv[4] = request.getServerCommand();
                            argv[5] = "server";
                        } else {
                            argv[4] = request.getServerCommand().substring(0, index);
                            argv[5] = request.getServerCommand().substring(index + 1);
                        }
                        if (request.traceRequest) {
                            int i = 0;
                            while (i < argv.length) {
                                CVSTracer.traceIf(true, "CVSClient.openServer: RSH argv[" + i + "] = '" + argv[i] + "'");
                                ++i;
                            }
                        }
                        this.process = Runtime.getRuntime().exec(argv);
                        break;
                    }
                    this.socket = this.establishRSHSocket(request);
                }
            }
            CVSTracer.traceIf(request.traceRequest, "CVSClient.openServer: creating i/o streams...");
            if (this.sshSession != null) {
                this.instream = new DataInputStream(this.sshSession.getInputStream());
                this.outstream = new DataOutputStream(this.sshSession.getOutputStream());
            } else if (this.process != null) {
                this.instream = new DataInputStream(this.process.getInputStream());
                this.outstream = new DataOutputStream(this.process.getOutputStream());
            } else if (this.socket != null) {
                this.instream = new DataInputStream(this.socket.getInputStream());
                this.outstream = new DataOutputStream(this.socket.getOutputStream());
            } else {
                CVSTracer.traceIf(request.traceRequest, "CVSClient.openServer: failed to establish connection.");
                result = false;
            }
            if (result) {
                CVSTracer.traceIf(request.traceRequest, "CVSClient.openServer: server is open.");
                this.serverIsOpen = true;
            }
        }
        catch (IOException ex) {
            this.serverIsOpen = false;
            int meth = request.getConnectionMethod();
            this.setReason("could not create " + (meth == 1 ? "INETD" : (meth == 2 ? "RSH" : "SSH")) + " connection for '" + this.port + "@" + request.getHostName() + "' --> " + ex.getMessage());
            CVSLog.logMsg(this.getReason());
        }
        if (this.serverIsOpen && this.socket != null && request.getConnectionMethod() == 2) {
            CVSTracer.traceIf(request.traceRequest, "CVSClient.openServer: performing rsh protocol initialization.");
            result = this.performRSHProtocol(request.getUserName(), request.getServerCommand());
            if (!result) {
                this.closeServer();
            }
        }
        return this.serverIsOpen;
    }

    public boolean performRSHProtocol(String remoteUserName, String serverCommand) {
        int status;
        try {
            this.outstream.write(48);
            this.outstream.write(0);
        }
        catch (IOException ex) {
            CVSLog.logMsg("RSH: FAIL-ed writing stderr port");
            return false;
        }
        String localUserName = System.getProperty("user.name", remoteUserName);
        try {
            this.outstream.write(localUserName.getBytes());
            this.outstream.write(0);
        }
        catch (IOException ex) {
            CVSLog.logMsg("RSH: FAIL-ed writing local user");
            return false;
        }
        try {
            this.outstream.write(remoteUserName.getBytes());
            this.outstream.write(0);
        }
        catch (IOException ex) {
            CVSLog.logMsg("RSH: FAIL-ed writing remote user");
            return false;
        }
        try {
            this.outstream.write(serverCommand.getBytes());
            this.outstream.write(0);
            this.outstream.flush();
        }
        catch (IOException ex) {
            CVSLog.logMsg("RSH: FAIL-ed writing command");
            return false;
        }
        try {
            status = this.instream.read();
        }
        catch (IOException ex) {
            CVSLog.logMsg("RSH: FAIL-ed reading status");
            return false;
        }
        return status == 0;
    }

    public boolean closeServer() {
        boolean result = true;
        if (this.serverIsOpen) {
            try {
                if (this.sshSession != null) {
                    this.sshSession.close();
                    this.sshClient.disconnect();
                } else {
                    this.instream.close();
                    this.outstream.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                } else if (this.process != null) {
                    this.process.destroy();
                }
            }
            catch (IOException ex) {
                result = false;
                this.setReason("could not close socket - " + ex.getMessage());
                CVSLog.logMsg(this.getReason());
            }
            this.socket = null;
            this.sshClient = null;
            this.sshSession = null;
            this.instream = null;
            this.outstream = null;
            this.serverIsOpen = false;
        }
        return result;
    }

    private class NullCVSUI
    implements CVSUserInterface {
        private NullCVSUI() {
        }

        public void uiDisplayProgressMsg(String message) {
        }

        public void uiDisplayProgramError(String error) {
        }

        public void uiDisplayResponse(CVSResponse response) {
        }
    }
}

