/*
 * Decompiled with CFR 0.152.
 */
package com.ice.cvsc;

import com.ice.cvsc.CVSRespItemVector;
import com.ice.cvsc.CVSResponseItem;
import java.io.PrintStream;

public class CVSResponse {
    public static final String RCS_ID = "$Id: CVSResponse.java,v 2.3 2003/07/27 01:08:32 time Exp $";
    public static final String RCS_REV = "$Revision: 2.3 $";
    public static final int OK = 0;
    public static final int ERROR = 1;
    private boolean valid = true;
    private int status;
    private String errorCode = "";
    private String errorText = "";
    private StringBuffer stdErrStr;
    private StringBuffer stdOutStr;
    private CVSRespItemVector itemList = new CVSRespItemVector();

    public CVSResponse() {
        this.stdErrStr = new StringBuffer(4096);
        this.stdOutStr = new StringBuffer(32);
    }

    public void appendStdOut(String text) {
        this.stdOutStr.append(text);
    }

    public void appendStdErr(String text) {
        this.stdErrStr.append(text);
    }

    public void addResponseItem(CVSResponseItem item) {
        this.itemList.appendItem(item);
    }

    public CVSRespItemVector getItemList() {
        return this.itemList;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
        this.errorCode = "";
        this.errorText = "";
    }

    public void setErrorStatus(String codeStr, String textStr) {
        this.status = 1;
        this.errorCode = codeStr;
        this.errorText = textStr;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public String getStderr() {
        return this.stdErrStr.toString();
    }

    public String getStdout() {
        return this.stdOutStr.toString();
    }

    public void appendStderr(String msg) {
        this.stdErrStr.append(msg);
    }

    public void appendStdout(String msg) {
        this.stdOutStr.append(msg);
    }

    public int itemTypeCount(int type) {
        int count = 0;
        int i = 0;
        while (i < this.itemList.size()) {
            CVSResponseItem item = this.itemList.itemAt(i);
            if (item.getType() == type) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public CVSResponseItem getFirstItemByType(int type) {
        int i = 0;
        while (i < this.itemList.size()) {
            CVSResponseItem item = this.itemList.itemAt(i);
            if (item.getType() == type) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public CVSResponseItem getNextItemByType(int type, CVSResponseItem lastItem) {
        CVSResponseItem item;
        int i = 0;
        while (i < this.itemList.size()) {
            item = this.itemList.itemAt(i);
            if (item == lastItem) {
                ++i;
                break;
            }
            ++i;
        }
        while (i < this.itemList.size()) {
            item = this.itemList.itemAt(i);
            if (item.getType() == type) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public void printResponse(PrintStream out) {
        out.println("=============================================================");
        out.println("RESPONSE has " + this.itemList.size() + " items:");
        if (this.itemList.size() > 0) {
            this.itemList.printResponseItemList(out, "   ");
        }
        out.println("\n" + this.getStderr() + "\n" + this.getStdout());
        out.println("=============================================================");
    }

    public boolean deleteTempFiles() {
        boolean result = true;
        int i = 0;
        while (i < this.itemList.size()) {
            CVSResponseItem item = this.itemList.itemAt(i);
            boolean err = item.deleteFile();
            if (!err) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    public String getDisplayResults() {
        StringBuffer finalResult = new StringBuffer(1024);
        finalResult.append(this.getResultText());
        finalResult.append(this.getResultStatus());
        return finalResult.toString();
    }

    public String getResultText() {
        StringBuffer resultBuf = new StringBuffer(1024);
        String stdout = this.getStdout();
        String stderr = this.getStderr();
        if (stderr.length() > 0 || stdout.length() > 0) {
            if (stderr.length() > 0) {
                resultBuf.append(stderr);
                if (stdout.length() > 0) {
                    resultBuf.append("\n");
                }
            }
            if (stdout.length() > 0) {
                resultBuf.append(stdout);
            }
        }
        return resultBuf.toString();
    }

    public String getResultStatus() {
        if (this.getStatus() == 0) {
            return "\n** The command completed successfully.";
        }
        return "\n** The command completed with an error status.";
    }

    public String toString() {
        if (this.valid) {
            return "CVSResponse: " + this.itemList.size() + " items.\n" + this.stdErrStr + "\n" + this.stdOutStr;
        }
        return "CVSResponse: not valid";
    }
}

