/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSCUtilities;
import com.ice.cvsc.CVSProject;
import com.ice.jcvsii.ConfigConstants;
import com.ice.jcvsii.ConfigDialog;
import com.ice.jcvsii.EntryNode;
import com.ice.jcvsii.JCVS;
import com.ice.jcvsii.MainFrame;
import com.ice.jcvsii.ProjectFrame;
import com.ice.jcvsii.ProjectFrameMgr;
import com.ice.jcvsii.ResourceMgr;
import com.ice.jcvsii.ServerDef;
import com.ice.pref.PrefsTuple;
import com.ice.pref.PrefsTupleTable;
import com.ice.pref.UserPrefs;
import com.ice.pref.UserPrefsFileLoader;
import com.ice.pref.UserPrefsLoader;
import com.ice.pref.UserPrefsStreamLoader;
import com.ice.util.AWTUtilities;
import com.ice.util.ResourceUtilities;
import com.ice.util.TempFileManager;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.activation.CommandMap;
import javax.activation.FileTypeMap;
import javax.activation.MailcapCommandMap;
import javax.activation.MimetypesFileTypeMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Config
implements ConfigConstants,
PropertyChangeListener {
    public static final String RCS_ID = "$Id: Config.java,v 1.7 2003/07/27 04:39:06 time Exp $";
    public static final String RCS_REV = "$Revision: 1.7 $";
    private boolean debug = false;
    private static Config instance = new Config();
    private UserPrefs defPrefs = null;
    private UserPrefs userPrefs = null;
    private UserPrefs editSpec = null;
    private UserPrefs defServers = null;
    private UserPrefs userServers = null;
    private Vector servers;
    private String mimeFileName = null;
    private String mailcapFileName = null;
    private PrefsTupleTable execCmdTable = null;
    private String defMailcapFilename;
    private String defMimetypesFilename;
    private String userPrefsFilename;
    private String userServersFilename;
    private String lastDitchTempDirname;
    private boolean isMacintoshF = false;
    private boolean isOS2F = false;
    private boolean isWindowsF = false;

    public static Config getInstance() {
        return instance;
    }

    public static UserPrefs getPreferences() {
        return Config.getInstance().getPrefs();
    }

    public boolean isMacintosh() {
        return this.isMacintoshF;
    }

    public boolean isWindows() {
        return this.isWindowsF;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public UserPrefs getPrefs() {
        return this.userPrefs;
    }

    public String getUserPrefsFilename() {
        return this.userPrefsFilename;
    }

    public String getUserServersFilename() {
        return this.userServersFilename;
    }

    public String getDefaultMailcapFilename() {
        return this.defMailcapFilename;
    }

    public String getDefaultMimetypesFilename() {
        return this.defMimetypesFilename;
    }

    public String getTemporaryDirectory() {
        return this.getPrefs().getProperty("global.temporaryDirectory", this.lastDitchTempDirname);
    }

    private void establishOSDistinctions() {
        String osName = System.getProperty("os.name");
        if ((osName = osName.toLowerCase()).startsWith("mac os")) {
            System.err.println("Assuming a Macintosh platform.");
            this.userPrefsFilename = "jCVS Preferences";
            this.userServersFilename = "jCVS Servers";
            this.defMailcapFilename = "jCVS Mailcap";
            this.defMimetypesFilename = "jCVS Mimetypes";
            this.lastDitchTempDirname = "";
            this.isMacintoshF = true;
        } else if (osName.startsWith("windows")) {
            System.err.println("Assuming a Windows platform.");
            this.userPrefsFilename = "jcvsii.txt";
            this.userServersFilename = "jcvsdef.txt";
            this.defMailcapFilename = "jcvsmailcap.txt";
            this.defMimetypesFilename = "jcvsmime.txt";
            this.lastDitchTempDirname = ".";
            this.isWindowsF = true;
        } else if (osName.startsWith("os/2")) {
            System.err.println("Assuming an OS/2 platform.");
            this.userPrefsFilename = "jcvsii.txt";
            this.userServersFilename = "jcvsdef.txt";
            this.defMailcapFilename = "jcvsmailcap.txt";
            this.defMimetypesFilename = "jcvsmime.txt";
            this.lastDitchTempDirname = ".";
            this.isOS2F = true;
        } else {
            System.err.println("Assuming a UNIX platform.");
            this.userPrefsFilename = ".jcvsii";
            this.userServersFilename = ".jcvsdef";
            this.defMailcapFilename = ".jcvsmailcap";
            this.defMimetypesFilename = ".jcvsmime";
            this.lastDitchTempDirname = ".";
        }
    }

    public void initializePreferences(String prefix) {
        this.establishOSDistinctions();
        MailcapCommandMap cMap = new MailcapCommandMap();
        MimetypesFileTypeMap fMap = new MimetypesFileTypeMap();
        this.defPrefs = new UserPrefs("jCVSII.Defaults");
        this.userPrefs = new UserPrefs("jCVSII.Config", this.defPrefs);
        UserPrefs.setInstance(this.userPrefs);
        this.editSpec = new UserPrefs("jCVSII.ConfigSpec", null);
        this.defServers = new UserPrefs("jCVSII.DefaultServers", null);
        this.userServers = new UserPrefs("jCVSII.UserServers", this.defServers);
        this.editSpec.setPropertyPrefix("");
        this.defPrefs.setPropertyPrefix(prefix);
        this.userPrefs.setPropertyPrefix(prefix);
        this.defServers.setPropertyPrefix("");
        this.userServers.setPropertyPrefix("");
    }

    public void checkCriticalProperties(Frame parent) {
        Vector<String> need = new Vector<String>();
        ResourceMgr rmgr = ResourceMgr.getInstance();
        String tempDir = this.userPrefs.getProperty("global.temporaryDirectory", null);
        if (tempDir == null) {
            need.addElement("global.temporaryDirectory");
        } else {
            File tempDirF = new File(tempDir);
            if (!tempDirF.exists()) {
                Object[] fmtArgs = new String[]{tempDirF.getPath()};
                String msg = rmgr.getUIFormat("misc.tempdir.needs.config.msg", fmtArgs);
                String title = rmgr.getUIFormat("misc.tempdir.needs.config.title", fmtArgs);
                JOptionPane.showMessageDialog(parent, msg, title, 2);
                need.addElement("global.temporaryDirectory");
            } else if (!tempDirF.canWrite()) {
                Object[] fmtArgs = new String[]{tempDirF.getPath()};
                String msg = rmgr.getUIFormat("misc.tempdir.cannot.write.msg", fmtArgs);
                String title = rmgr.getUIFormat("misc.tempdir.cannot.write.title", fmtArgs);
                JOptionPane.showMessageDialog(parent, msg, title, 2);
                need.addElement("global.temporaryDirectory");
            }
        }
        if (need.size() > 0) {
            Object[] editProps = new String[need.size()];
            need.copyInto(editProps);
            this.editConfiguration(parent, (String[])editProps);
        }
        tempDir = this.userPrefs.getProperty("global.temporaryDirectory", "");
        TempFileManager.initialize(tempDir, "jcvs", ".tmp");
    }

    public void initializeGlobalProperties() {
        boolean traceAll;
        boolean debugSetting;
        String format = this.userPrefs.getProperty("project.modified.format", "EEE MMM dd HH:mm:ss yyyy");
        EntryNode.setTimestampFormat(format);
        this.loadServerDefinitions();
        this.loadExecCmdDefinitions();
        CVSProject.deepDebug = debugSetting = this.userPrefs.getBoolean("global.project.deepDebug", false);
        CVSProject.debugEntryIO = debugSetting = this.userPrefs.getBoolean("global.project.debugEntryIO", false);
        CVSProject.overTraceTCP = traceAll = this.userPrefs.getBoolean("global.traceAll", false);
        CVSProject.overTraceRequest = traceAll;
        CVSProject.overTraceResponse = traceAll;
        CVSProject.overTraceProcessing = traceAll;
        String[] subs = new String[]{"global.temporaryDirectory", "global.traceAll", "global.project.deepDebug", "global.project.debugEntryIO", "project.modified.format", "plaf.lookAndFeel.classname"};
        int i = 0;
        while (i < subs.length) {
            this.userPrefs.addPropertyChangeListener(subs[i], this);
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName.equals("global.traceAll")) {
            boolean newSetting;
            CVSProject.overTraceTCP = newSetting = this.userPrefs.getBoolean("global.traceAll", false);
            CVSProject.overTraceRequest = newSetting;
            CVSProject.overTraceResponse = newSetting;
            CVSProject.overTraceProcessing = newSetting;
        } else if (propName.equals("global.project.deepDebug")) {
            boolean newSetting;
            CVSProject.deepDebug = newSetting = this.userPrefs.getBoolean("global.project.deepDebug", false);
        } else if (propName.equals("global.project.debugEntryIO")) {
            boolean newSetting;
            CVSProject.debugEntryIO = newSetting = this.userPrefs.getBoolean("global.project.debugEntryIO", false);
        } else if (propName.equals("global.temporaryDirectory")) {
            String tempDir = this.userPrefs.getProperty("global.temporaryDirectory", "");
            TempFileManager.clearTemporaryFiles();
            TempFileManager.initialize(tempDir, "jcvs", ".tmp");
        } else if (propName.equals("project.modified.format")) {
            String format = this.userPrefs.getProperty("project.modified.format", "EEE MMM dd HH:mm:ss yyyy");
            EntryNode.setTimestampFormat(format);
        } else if (propName.equals("plaf.lookAndFeel.classname")) {
            String plafClassName = this.userPrefs.getProperty("plaf.lookAndFeel.classname", null);
            if (plafClassName == null || plafClassName.equals("DEFAULT")) {
                plafClassName = UIManager.getSystemLookAndFeelClassName();
            }
            try {
                UIManager.setLookAndFeel(plafClassName);
            }
            catch (Exception ex) {
                // empty catch block
            }
            MainFrame frm = JCVS.getMainFrame();
            SwingUtilities.updateComponentTreeUI(frm);
            Enumeration enumeration = ProjectFrameMgr.enumerateProjectFrames();
            while (enumeration.hasMoreElements()) {
                SwingUtilities.updateComponentTreeUI((ProjectFrame)enumeration.nextElement());
            }
        }
    }

    public Vector getServerDefinitions() {
        return this.servers;
    }

    public String getExecCommandKey(String verb, String extension) {
        return extension + "." + verb;
    }

    public String getExecCommandArgs(String verb, String extension) {
        String result = null;
        String key = this.getExecCommandKey(verb, extension);
        PrefsTuple tup = this.execCmdTable.getTuple(key);
        if (tup != null) {
            result = tup.getValueAt(1);
        }
        return result;
    }

    public String getExecCommandEnv(String verb, String extension) {
        String result = null;
        String key = this.getExecCommandKey(verb, extension);
        PrefsTuple tup = this.execCmdTable.getTuple(key);
        if (tup != null) {
            result = tup.getValueAt(0);
        }
        return result;
    }

    public PrefsTupleTable getExecCmdDefinitions() {
        return this.execCmdTable;
    }

    public void loadExecCmdDefinitions() {
        this.execCmdTable = this.userPrefs.getTupleTable("global.exec.verbs", null);
        if (this.execCmdTable == null) {
            this.execCmdTable = new PrefsTupleTable();
        }
    }

    public void loadServerDefinitions() {
        this.servers = new Vector();
        this.enumerateServerDefinitions(this.defServers.keys());
        this.enumerateServerDefinitions(this.userServers.keys());
    }

    private void sortServerVector(Vector v) {
        int i = 1;
        while (i < v.size()) {
            ServerDef B = (ServerDef)v.elementAt(i);
            int j = i;
            while (j > 0) {
                ServerDef A = (ServerDef)v.elementAt(j - 1);
                if (A.compareTo(B) <= 0) break;
                v.setElementAt(A, j);
                --j;
            }
            v.setElementAt(B, j);
            ++i;
        }
    }

    public void enumerateServerDefinitions(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith("server.") || !this.userServers.getBoolean(key, false)) continue;
            String token = key.substring("server.".length());
            String method = this.userServers.getProperty("param." + token + ".method", "pserver");
            String name = this.userServers.getProperty("param." + token + ".name", null);
            String module = this.userServers.getProperty("param." + token + ".module", "");
            String host = this.userServers.getProperty("param." + token + ".host", "");
            String user = this.userServers.getProperty("param." + token + ".user", "");
            String repos = this.userServers.getProperty("param." + token + ".repos", "");
            String desc = this.userServers.getProperty("param." + token + ".desc", "");
            if (name == null) continue;
            this.servers.addElement(new ServerDef(name, method, module, user, host, repos, desc));
        }
        this.sortServerVector(this.servers);
    }

    public void loadProjectPreferences(CVSProject project, UserPrefs prefs) {
        block3: {
            String propFilename = this.getUserPrefsFilename();
            String prefsPath = CVSCUtilities.exportPath(CVSProject.getAdminPrefsPath(CVSProject.rootPathToAdminPath(project.getLocalRootPath())));
            File prefsF = new File(prefsPath);
            try {
                UserPrefsFileLoader loader = (UserPrefsFileLoader)UserPrefsLoader.getLoader("FileLoader");
                loader.setFile(prefsF);
                loader.loadPreferences(prefs);
                if (this.debug) {
                    System.err.println("Loaded project preferences from '" + prefsF.getPath() + "'");
                }
            }
            catch (IOException ex) {
                if (!this.debug) break block3;
                System.err.println("No project preferences found at '" + prefsF.getPath() + "'");
            }
        }
    }

    public void saveProjectPreferences(CVSProject project, UserPrefs prefs) {
        String propFilename = this.getUserPrefsFilename();
        String prefsPath = CVSCUtilities.exportPath(CVSProject.getAdminPrefsPath(CVSProject.rootPathToAdminPath(project.getLocalRootPath())));
        File prefsF = new File(prefsPath);
        try {
            UserPrefsFileLoader loader = (UserPrefsFileLoader)UserPrefsLoader.getLoader("FileLoader");
            loader.setFile(prefsF);
            loader.storePreferences(prefs);
            if (this.debug) {
                System.err.println("Saved project preferences into '" + prefsF.getPath() + "'");
            }
        }
        catch (IOException ex) {
            System.err.println("Failed storing project preferences into '" + prefsF.getPath() + "', " + ex.getMessage());
        }
    }

    public void loadUserPreferences() {
        String propFilename = this.getUserPrefsFilename();
        File prefsF = new File(this.userPrefs.getUserHome(), propFilename);
        if (!prefsF.exists()) {
            System.err.println("No user preferences found at '" + prefsF.getPath() + "'");
            return;
        }
        if (!prefsF.canRead()) {
            System.err.println("ERROR Can not read user preferences at '" + prefsF.getPath() + "'");
            return;
        }
        try {
            UserPrefsStreamLoader loader = (UserPrefsStreamLoader)UserPrefsLoader.getLoader("StreamLoader");
            FileInputStream in = new FileInputStream(prefsF);
            loader.setInputStream(in);
            loader.loadPreferences(this.userPrefs);
            ((InputStream)in).close();
            System.err.println("Loaded user preferences from '" + prefsF.getPath() + "'");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadConfigEditorSpecification() {
        String specURL = "/com/ice/jcvsii/configspec.properties";
        InputStream in = null;
        in = ResourceUtilities.openNamedResource(specURL);
        UserPrefsStreamLoader loader = (UserPrefsStreamLoader)UserPrefsLoader.getLoader("StreamLoader");
        loader.setInputStream(in);
        loader.loadPreferences(this.editSpec);
        System.err.println("Loaded config editor specification from '" + specURL + "'");
        Object var5_5 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException ex2) {}
        return;
        {
            catch (IOException ex) {
                System.err.println("ERROR loading editor specification from '" + specURL + "'\n      " + ex.getMessage());
                Object var5_6 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadDefaultPreferences() {
        String defURL = "/com/ice/jcvsii/defaults.properties";
        UserPrefsStreamLoader loader = (UserPrefsStreamLoader)UserPrefsLoader.getLoader("StreamLoader");
        InputStream in = null;
        in = ResourceUtilities.openNamedResource(defURL);
        loader.setInputStream(in);
        loader.loadPreferences(this.defPrefs);
        System.err.println("Loaded default preferences from '" + defURL + "'");
        Object var6_4 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException ex2) {}
        return;
        {
            catch (IOException ex) {
                System.err.println("ERROR loading default preferences from '" + defURL + "'\n      " + ex.getMessage());
                Object var6_5 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadDefaultServerDefinitions() {
        String defURL = "/com/ice/jcvsii/servers.properties";
        UserPrefsStreamLoader loader = (UserPrefsStreamLoader)UserPrefsLoader.getLoader("StreamLoader");
        InputStream in = null;
        in = ResourceUtilities.openNamedResource(defURL);
        loader.setInputStream(in);
        loader.loadPreferences(this.defServers);
        System.err.println("Loaded default server definitions from '" + defURL + "'");
        Object var6_4 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException ex2) {}
        return;
        {
            catch (IOException ex) {
                System.err.println("ERROR loading default server definitions from '" + defURL + "'\n      " + ex.getMessage());
                Object var6_5 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void loadUserServerDefinitions() {
        String propFilename = this.getUserServersFilename();
        File prefsF = new File(this.userPrefs.getUserHome(), propFilename);
        try {
            FileInputStream in = new FileInputStream(prefsF);
            UserPrefsStreamLoader loader = (UserPrefsStreamLoader)UserPrefsLoader.getLoader("StreamLoader");
            loader.setInputStream(in);
            loader.loadPreferences(this.userServers);
            ((InputStream)in).close();
            System.err.println("Loaded user server definitions from '" + prefsF.getPath() + "'");
        }
        catch (IOException ex) {
            System.err.println("No user server definitions found at '" + prefsF.getPath() + "'");
        }
    }

    public void savePreferences() {
        String propFilename = this.getUserPrefsFilename();
        File prefsF = new File(this.userPrefs.getUserHome(), propFilename);
        try {
            UserPrefsFileLoader loader = (UserPrefsFileLoader)UserPrefsLoader.getLoader("FileLoader");
            loader.setFile(prefsF);
            loader.storePreferences(this.userPrefs);
            System.err.println("Stored user preferences to '" + prefsF.getPath() + "'");
        }
        catch (IOException ex) {
            System.err.println("ERROR storing user preferences to '" + prefsF.getPath() + "'\n      " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadMailCap() {
        InputStream in;
        block12: {
            File capF;
            in = null;
            String where = "";
            if (this.mailcapFileName != null) {
                capF = new File(this.mailcapFileName);
            } else {
                String defMailcapFilename = this.getDefaultMailcapFilename();
                String mailcapFileName = this.userPrefs.getProperty("global.mailcap.fileName", defMailcapFilename);
                capF = new File(this.userPrefs.getUserHome(), mailcapFileName);
            }
            if (capF.exists() && capF.isFile() && capF.canRead()) {
                where = capF.getPath();
                in = new FileInputStream(capF);
            } else {
                where = "/com/ice/jcvsii/mailcap.txt";
                in = ResourceUtilities.openNamedResource(where);
            }
            if (in == null) break block12;
            System.err.println("Loading mailcap from '" + where + "'");
            CommandMap.setDefaultCommandMap(new MailcapCommandMap(in));
            System.err.println("Loaded mailcap from '" + where + "'");
        }
        Object var7_7 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException ex2) {}
        return;
        {
            catch (IOException ex) {
                CommandMap.setDefaultCommandMap(new MailcapCommandMap());
                System.err.println("Using default mailcap definition.");
                Object var7_8 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadMimeTypes() {
        InputStream in;
        block12: {
            File mimeF;
            in = null;
            String where = "";
            if (this.mimeFileName != null) {
                mimeF = new File(this.mimeFileName);
            } else {
                String defMimeFilename = this.getDefaultMimetypesFilename();
                String mimeFileName = this.userPrefs.getProperty("global.mimetypes.fileName", defMimeFilename);
                mimeF = new File(this.userPrefs.getUserHome(), mimeFileName);
            }
            if (mimeF.exists() && mimeF.isFile() && mimeF.canRead()) {
                where = mimeF.getPath();
                in = new FileInputStream(mimeF);
            } else {
                where = "/com/ice/jcvsii/mimetypes.txt";
                in = ResourceUtilities.openNamedResource(where);
            }
            if (in == null) break block12;
            FileTypeMap.setDefaultFileTypeMap(new MimetypesFileTypeMap(in));
            System.err.println("Loaded mime types from '" + where + "'");
        }
        Object var7_7 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException ex2) {}
        return;
        {
            catch (IOException ex) {
                FileTypeMap.setDefaultFileTypeMap(new MimetypesFileTypeMap());
                System.err.println("Using default mime types definition.");
                Object var7_8 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void editConfiguration(Frame parent) {
        this.editConfiguration(parent, null);
    }

    public void editConfiguration(Frame parent, String[] editProps) {
        ConfigDialog dlg = new ConfigDialog(parent, "jCVS II", this.userPrefs, this.editSpec);
        dlg.setSize(new Dimension(500, 440));
        Point location = AWTUtilities.computeDialogLocation(dlg);
        dlg.setLocation(location.x, location.y);
        if (editProps != null && editProps.length > 0) {
            dlg.editProperties(editProps);
        }
        dlg.setVisible(true);
        if (dlg.getOKClicked()) {
            this.savePreferences();
        }
    }
}

