/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.jcvsii.Config;
import com.ice.jcvsii.ResourceMgr;
import com.ice.jcvsii.ServerDef;
import com.ice.jcvsii.ServersDialog;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class ConnectInfoPanel
extends JPanel
implements ItemListener,
ActionListener {
    private JTextField moduleText;
    private JTextField hostNameText;
    private JTextField repositoryText;
    private JTextField argumentsText;
    private JTextField exportDirText;
    private JRadioButton rshRadio;
    private JRadioButton sshRadio;
    private JRadioButton inetdRadio;
    private JCheckBox passwordCheck;
    private JLabel userNameLbl;
    private JTextField userNameText;
    private JLabel passwordLbl;
    private JPasswordField passwordText;

    public ConnectInfoPanel(String operation) {
        this.establishContents(operation);
    }

    public void loadPreferences(String panName) {
        UserPrefs prefs = Config.getPreferences();
        String connMethod = prefs.getProperty(panName + "." + "info.method", "");
        if (connMethod != null) {
            this.setServerMode(connMethod.equals("RSH"));
            this.setPServerMode(connMethod.equals("INET"));
            this.setSecureServerMode(connMethod.equals("SSH"));
        }
        this.setUserName(prefs.getProperty(panName + "." + "info.user", ""));
        this.setServer(prefs.getProperty(panName + "." + "info.server", ""));
        this.setModule(prefs.getProperty(panName + "." + "info.module", ""));
        this.setRepository(prefs.getProperty(panName + "." + "info.repository", ""));
        this.setExportDirectory(prefs.getProperty(panName + "." + "info.exportdir", ""));
        this.setArguments(prefs.getProperty(panName + "." + "info.arguments", ""));
    }

    public void savePreferences(String panName) {
        UserPrefs prefs = Config.getPreferences();
        prefs.setProperty(panName + "." + "info.method", this.inetdRadio.isSelected() ? "INET" : (this.sshRadio.isSelected() ? "SSH" : "RSH"));
        prefs.setProperty(panName + "." + "info.user", this.getUserName());
        prefs.setProperty(panName + "." + "info.server", this.getServer());
        prefs.setProperty(panName + "." + "info.module", this.getModule());
        prefs.setProperty(panName + "." + "info.repository", this.getRepository());
        prefs.setProperty(panName + "." + "info.exportdir", this.getExportDirectory());
        prefs.setProperty(panName + "." + "info.arguments", this.getArguments());
    }

    public void setServerMode(boolean state) {
        this.rshRadio.setSelected(state);
        this.sshRadio.setSelected(!state);
        this.inetdRadio.setSelected(!state);
    }

    public void setSecureServerMode(boolean state) {
        this.rshRadio.setSelected(!state);
        this.sshRadio.setSelected(state);
        this.inetdRadio.setSelected(!state);
    }

    public void setPServerMode(boolean state) {
        this.rshRadio.setSelected(!state);
        this.sshRadio.setSelected(!state);
        this.inetdRadio.setSelected(state);
    }

    public void setUsePassword(boolean state) {
        this.passwordCheck.setSelected(state);
    }

    public int getConnectionMethod() {
        return this.inetdRadio.isSelected() ? 1 : (this.sshRadio.isSelected() ? 3 : 2);
    }

    public boolean isPServer() {
        return this.passwordCheck.isSelected() && this.inetdRadio.isSelected();
    }

    public boolean isPasswordSelected() {
        return this.passwordCheck.isSelected();
    }

    public String getUserName() {
        return this.userNameText.getText();
    }

    public void setUserName(String name) {
        this.userNameText.setText(name);
    }

    public String getPassword() {
        return new String(this.passwordText.getPassword());
    }

    public String getModule() {
        return this.moduleText == null ? "" : this.moduleText.getText();
    }

    public void setModule(String name) {
        if (this.moduleText != null) {
            this.moduleText.setText(name);
        }
    }

    public String getServer() {
        return this.hostNameText.getText();
    }

    public void setServer(String name) {
        this.hostNameText.setText(name);
    }

    public String getRepository() {
        if (this.repositoryText == null) {
            return "";
        }
        String repositorty = this.repositoryText.getText();
        if (repositorty.endsWith("/")) {
            repositorty = repositorty.substring(0, repositorty.length() - 1);
        }
        return repositorty;
    }

    public void setRepository(String name) {
        if (this.repositoryText != null) {
            this.repositoryText.setText(name);
        }
    }

    public String getArguments() {
        return this.argumentsText == null ? "" : this.argumentsText.getText();
    }

    public void setArguments(String args) {
        if (this.argumentsText != null) {
            this.argumentsText.setText(args);
        }
    }

    public String getExportDirectory() {
        return this.exportDirText == null ? "" : this.exportDirText.getText();
    }

    public void setExportDirectory(String dir) {
        if (this.exportDirText != null) {
            this.exportDirText.setText(dir);
        }
    }

    public String getImportDirectory() {
        return this.exportDirText == null ? "" : this.exportDirText.getText();
    }

    public void setImportDirectory(String dir) {
        if (this.exportDirText != null) {
            this.exportDirText.setText(dir);
        }
    }

    public String getLocalDirectory() {
        return this.exportDirText == null ? "" : this.exportDirText.getText();
    }

    public void setLocalDirectory(String dir) {
        if (this.exportDirText != null) {
            this.exportDirText.setText(dir);
        }
    }

    public void requestInitialFocus() {
        this.userNameText.requestFocus();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.userNameText) {
            this.passwordText.requestFocus();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        boolean relay = false;
        ItemSelectable item = event.getItemSelectable();
        if (item == this.inetdRadio) {
            if (this.inetdRadio.isSelected()) {
                this.passwordCheck.setEnabled(true);
                this.passwordCheck.setSelected(true);
                this.userNameLbl.setEnabled(true);
                this.userNameText.setEnabled(true);
                this.passwordText.setEnabled(true);
                this.userNameText.requestFocus();
            }
            relay = true;
        } else if (item == this.rshRadio) {
            if (this.rshRadio.isSelected()) {
                this.passwordCheck.setSelected(false);
                this.passwordCheck.setEnabled(false);
                this.passwordText.setEnabled(false);
                this.userNameLbl.setEnabled(true);
                this.userNameText.setEnabled(true);
                this.userNameText.requestFocus();
            }
            relay = true;
        } else if (item == this.sshRadio) {
            if (this.sshRadio.isSelected()) {
                this.passwordCheck.setSelected(true);
                this.passwordCheck.setEnabled(true);
                this.passwordText.setEnabled(true);
                this.userNameLbl.setEnabled(true);
                this.userNameText.setEnabled(true);
                this.userNameText.requestFocus();
            }
            relay = true;
        } else if (item == this.passwordCheck) {
            if (this.passwordCheck.isSelected()) {
                this.userNameLbl.setEnabled(true);
                this.userNameText.setEnabled(true);
                this.passwordText.setEnabled(true);
                this.userNameText.requestFocus();
            } else {
                this.userNameLbl.setEnabled(false);
                this.userNameText.setEnabled(false);
                this.passwordText.setEnabled(false);
            }
            relay = true;
        }
        if (relay) {
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    private void establishContents(String operation) {
        MyLabel lbl;
        int row = 0;
        this.setLayout(new GridBagLayout());
        ResourceMgr rmgr = ResourceMgr.getInstance();
        JPanel fldPan = new JPanel();
        fldPan.setLayout(new GridBagLayout());
        if (!operation.equals("test") && !operation.equals("initrep")) {
            ConnectInfoPanel connectInfoPanel = this;
            connectInfoPanel.getClass();
            lbl = connectInfoPanel.new MyLabel(rmgr.getUIString("name.for.cvsmodule"));
            AWTUtilities.constrain(fldPan, lbl, 0, 17, 0, row, 1, 1, 0.0, 0.0);
            this.moduleText = new JTextField();
            AWTUtilities.constrain(fldPan, this.moduleText, 2, 10, 1, row++, 1, 1, 1.0, 0.0);
        }
        ConnectInfoPanel connectInfoPanel = this;
        connectInfoPanel.getClass();
        lbl = connectInfoPanel.new MyLabel(rmgr.getUIString("name.for.cvsserver"));
        AWTUtilities.constrain(fldPan, lbl, 0, 17, 0, row, 1, 1, 0.0, 0.0);
        this.hostNameText = new JTextField();
        AWTUtilities.constrain(fldPan, this.hostNameText, 2, 10, 1, row++, 1, 1, 1.0, 0.0);
        ConnectInfoPanel connectInfoPanel2 = this;
        connectInfoPanel2.getClass();
        lbl = connectInfoPanel2.new MyLabel(rmgr.getUIString("name.for.cvsrepos"));
        AWTUtilities.constrain(fldPan, lbl, 0, 17, 0, row, 1, 1, 0.0, 0.0);
        this.repositoryText = new JTextField();
        AWTUtilities.constrain(fldPan, this.repositoryText, 2, 10, 1, row++, 1, 1, 1.0, 0.0);
        if (operation.equals("export") || operation.equals("import") || operation.equals("checkout")) {
            if (operation.equals("export")) {
                ConnectInfoPanel connectInfoPanel3 = this;
                connectInfoPanel3.getClass();
                lbl = connectInfoPanel3.new MyLabel(rmgr.getUIString("name.for.exportdir"));
            } else if (operation.equals("import")) {
                ConnectInfoPanel connectInfoPanel4 = this;
                connectInfoPanel4.getClass();
                lbl = connectInfoPanel4.new MyLabel(rmgr.getUIString("name.for.importdir"));
            } else if (operation.equals("checkout")) {
                ConnectInfoPanel connectInfoPanel5 = this;
                connectInfoPanel5.getClass();
                lbl = connectInfoPanel5.new MyLabel(rmgr.getUIString("name.for.checkoutdir"));
            }
            AWTUtilities.constrain(fldPan, lbl, 0, 17, 0, row, 1, 1, 0.0, 0.0);
            this.exportDirText = new JTextField();
            AWTUtilities.constrain(fldPan, this.exportDirText, 2, 10, 1, row++, 1, 1, 1.0, 0.0);
        }
        if (operation.equals("export") || operation.equals("checkout") || operation.equals("import")) {
            ConnectInfoPanel connectInfoPanel6 = this;
            connectInfoPanel6.getClass();
            lbl = connectInfoPanel6.new MyLabel(rmgr.getUIString("name.for.arguments"));
            AWTUtilities.constrain(fldPan, lbl, 0, 17, 0, row, 1, 1, 0.0, 0.0);
            this.argumentsText = new JTextField();
            AWTUtilities.constrain(fldPan, this.argumentsText, 2, 10, 1, row++, 1, 1, 1.0, 0.0);
        }
        JButton defBtn = new JButton(rmgr.getUIString("name.for.servers.button"));
        defBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServersDialog dlg = new ServersDialog((Frame)ConnectInfoPanel.this.getTopLevelAncestor(), Config.getPreferences(), ConnectInfoPanel.this);
                dlg.show();
                ServerDef def = dlg.getServerDefinition();
                if (def != null) {
                    if (ConnectInfoPanel.this.moduleText != null) {
                        ConnectInfoPanel.this.moduleText.setText(def.getModule());
                    }
                    if (ConnectInfoPanel.this.hostNameText != null) {
                        ConnectInfoPanel.this.hostNameText.setText(def.getHostName());
                    }
                    if (ConnectInfoPanel.this.userNameText != null) {
                        ConnectInfoPanel.this.userNameText.setText(def.getUserName());
                    }
                    if (ConnectInfoPanel.this.repositoryText != null) {
                        ConnectInfoPanel.this.repositoryText.setText(def.getRepository());
                    }
                    if (def.getConnectMethod() == 2) {
                        ConnectInfoPanel.this.rshRadio.setSelected(true);
                        ConnectInfoPanel.this.passwordCheck.setSelected(false);
                    } else if (def.getConnectMethod() == 3) {
                        ConnectInfoPanel.this.sshRadio.setSelected(true);
                        ConnectInfoPanel.this.passwordCheck.setSelected(true);
                        ConnectInfoPanel.this.passwordText.requestFocus();
                    } else {
                        ConnectInfoPanel.this.inetdRadio.setSelected(true);
                        ConnectInfoPanel.this.passwordCheck.setSelected(def.isPServer());
                        if (def.isPServer()) {
                            ConnectInfoPanel.this.passwordText.requestFocus();
                        } else if (ConnectInfoPanel.this.moduleText != null) {
                            ConnectInfoPanel.this.moduleText.requestFocus();
                        } else {
                            ConnectInfoPanel.this.repositoryText.requestFocus();
                        }
                    }
                }
            }
        });
        JPanel infoPan = new JPanel();
        infoPan.setLayout(new GridBagLayout());
        JPanel buttonPan = new JPanel();
        buttonPan.setLayout(new GridBagLayout());
        AWTUtilities.constrain(infoPan, buttonPan, 0, 17, 0, 0, 1, 1, 0.0, 0.0);
        JPanel inputPan = new JPanel();
        inputPan.setLayout(new GridBagLayout());
        AWTUtilities.constrain(infoPan, inputPan, 2, 17, 1, 0, 1, 1, 1.0, 0.0);
        row = 0;
        this.rshRadio = new JRadioButton(rmgr.getUIString("name.for.connect.method.server"));
        this.rshRadio.addItemListener(this);
        AWTUtilities.constrain(buttonPan, this.rshRadio, 0, 17, 0, row++, 1, 1, 0.0, 0.0);
        this.sshRadio = new JRadioButton(rmgr.getUIString("name.for.connect.method.sserver"));
        this.sshRadio.addItemListener(this);
        AWTUtilities.constrain(buttonPan, this.sshRadio, 0, 17, 0, row++, 1, 1, 0.0, 0.0);
        this.inetdRadio = new JRadioButton(rmgr.getUIString("name.for.connect.method.pserver"));
        this.inetdRadio.addItemListener(this);
        AWTUtilities.constrain(buttonPan, this.inetdRadio, 0, 17, 0, row, 1, 1, 0.0, 0.0);
        row = 0;
        ConnectInfoPanel connectInfoPanel7 = this;
        connectInfoPanel7.getClass();
        this.userNameLbl = connectInfoPanel7.new MyLabel(rmgr.getUIString("name.for.user.name"));
        this.userNameLbl.setForeground(Color.black);
        AWTUtilities.constrain(inputPan, this.userNameLbl, 0, 13, 0, row, 1, 1, 0.0, 0.0);
        this.userNameText = new JTextField();
        this.userNameText.addActionListener(this);
        AWTUtilities.constrain(inputPan, this.userNameText, 2, 17, 1, row++, 1, 1, 1.0, 0.0);
        this.passwordCheck = new JCheckBox(rmgr.getUIString("name.for.user.pass"));
        this.passwordCheck.addItemListener(this);
        AWTUtilities.constrain(inputPan, this.passwordCheck, 0, 13, 0, row, 1, 1, 0.0, 0.0);
        this.passwordText = new JPasswordField();
        this.passwordText.setEchoChar('*');
        AWTUtilities.constrain(inputPan, this.passwordText, 2, 17, 1, row++, 1, 1, 1.0, 0.0);
        ButtonGroup btnGrp = new ButtonGroup();
        btnGrp.add(this.rshRadio);
        btnGrp.add(this.sshRadio);
        btnGrp.add(this.inetdRadio);
        row = 0;
        JPanel topPan = new JPanel();
        topPan.setLayout(new GridBagLayout());
        defBtn.setMargin(new Insets(4, 8, 4, 8));
        AWTUtilities.constrain(topPan, defBtn, 0, 10, 0, row, 1, 1, 0.0, 0.0, new Insets(4, 10, 4, 15));
        AWTUtilities.constrain(topPan, new JSeparator(1), 3, 10, 1, row, 1, 1, 0.0, 1.0, new Insets(0, 0, 0, 10));
        AWTUtilities.constrain(topPan, infoPan, 2, 10, 2, row++, 1, 1, 0.7, 0.0);
        row = 0;
        AWTUtilities.constrain(this, topPan, 2, 10, 0, row++, 1, 1, 1.0, 0.0);
        JSeparator sep = new JSeparator(0);
        AWTUtilities.constrain(this, sep, 2, 10, 0, row++, 1, 1, 1.0, 0.0, new Insets(3, 0, 5, 0));
        AWTUtilities.constrain(this, fldPan, 2, 17, 0, row++, 1, 1, 1.0, 0.0);
    }

    private class MyLabel
    extends JLabel {
        public MyLabel(String text) {
            super(text);
            this.setBorder(new EmptyBorder(0, 3, 0, 5));
        }
    }
}

