/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class DiffLayout
implements LayoutManager {
    private int leftWidth = 0;
    private int rightWidth = 0;
    private int preferredWidth = 0;
    private int preferredHeight = 0;
    private boolean sizeUnknown = true;

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    private void setSizes(Container parent) {
        Object compSz = null;
        int nComps = parent.getComponentCount();
        this.leftWidth = 0;
        this.rightWidth = 0;
        this.preferredWidth = 0;
        this.preferredHeight = 0;
        int i = 0;
        while (i < nComps) {
            Component cR;
            int rowH = 0;
            Component cL = parent.getComponent(i);
            if (cL.isVisible()) {
                Dimension dL = cL.getPreferredSize();
                if (dL.height > rowH) {
                    rowH = dL.height;
                }
                if (dL.width > this.leftWidth) {
                    this.leftWidth = dL.width;
                }
            }
            if (i + 1 < nComps && (cR = parent.getComponent(i + 1)).isVisible()) {
                Dimension dR = cR.getPreferredSize();
                if (dR.height > rowH) {
                    rowH = dR.height;
                }
                if (dR.width > this.rightWidth) {
                    this.rightWidth = dR.width;
                }
            }
            this.preferredHeight += rowH;
            i += 2;
        }
        this.preferredWidth = this.leftWidth + this.rightWidth;
    }

    public Dimension preferredLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        this.setSizes(parent);
        Insets insets = parent.getInsets();
        dim.width = this.preferredWidth + insets.left + insets.right;
        dim.height = this.preferredHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dim;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        Dimension parentSz = parent.getSize();
        int maxWidth = parentSz.width - (insets.left + insets.right);
        int maxHeight = parentSz.height - (insets.top + insets.bottom);
        int nComps = parent.getComponentCount();
        boolean previousWidth = false;
        boolean previousHeight = false;
        int x = insets.left;
        int y = insets.top;
        boolean rowh = false;
        boolean start = false;
        int xFudge = 0;
        if (this.sizeUnknown) {
            this.setSizes(parent);
        }
        if (maxWidth != this.preferredWidth) {
            xFudge = (maxWidth - this.preferredWidth) / 2;
        }
        if (maxHeight > this.preferredHeight) {
            // empty if block
        }
        int i = 0;
        while (i < nComps) {
            int rowH = 0;
            x = insets.left;
            Component cL = parent.getComponent(i);
            Component cR = null;
            if (cL.isVisible()) {
                Dimension dL = cL.getPreferredSize();
                if (dL.height > rowH) {
                    rowH = dL.height;
                }
            }
            if (i + 1 < nComps && (cR = parent.getComponent(i + 1)).isVisible()) {
                Dimension dR = cR.getPreferredSize();
                if (dR.height > rowH) {
                    rowH = dR.height;
                }
            }
            if (cL.isVisible()) {
                cL.setBounds(x, y, this.leftWidth + xFudge, rowH);
            }
            if (cR != null && cR.isVisible()) {
                cR.setBounds(x += this.leftWidth + xFudge, y, this.rightWidth + xFudge, rowH);
            }
            y += rowH;
            i += 2;
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

