/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.jcvsii.ResourceMgr;
import com.ice.util.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;

public class HTMLDialog
extends JDialog
implements ActionListener {
    public static final String RCS_ID = "$Id: HTMLDialog.java,v 1.2 1999/04/01 19:41:11 time Exp $";
    public static final String RCS_REV = "$Revision: 1.2 $";
    private JTextArea messageText;

    public HTMLDialog(Frame parent, String title, boolean modal, String html) {
        super(parent, title, modal);
        this.establishDialogContents(html);
        this.setSize(new Dimension(480, 320));
        Point location = parent != null ? AWTUtilities.centerDialogInParent(this, parent) : AWTUtilities.computeDialogLocation(this, 480, 320);
        this.setLocation(location.x, location.y);
    }

    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.compareTo("OK") == 0) {
            this.dispose();
        }
    }

    public void establishDialogContents(String html) {
        JEditorPane pane = null;
        EditorKit editor = null;
        Document doc = null;
        try {
            pane = new JEditorPane();
            pane.setContentType("text/html");
            pane.setEditable(false);
            editor = pane.getEditorKit();
            doc = editor.createDefaultDocument();
            StringReader rdr = new StringReader(html);
            editor.read(rdr, doc, 0);
            pane.setDocument(doc);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            pane = null;
        }
        catch (BadLocationException ex) {
            ex.printStackTrace(System.err);
            pane = null;
        }
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(pane);
        JPanel ctlPan = new JPanel();
        ctlPan.setLayout(new BorderLayout());
        ResourceMgr rmgr = ResourceMgr.getInstance();
        JButton button = new JButton(rmgr.getUIString("name.for.ok"));
        button.addActionListener(this);
        button.setActionCommand("OK");
        ctlPan.add("East", button);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout(0, 8));
        content.setBorder(new EmptyBorder(6, 6, 6, 6));
        content.add("Center", scroller);
        content.add("South", ctlPan);
        this.getContentPane().add(content);
    }
}

