/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.jcvsii.ComponentFrame;
import com.ice.jcvsii.Config;
import com.ice.jcvsii.ExecViewer;
import com.ice.jcvsii.ResourceMgr;
import com.ice.pref.UserPrefs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.activation.CommandInfo;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class JAFUtilities {
    public static void openFile(String entryName, File entryFile, String verb) {
        Object argsel = null;
        Object method = null;
        UserPrefs prefs = Config.getPreferences();
        DataHandler dh = new DataHandler(new FileDataSource(entryFile));
        if (prefs.getBoolean("global.useJAF", false)) {
            Object viewer = JAFUtilities.getMailcapViewer(dh, verb);
            if (viewer != null && viewer instanceof Component) {
                String title = entryFile.getPath();
                if (title == null || title.length() < 1) {
                    title = entryName;
                }
                ComponentFrame frame = new ComponentFrame((Component)viewer, title, dh.getDataSource());
                frame.show();
            }
        } else {
            ExecViewer ev = new ExecViewer();
            ev.exec(verb, dh);
        }
    }

    private static Object getMailcapViewer(DataHandler dh, String verb) {
        Object bean = null;
        String msg = null;
        CommandInfo ci = dh.getCommand(verb);
        if (ci == null) {
            String contentType = dh.getContentType();
            try {
                MimeType mime = new MimeType(contentType);
                contentType = mime.getBaseType();
            }
            catch (MimeTypeParseException ex) {
                // empty catch block
            }
            Object[] fmtArgs = new String[]{verb, contentType};
            msg = ResourceMgr.getInstance().getUIFormat("jaf.getcommand.failed.msg", fmtArgs);
        } else {
            bean = dh.getBean(ci);
            if (bean == null) {
                ExecViewer ev = new ExecViewer();
                try {
                    ev.setCommandContext(verb, dh);
                    bean = ev;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    Object[] fmtArgs = new String[]{verb, ex.getMessage()};
                    msg = ResourceMgr.getInstance().getUIFormat("jaf.execviewer.failed.msg", fmtArgs);
                }
            }
        }
        if (bean == null) {
            JPanel msgPan = new JPanel();
            msgPan.setLayout(new BorderLayout());
            msgPan.setBorder(new EmptyBorder(5, 5, 5, 5));
            JTextArea msgText = new JTextArea(msg);
            msgText.setMargin(new Insets(10, 10, 10, 10));
            msgText.setFont(new Font("Serif", 0, 18));
            msgPan.add("Center", msgText);
            bean = msgPan;
        }
        return bean;
    }
}

