/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSLog;
import com.ice.cvsc.CVSTimestampFormat;
import com.ice.jcvsii.Config;
import com.ice.jcvsii.JCVSSplash;
import com.ice.jcvsii.MainFrame;
import com.ice.jcvsii.ProjectFrameMgr;
import com.ice.jcvsii.ResourceMgr;
import com.ice.pref.UserPrefs;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.UIManager;

public class JCVS {
    public static final String RCS_ID = "$Id: JCVS.java,v 1.9 2003/07/27 04:50:28 time Exp $";
    public static final String RCS_REV = "$Revision: 1.9 $";
    public static final String VERSION_STR = "5.4.2";
    private static JCVS instance;
    private MainFrame mainFrame;

    public static void main(String[] argv) {
        JCVS app;
        instance = app = new JCVS();
        app.instanceMain(argv);
    }

    public static String getVersionString() {
        return VERSION_STR;
    }

    public static MainFrame getMainFrame() {
        return JCVS.instance.mainFrame;
    }

    private void instanceMain(String[] argv) {
        this.processArguments(argv);
        LogManager logMgr = LogManager.getLogManager();
        Enumeration<String> loggers = logMgr.getLoggerNames();
        while (loggers.hasMoreElements()) {
            String nm = loggers.nextElement();
            Logger l = logMgr.getLogger(nm);
            l.setLevel(Level.WARNING);
        }
        DefaultBoundedRangeModel model = new DefaultBoundedRangeModel(0, 0, 0, 100);
        JCVSSplash splash = new JCVSSplash("jCVS II", model);
        splash.show();
        splash.requestFocus();
        JCVS jCVS = this;
        jCVS.getClass();
        jCVS.new Initiator(splash, model).start();
    }

    public void performShutDown() {
        ProjectFrameMgr.closeAllProjects();
        this.mainFrame.savePreferences();
        Config.getInstance().savePreferences();
        System.exit(0);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("QUIT")) {
            this.performShutDown();
        }
    }

    private void processArguments(String[] argv) {
        UserPrefs prefs = Config.getPreferences();
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-osname")) {
                prefs.setOSSuffix(argv[++i]);
            } else if (argv[i].equals("-user")) {
                prefs.setUserSuffix(argv[++i]);
            } else if (argv[i].equals("-home")) {
                prefs.setUserHome(argv[++i]);
            } else {
                System.err.println("   argv[" + i + "] '" + argv[i] + "' ignored.");
            }
            ++i;
        }
    }

    private class Initiator
    extends Thread {
        JCVSSplash splash;
        BoundedRangeModel model;

        public Initiator(JCVSSplash s, BoundedRangeModel m) {
            super("Model");
            this.splash = s;
            this.model = m;
        }

        public void run() {
            try {
                Initiator.sleep(100L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            int proval = 0;
            int procnt = 13;
            int proincr = this.model.getMaximum() / procnt;
            this.model.setValue(proval += proincr);
            Config cfg = Config.getInstance();
            cfg.initializePreferences("jcvsii.");
            UserPrefs prefs = Config.getPreferences();
            this.model.setValue(proval += proincr);
            cfg.loadDefaultPreferences();
            this.model.setValue(proval += proincr);
            cfg.loadUserPreferences();
            this.model.setValue(proval += proincr);
            ResourceMgr.initializeResourceManager("jcvsii");
            this.model.setValue(proval += proincr);
            cfg.loadConfigEditorSpecification();
            this.model.setValue(proval += proincr);
            if (prefs.getBoolean("global.loadDefaultServerDefs", false)) {
                cfg.loadDefaultServerDefinitions();
            }
            this.model.setValue(proval += proincr);
            cfg.loadMimeTypes();
            this.model.setValue(proval += proincr);
            cfg.loadMailCap();
            this.model.setValue(proval += proincr);
            cfg.loadUserServerDefinitions();
            this.model.setValue(proval += proincr);
            cfg.initializeGlobalProperties();
            this.model.setValue(proval += proincr);
            CVSLog.setLogFilename(prefs.getProperty("global.cvsLogFileName", "cvslog.txt"));
            this.model.setValue(proval += proincr);
            CVSLog.checkLogOpen();
            CVSLog.logMsgStderr("jCVS II Version 5.4.2");
            CVSLog.logMsgStderr("Licensed under the GNU General Public License.");
            CVSLog.logMsgStderr("License is available at <http://www.gjt.org/doc/gpl/>");
            CVSLog.logMsgStderr("Property 'os.name' = '" + prefs.getOSSuffix() + "'");
            CVSLog.logMsgStderr("Property 'user.name' = '" + prefs.getUserSuffix() + "'");
            CVSLog.logMsgStderr("Property 'user.home' = '" + prefs.getUserHome() + "'");
            CVSLog.logMsgStderr("Property 'user.dir' = '" + prefs.getCurrentDirectory() + "'");
            String tzPropStr = prefs.getProperty("global.timeStamp.timeZone", null);
            if (tzPropStr != null) {
                CVSTimestampFormat.setTimeZoneID(tzPropStr);
                CVSLog.logMsgStderr("CVS Timestamp timezone set to '" + tzPropStr + "'");
            }
            this.model.setValue(proval += proincr);
            String plafClassName = prefs.getProperty("plaf.lookAndFeel.classname", null);
            if (plafClassName == null || plafClassName.equals("DEFAULT")) {
                plafClassName = UIManager.getSystemLookAndFeelClassName();
            }
            try {
                UIManager.setLookAndFeel(plafClassName);
            }
            catch (Exception ex) {
                // empty catch block
            }
            Rectangle bounds = prefs.getBounds("mainFrame.bounds", new Rectangle(20, 20, 540, 360));
            JCVS.this.mainFrame = new MainFrame(JCVS.this, "jCVS II", bounds);
            this.model.setValue(this.model.getMaximum());
            try {
                Initiator.sleep(500L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            this.splash.dispose();
            JCVS.this.mainFrame.loadPreferences();
            JCVS.this.mainFrame.show();
            JCVS.this.mainFrame.repaint(100L);
            cfg.checkCriticalProperties(JCVS.this.mainFrame);
        }
    }
}

