/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.jcvsii.Config;
import com.ice.jcvsii.ResourceMgr;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ReleaseDetailsDialog
extends JDialog
implements ActionListener {
    private boolean okClicked = false;
    private Vector adds;
    private Vector mods;
    private Vector rems;
    private Vector unks;
    private JTextArea detailsText;
    private JButton okButton;

    public ReleaseDetailsDialog(Frame parent, Vector adds, Vector mods, Vector rems, Vector unks) {
        super(parent, "ReleaseDetails", true);
        this.adds = adds;
        this.mods = mods;
        this.rems = rems;
        this.unks = unks;
        StringBuffer buf = new StringBuffer();
        int i = adds.size() - 1;
        while (i >= 0) {
            buf.append("New  " + adds.elementAt(i) + "\n");
            --i;
        }
        if (adds.size() > 0) {
            buf.append("\n");
        }
        int i2 = mods.size() - 1;
        while (i2 >= 0) {
            buf.append("Mod  " + mods.elementAt(i2) + "\n");
            --i2;
        }
        if (mods.size() > 0) {
            buf.append("\n");
        }
        int i3 = rems.size() - 1;
        while (i3 >= 0) {
            buf.append("Rem  " + rems.elementAt(i3) + "\n");
            --i3;
        }
        if (rems.size() > 0) {
            buf.append("\n");
        }
        int i4 = unks.size() - 1;
        while (i4 >= 0) {
            buf.append("Unk  " + unks.elementAt(i4) + "\n");
            --i4;
        }
        this.establishDialogContents("Details of Project Release", buf.toString());
        this.pack();
        Dimension sz = this.getPreferredSize();
        if (sz.width < 480) {
            sz.width = 480;
        }
        if (sz.height < 420) {
            sz.height = 420;
        }
        this.setSize(sz);
        Point location = AWTUtilities.centerDialogInParent(this, parent);
        this.setLocation(location.x, location.y);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
            }
        });
    }

    public boolean clickedOk() {
        return this.okClicked;
    }

    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.compareTo("OK") == 0) {
            this.okClicked = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ReleaseDetailsDialog.this.dispose();
                }
            });
        } else if (command.compareTo("CANCEL") == 0) {
            this.okClicked = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ReleaseDetailsDialog.this.dispose();
                }
            });
        }
    }

    public void establishDialogContents(String prompt, String details) {
        UserPrefs prefs = Config.getPreferences();
        JLabel promptLabel = new JLabel(prompt);
        promptLabel.setBorder(new EmptyBorder(2, 2, 0, 0));
        promptLabel.setFont(prefs.getFont("releaseDialog.prompt.font", new Font("Dialog", 1, 14)));
        this.detailsText = new JTextArea();
        this.detailsText.setText(details);
        this.detailsText.setFont(prefs.getFont("releaseDialog.details.font", new Font("Monospaced", 0, 12)));
        JScrollPane scroller = new JScrollPane(this.detailsText);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridLayout(1, 2, 20, 20));
        ResourceMgr rmgr = ResourceMgr.getInstance();
        this.okButton = new JButton(rmgr.getUIString("name.for.ok"));
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand("OK");
        controlPanel.add(this.okButton);
        JButton button = new JButton(rmgr.getUIString("name.for.cancel"));
        button.addActionListener(this);
        button.setActionCommand("CANCEL");
        controlPanel.add(button);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        JPanel contPan = new JPanel();
        contPan.setLayout(new BorderLayout(2, 2));
        contPan.setBorder(new EmptyBorder(3, 3, 3, 3));
        contPan.add("North", promptLabel);
        contPan.add("Center", scroller);
        contPan.add("South", controlPanel);
        content.add("Center", contPan);
    }
}

