/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.jcvsii.Config;
import com.ice.jcvsii.ResourceMgr;
import com.ice.jcvsii.WorkBenchDefinition;
import com.ice.jcvsii.WorkBenchTreeNode;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeNode;

public class WorkBenchInfoDialog
extends JDialog
implements ActionListener {
    private String path;
    private String localRoot;
    private JTextField nameField;
    private JTextField displayField;
    private JTextArea descField;
    private boolean isFolder;
    private WorkBenchDefinition wDef = null;
    private WorkBenchTreeNode parentNode;

    public WorkBenchInfoDialog(Frame parFrame, WorkBenchTreeNode parNode, boolean isFolder, String defaultName, String path, String localRoot) {
        super(parFrame, "WorkBench Definition", true);
        this.path = path;
        this.localRoot = localRoot;
        this.parentNode = parNode;
        this.isFolder = isFolder;
        if (defaultName == null) {
            long millis = System.currentTimeMillis();
            defaultName = (isFolder ? "F" : "P") + (millis & 0x7FFFFFL);
        }
        this.establishDialogContents(defaultName);
        this.pack();
        Dimension sz = this.getSize();
        if (sz.width < 480) {
            sz.width = 480;
        }
        if (sz.height < 360) {
            sz.height = 360;
        }
        this.setSize(sz);
        this.setLocation(AWTUtilities.centerDialogInParent(this, parFrame));
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                WorkBenchInfoDialog.this.nameField.requestFocus();
                WorkBenchInfoDialog.this.nameField.selectAll();
            }
        });
    }

    public WorkBenchDefinition getWorkBenchDefinition() {
        return this.wDef;
    }

    private boolean checkName(String name) {
        int i = 0;
        int sz = name.length();
        while (i < sz) {
            char ch = name.charAt(i);
            if (!Character.isLetterOrDigit(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkUniqueness(String name) {
        Enumeration<TreeNode> enumeration = this.parentNode.children();
        while (enumeration.hasMoreElements()) {
            WorkBenchTreeNode node = (WorkBenchTreeNode)enumeration.nextElement();
            if (!node.getDefinition().getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent event) {
        boolean doDispose = false;
        String command = event.getActionCommand();
        if (event.getSource() == this.nameField) {
            this.displayField.requestFocus();
        } else if (event.getSource() == this.displayField) {
            this.descField.requestFocus();
        } else if (command.compareTo("OK") == 0) {
            ResourceMgr rmgr = ResourceMgr.getInstance();
            String name = this.nameField.getText();
            if (!this.checkName(name)) {
                String msg = rmgr.getUIString("wb.infodlg.invalid.name.msg");
                String title = rmgr.getUIString("wb.infodlg.invalid.name.title");
                JOptionPane.showMessageDialog(this, msg, title, 2);
            } else if (!this.checkUniqueness(name)) {
                String msg = rmgr.getUIString("wb.infodlg.unique.name.msg");
                String title = rmgr.getUIString("wb.infodlg.unique.name.title");
                JOptionPane.showMessageDialog(this, msg, title, 2);
            } else {
                String display = this.displayField.getText();
                String desc = this.descField.getText();
                this.wDef = this.isFolder ? new WorkBenchDefinition(name, this.path, display, desc) : new WorkBenchDefinition(name, this.path, display, desc, this.localRoot);
                doDispose = true;
            }
        } else if (command.compareTo("CANCEL") == 0) {
            this.wDef = null;
            doDispose = true;
        }
        if (doDispose) {
            this.dispose();
        }
    }

    public void establishDialogContents(String toke) {
        UserPrefs prefs = Config.getPreferences();
        ResourceMgr rmgr = ResourceMgr.getInstance();
        JPanel infoPan = new JPanel();
        infoPan.setLayout(new GridBagLayout());
        infoPan.setBorder(new EmptyBorder(4, 4, 4, 4));
        Font lblFont = prefs.getFont("workBenchInfoDialog.label.font", new Font("Dialog", 1, 14));
        int row = 0;
        JLabel label = new JLabel(rmgr.getUIString("wb.infodlg.brief.name"));
        label.setFont(lblFont);
        AWTUtilities.constrain(infoPan, label, 0, 17, 0, row++, 1, 1, 0.0, 0.0);
        this.nameField = new JTextField();
        this.nameField.setEditable(true);
        this.nameField.setText(toke == null ? "" : toke);
        this.nameField.addActionListener(this);
        AWTUtilities.constrain(infoPan, this.nameField, 2, 17, 0, row++, 1, 1, 1.0, 0.0);
        label = new JLabel(rmgr.getUIString("wb.infodlg.display.name"));
        label.setFont(lblFont);
        AWTUtilities.constrain(infoPan, label, 0, 17, 0, row++, 1, 1, 0.0, 0.0);
        this.displayField = new JTextField();
        this.displayField.setEditable(true);
        this.displayField.setText(toke == null ? "" : toke);
        this.displayField.addActionListener(this);
        AWTUtilities.constrain(infoPan, this.displayField, 2, 17, 0, row++, 1, 1, 1.0, 0.0);
        label = new JLabel(rmgr.getUIString("wb.infodlg.desc.name"));
        label.setFont(lblFont);
        AWTUtilities.constrain(infoPan, label, 0, 17, 0, row++, 2, 1, 0.0, 0.0);
        this.descField = new JTextArea();
        this.descField.setEditable(true);
        this.descField.setLineWrap(true);
        this.descField.setWrapStyleWord(true);
        this.descField.setBorder(new BevelBorder(1));
        AWTUtilities.constrain(infoPan, this.descField, 1, 10, 0, row++, 2, 1, 1.0, 1.0);
        JPanel btnPan = new JPanel();
        btnPan.setLayout(new GridLayout(1, 2, 5, 5));
        JButton okBtn = new JButton(rmgr.getUIString("name.for.ok"));
        okBtn.addActionListener(this);
        okBtn.setActionCommand("OK");
        btnPan.add(okBtn);
        JButton canBtn = new JButton(rmgr.getUIString("name.for.cancel"));
        canBtn.addActionListener(this);
        canBtn.setActionCommand("CANCEL");
        btnPan.add(canBtn);
        JPanel eastPan = new JPanel();
        eastPan.setLayout(new BorderLayout());
        eastPan.setBorder(new EmptyBorder(5, 5, 5, 5));
        eastPan.add("East", btnPan);
        JPanel ctlPan = new JPanel();
        ctlPan.setLayout(new BorderLayout());
        ctlPan.add("North", new JSeparator(0));
        ctlPan.add("Center", eastPan);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add("Center", infoPan);
        content.add("South", ctlPan);
    }
}

