/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ICETracer {
    public static final String RCS_ID = "$Id: ICETracer.java,v 1.4 1998/04/29 16:30:13 time Exp $";
    public static final String RCS_REV = "$Revision: 1.4 $";
    private static PrintWriter out = null;
    private static boolean state = false;
    private static boolean ifOverOn = true;
    private static int traceState = 0;
    private static boolean outIsSystem = false;
    private static boolean echoAccum = false;
    private static StringBuffer outBuffer = null;

    public static void setTraceState(boolean state) {
        ICETracer.state = state;
    }

    public static void setEchoAccumulation(boolean state) {
        echoAccum = state;
    }

    public static void accumulateInBuffer(StringBuffer buffer) {
        outBuffer = buffer;
    }

    public static void turnOffAccumulation() {
        outBuffer = null;
    }

    public static StringBuffer getAccumulationBuffer() {
        return outBuffer;
    }

    public static void println(String line) {
        if (line == null) {
            return;
        }
        if (outBuffer != null) {
            outBuffer.append(line);
            outBuffer.append("\n");
            if (!echoAccum) {
                return;
            }
        }
        if (out != null) {
            out.println(line);
        } else {
            System.err.println(line);
        }
    }

    public static void trace(String line) {
        if (line == null) {
            return;
        }
        if (state) {
            ICETracer.println(line);
        }
    }

    public static void traceIf(boolean flag, String line) {
        if (!flag || line == null) {
            return;
        }
        if (ifOverOn) {
            ICETracer.println(line);
        }
    }

    public static void traceWithStack(String line) {
        if (line == null) {
            return;
        }
        Throwable thrower = new Throwable(line);
        if (state) {
            ICETracer.println(line);
        }
        if (out == null) {
            thrower.printStackTrace(System.err);
        } else {
            thrower.printStackTrace(out);
        }
    }

    public static String getStackLines(Throwable thrower) {
        StringWriter sWrtr = new StringWriter();
        PrintWriter pWrtr = new PrintWriter(sWrtr);
        thrower.printStackTrace(pWrtr);
        return sWrtr.toString();
    }

    public static String getStackLines(Throwable thrower, int maxLines) {
        if (maxLines == 0) {
            return ICETracer.getStackLines(thrower);
        }
        StringWriter sWrtr = new StringWriter();
        PrintWriter pWrtr = new PrintWriter(sWrtr);
        thrower.printStackTrace(pWrtr);
        String trcStr = sWrtr.getBuffer().toString();
        String sep = System.getProperty("line.separator", "\n");
        int offset = 0;
        int index = trcStr.length();
        int ln = 0;
        while (ln < maxLines) {
            int idx = trcStr.indexOf(sep, offset);
            if (idx == -1) break;
            index = idx;
            offset = idx + 1;
            ++ln;
        }
        return trcStr.substring(0, index);
    }

    public static void traceWithStack(int maxPrintLines, String line) {
        if (line == null || maxPrintLines < 1) {
            return;
        }
        Throwable thrower = new Throwable(line);
        if (state) {
            ICETracer.println(line);
        }
        String outStr = ICETracer.getStackLines(thrower, maxPrintLines);
        if (out == null) {
            System.err.println(outStr);
        } else {
            out.println(outStr);
        }
    }

    public static void traceWithStack(Throwable thrower, String line) {
        if (thrower == null && line == null) {
            return;
        }
        if (line != null) {
            ICETracer.println(line);
        }
        String outStr = ICETracer.getStackLines(thrower, 0);
        if (out == null) {
            System.err.println(outStr);
        } else {
            out.println(outStr);
        }
    }

    public static void traceWithStack(Throwable thrower, int lines, String line) {
        if (thrower == null && line == null) {
            return;
        }
        if (line != null) {
            ICETracer.println(line);
        }
        String outStr = ICETracer.getStackLines(thrower, lines);
        if (out == null) {
            System.err.println(outStr);
        } else {
            out.println(outStr);
        }
    }

    private static void checkClose() {
        if (out != null && !outIsSystem) {
            out.close();
            out = null;
            outIsSystem = false;
        }
    }

    public static void setWriter(PrintWriter newOut) {
        ICETracer.checkClose();
        out = newOut;
        outIsSystem = false;
        outBuffer = null;
    }

    public static void setWriterToStdout() {
        PrintWriter newOut = new PrintWriter(new OutputStreamWriter(System.out));
        if (newOut != null) {
            ICETracer.checkClose();
            out = newOut;
            outIsSystem = true;
            outBuffer = null;
        }
    }

    public static void setWriterToStderr() {
        PrintWriter newOut = new PrintWriter(new OutputStreamWriter(System.err));
        if (newOut != null) {
            ICETracer.checkClose();
            out = newOut;
            outIsSystem = true;
            outBuffer = null;
        }
    }
}

