/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceManager {
    public static final String RCS_ID = "$Id: ResourceManager.java,v 1.1 2000/01/28 02:24:45 time Exp $";
    public static final String RCS_REV = "$Revision: 1.1 $";
    private static Hashtable bundles;
    private boolean debug;
    private String name;
    private ResourceBundle rsrc;

    public static void initialize() {
        bundles = new Hashtable();
    }

    public static void load(String id, String name) {
        try {
            ResourceBundle rsrc = ResourceBundle.getBundle(name);
            ResourceManager rMgr = new ResourceManager(name, rsrc);
            bundles.put(id, rMgr);
        }
        catch (MissingResourceException ex) {
            ex.printStackTrace();
        }
    }

    public static ResourceManager get(String id) {
        return (ResourceManager)bundles.get(id);
    }

    public static ResourceManager put(String id, ResourceManager rMgr) {
        return bundles.put(id, rMgr);
    }

    private ResourceManager() {
    }

    public ResourceManager(String name, ResourceBundle rsrc) throws MissingResourceException {
        this.name = name;
        this.rsrc = rsrc;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getString(String key) {
        return this.rsrc.getString(key);
    }

    public String getFormat(String key, Object[] args) {
        return MessageFormat.format(this.rsrc.getString(key), args);
    }
}

