/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtilities {
    public static String[] vectorToStringArray(Vector sV) {
        int sz = sV.size();
        String[] result = new String[sz];
        int i = 0;
        while (i < sz) {
            result[i] = (String)sV.elementAt(i);
            ++i;
        }
        return result;
    }

    public static String[] splitString(String splitStr, String delim) {
        StringTokenizer toker = new StringTokenizer(splitStr, delim);
        int count = toker.countTokens();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            try {
                result[i] = toker.nextToken();
            }
            catch (NoSuchElementException ex) {
                result = null;
                break;
            }
            ++i;
        }
        return result;
    }

    public static Vector vectorString(String splitStr, String delim) {
        boolean tokeWasDelim = false;
        Vector<String> result = new Vector<String>();
        StringTokenizer toker = new StringTokenizer(splitStr, delim, true);
        int count = toker.countTokens();
        int i = 0;
        while (i < count) {
            String toke;
            try {
                toke = toker.nextToken();
            }
            catch (NoSuchElementException ex) {
                break;
            }
            if (toke.equals(delim)) {
                if (tokeWasDelim) {
                    result.addElement("");
                }
                tokeWasDelim = true;
            } else {
                result.addElement(toke);
                tokeWasDelim = false;
            }
            ++i;
        }
        if (tokeWasDelim) {
            result.addElement("");
        }
        return result;
    }

    public static String join(String[] strings, String sep) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (strings != null && i < strings.length) {
            if (i > 0) {
                result.append(sep);
            }
            result.append(strings[i]);
            ++i;
        }
        return result.toString();
    }

    public static String[] argumentSubstitution(String[] args, Hashtable vars) {
        StringBuffer argBuf = new StringBuffer();
        String[] result = new String[args.length];
        int aIdx = 0;
        while (aIdx < args.length) {
            String argStr = args[aIdx];
            int index = argStr.indexOf(36);
            result[aIdx] = index < 0 ? argStr : StringUtilities.stringSubstitution(argStr, vars);
            ++aIdx;
        }
        return result;
    }

    public static String stringSubstitution(String argStr, Hashtable vars) {
        StringBuffer argBuf = new StringBuffer();
        int cIdx = 0;
        block3: while (cIdx < argStr.length()) {
            char ch = argStr.charAt(cIdx);
            switch (ch) {
                case '$': {
                    String value;
                    StringBuffer nameBuf = new StringBuffer();
                    ++cIdx;
                    while (cIdx < argStr.length()) {
                        ch = argStr.charAt(cIdx);
                        if (ch != '_' && !Character.isLetterOrDigit(ch)) break;
                        nameBuf.append(ch);
                        ++cIdx;
                    }
                    if (nameBuf.length() <= 0 || (value = (String)vars.get(nameBuf.toString())) == null) continue block3;
                    argBuf.append(value);
                    break;
                }
                default: {
                    argBuf.append(ch);
                    ++cIdx;
                }
            }
        }
        return argBuf.toString();
    }

    public static String[] parseArgumentString(String argStr) {
        Object[] result = null;
        Vector vector = StringUtilities.parseArgumentVector(argStr);
        if (vector != null && vector.size() > 0) {
            result = new String[vector.size()];
            vector.copyInto(result);
        }
        return result;
    }

    public static Vector parseArgumentVector(String argStr) {
        Vector<String> result = new Vector<String>();
        StringBuffer argBuf = new StringBuffer();
        boolean backSlash = false;
        boolean matchSglQuote = false;
        boolean matchDblQuote = false;
        int cIdx = 0;
        while (cIdx < argStr.length()) {
            char ch = argStr.charAt(cIdx);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (backSlash) {
                        argBuf.append(ch);
                        backSlash = false;
                        break;
                    }
                    if (matchSglQuote || matchDblQuote) {
                        argBuf.append(ch);
                        break;
                    }
                    if (argBuf.length() <= 0) break;
                    result.addElement(argBuf.toString());
                    argBuf.setLength(0);
                    break;
                }
                case '\\': {
                    if (backSlash) {
                        argBuf.append("\\");
                    }
                    backSlash = !backSlash;
                    break;
                }
                case '\'': {
                    if (backSlash) {
                        argBuf.append("'");
                        backSlash = false;
                        break;
                    }
                    if (matchSglQuote) {
                        result.addElement(argBuf.toString());
                        argBuf.setLength(0);
                        matchSglQuote = false;
                        break;
                    }
                    if (matchDblQuote) break;
                    matchSglQuote = true;
                    break;
                }
                case '\"': {
                    if (backSlash) {
                        argBuf.append("\"");
                        backSlash = false;
                        break;
                    }
                    if (matchDblQuote) {
                        result.addElement(argBuf.toString());
                        argBuf.setLength(0);
                        matchDblQuote = false;
                        break;
                    }
                    if (matchSglQuote) break;
                    matchDblQuote = true;
                    break;
                }
                default: {
                    if (backSlash) {
                        switch (ch) {
                            case 'b': {
                                argBuf.append('\b');
                                break;
                            }
                            case 'f': {
                                argBuf.append('\f');
                                break;
                            }
                            case 'n': {
                                argBuf.append('\n');
                                break;
                            }
                            case 'r': {
                                argBuf.append('\r');
                                break;
                            }
                            case 't': {
                                argBuf.append('\t');
                                break;
                            }
                            default: {
                                char ch2 = argStr.charAt(cIdx + 1);
                                char ch3 = argStr.charAt(cIdx + 2);
                                if (ch >= '0' && ch <= '7' && ch2 >= '0' && ch2 <= '7' && ch3 >= '0' && ch3 <= '7') {
                                    int octal = (ch - 48) * 64 + (ch2 - 48) * 8 + (ch3 - 48);
                                    argBuf.append((char)octal);
                                    cIdx += 2;
                                    break;
                                }
                                if (ch == '0') {
                                    argBuf.append('\u0000');
                                    break;
                                }
                                argBuf.append(ch);
                                break;
                            }
                        }
                    } else {
                        argBuf.append(ch);
                    }
                    backSlash = false;
                }
            }
            ++cIdx;
        }
        if (argBuf.length() > 0) {
            result.addElement(argBuf.toString());
        }
        return result;
    }
}

