/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcearcade.jinvaders;

import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;

public class SoundClip {
    private AudioFormat af;
    private int size;
    private byte[] audio;
    private DataLine.Info info;
    private boolean loaded;
    private String name;

    public SoundClip(URL uRL) {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(uRL);
            this.af = audioInputStream.getFormat();
            this.size = (int)((long)this.af.getFrameSize() * audioInputStream.getFrameLength());
            this.audio = new byte[this.size];
            audioInputStream.read(this.audio, 0, this.size);
            this.info = new DataLine.Info(Clip.class, this.af, this.size);
            this.name = uRL.getFile();
            this.loaded = true;
        }
        catch (Exception exception) {
            System.err.println("Unable to load " + this.name);
        }
    }

    public void play() {
        if (this.loaded) {
            try {
                Clip clip = (Clip)AudioSystem.getLine(this.info);
                clip.open(this.af, this.audio, 0, this.size);
                clip.start();
            }
            catch (Exception exception) {
                System.err.println(exception.getLocalizedMessage() + " " + this.name);
            }
        }
    }
}

