/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : HiScore.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.io.File;
import java.io.FileInputStream;
import java.io.DataInputStream;
import java.io.RandomAccessFile;
import java.io.FileNotFoundException;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.String;
import java.util.Random;

class HiScore
{

  static final int MAX_NAME_LEN   =  64;
  static final int ENCRYPT_SEED   = 123;

/******************************** GLOBAL DATA ********************************/

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : main
 * DESCRIPTION	  :
 *****************************************************************************/
  public static void main(String args[])
  {
    int i, l, score, stage, n, len;
    byte tmp, buffer[];
    String s;
    StringBuffer line;
    FileInputStream fis;
    File ifp;
    DataInputStream dis;
    Random rand;

    if(args.length == 0)
      {
	System.err.println("Syntax:  HiScores filename");
	System.exit(1);
      }

    len = 4 + 4 + (MAX_NAME_LEN << 1);
    buffer = new byte[len];
    line = new StringBuffer(80);
    fis = null;

    ifp = new File(args[0]);
    if(ifp.exists() == false)
      {
	System.err.println("unable to find HiScore file \"" + args[0] +
			   "\"");
	System.exit(1);
      }

    try
      {
	fis = new FileInputStream(ifp);
	dis = new DataInputStream(fis);
	rand = new Random(ENCRYPT_SEED);
	while(true)
	  {
	    if(dis.read(buffer) == -1)
	      break;
	    for(i=0; i<len; i++)
	      {
		tmp = (byte) (rand.nextInt() & 0xff);
		buffer[i] ^= tmp;
	      }
	    score = ((((int) buffer[0]) & 0xff) << 24) +
		     ((((int) buffer[1]) & 0xff) << 16) +
		      ((((int) buffer[2]) & 0xff) << 8) +
		       (((int) buffer[3]) & 0xff);
	    line.setLength(0);
	    n = 0;
	    s = String.valueOf(score);
	    for(i=9; i>s.length(); i--)
	      {
		line.insert(n, ' ');
		n++;
	      }
	    line.insert(n, s);
	    n = line.length();
	    for(i=0; i<4; i++)
	      {
		line.insert(n, ' ');
		n++;
	      }
	    stage = ((((int) buffer[4]) & 0xff) << 24) +
		     ((((int) buffer[5]) & 0xff) << 16) +
		      ((((int) buffer[6]) & 0xff) << 8) +
		       (((int) buffer[7]) & 0xff);
	    s = String.valueOf(stage);
	    for(i=2; i>s.length(); i--)
	      {
		line.insert(n, ' ');
		n++;
	      }
	    line.insert(n, s);
	    n = line.length();
	    for(i=0; i<4; i++)
	      {
		line.insert(n, ' ');
		n++;
	      }
	    for(i=8; i<len; i++)
	      if(buffer[i] == 0)
		break;
	    l = i - 8;
	    s = new String(buffer, 8, l,
			   System.getProperty("file.encoding"));
	    line.insert(n, s);
	    System.out.println(line.toString());
	  }
      }

    catch(FileNotFoundException e1)
      {
	 System.err.println("Unable to find score file \"" +
			    ifp.getAbsolutePath() + "\"");
      }

    catch(EOFException e3)
      {
      }

    catch(IOException e2)
      {
	 System.err.println("Error reading score file \"" +
			    ifp.getAbsolutePath() + "\"");
      }

    finally
      {
	if(fis != null)
	  {
	    try
	      {
		fis.close();
	      }
	    catch(IOException e2)
	      {
		System.err.println("Error closing score file \"" +
				   ifp.getAbsolutePath() + "\"");
	      }
	  }
      }


  }

}  /* END OF CLASS : HiScore */


/* END OF FILE : HiScore.java */

