/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : ScoreWin.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class ScoreWin extends Frame
{

  static final int NAME_COL  = 0;
  static final int SCORE_COL = 1;
  static final int STAGE_COL = 2;

  static String NameHeading;
  static String ScoreHeading;
  static String StageHeading;
  static String NoScoreMessage;

/******************************** GLOBAL DATA ********************************/

  MyScrollPane pane;
  MyCanvas canvas;
  String Names[];
  String Scores[];
  String Stages[];
  String Headings[];
  String title;
  String no_scores;
  int x_col[];
  boolean isIcon;
  boolean isInit;

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : ScoreWin
 * DESCRIPTION	  :
 *****************************************************************************/
  ScoreWin(String title)
  {

    super();
    Headings = new String[3];
    x_col = new int[3];
    Headings[NAME_COL] = new String(NameHeading);
    Headings[SCORE_COL] = new String(ScoreHeading);
    Headings[STAGE_COL] = new String(StageHeading);
    no_scores = new String(NoScoreMessage);
    this.title = new String(title);
    clear_values();

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : clear_values
 * DESCRIPTION	  :
 *****************************************************************************/
  private synchronized void clear_values()
  {

    pane = null;
    canvas = null;
    Names = null;
    Scores = null;
    Stages = null;
    x_col[NAME_COL] = x_col[SCORE_COL] = x_col[STAGE_COL] = 0;
    isIcon = false;
    isInit = false;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : init
 * DESCRIPTION	  :
 *****************************************************************************/
  void init()
  {

    pane = new MyScrollPane();
    add(pane, "Center");
    canvas = new MyCanvas();
    pane.add(canvas, "Center");
    pack();
    isIcon = false;
    isInit = true;
    setTitle(title);

    addWindowListener(new WindowAdapter()
      {
	public void windowClosing(WindowEvent event)
	{
	  close();
	}
	public void windowDeIconified(WindowEvent event)
	{
	  isIcon = false;
	}
	public void windowIconified(WindowEvent event)
	{
	  isIcon = true;
	}
      });
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : displayScores
 * DESCRIPTION	  :
 *****************************************************************************/
  synchronized void displayScores(String names[], int scores[], int stages[])
  {
    int i, n;
    Dimension d, maxd;
    Point p;
    Toolkit tk;


    isInit = false;
    if(pane == null)
      init();

    if((names != null) && (scores != null) && (stages != null))
      {
	/* get window ornament dimensions */
	maxd = super.getPreferredSize();
	d = pane.getPreferredSize();
	maxd.width -= d.width;
	maxd.height -= d.height;

	n = names.length;
	Names = new String[n];
	Scores = new String[n];
	Stages = new String[n];

	for(i=0; i<n; i++)
	  {
	    Names[i] = new String(names[i]);
	    Scores[i] = String.valueOf(scores[i]);
	    Stages[i] = String.valueOf(stages[i]);
	  }

	getMaxLengths();
	validate();
	d = pane.getPreferredSize();
	maxd.width += d.width;
	maxd.height += d.height;
	setSize(maxd);
      }

    if(isIcon == true)
      return;

    if(isInit == true)
      {
	pack();
	tk = getToolkit();
	d = getSize();
	maxd = tk.getScreenSize();
	maxd.width >>>= 1;
	p = new Point();
	p.x = maxd.width + ((maxd.width - d.width) >>> 1);
	p.y = (maxd.height - d.height) >>> 1;
	setLocation(p);
      }


    if(isVisible() == false)
      setVisible(true);

    /* update does not work -- use repaint */
    canvas.repaint();

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getMaxLengths
 * DESCRIPTION	  :
 *****************************************************************************/
  private synchronized void getMaxLengths()
  {
    int i, l;
    int maxlen[];
    Font f, bf;
    FontMetrics fm, bfm;


    if((Names == null) || (Scores == null) || (Stages == null))
      return;

    maxlen = new int[3];
    f = canvas.getFont();
    bf = new Font(f.getName(), f.getStyle()+Font.BOLD, f.getSize());
    fm = canvas.getFontMetrics(f);
    bfm = canvas.getFontMetrics(bf);

    maxlen[NAME_COL] = bfm.stringWidth(Headings[NAME_COL]);
    for(i=0; i<Names.length; i++)
      {
	if((l = fm.stringWidth(Names[i])) > maxlen[NAME_COL])
	  maxlen[NAME_COL] = l;
      }

    maxlen[SCORE_COL] = bfm.stringWidth(Headings[SCORE_COL]);
    for(i=0; i<Scores.length; i++)
      {
	if((l = fm.stringWidth(Scores[i])) > maxlen[SCORE_COL])
	  maxlen[SCORE_COL] = l;
      }

    maxlen[STAGE_COL] = bfm.stringWidth(Headings[STAGE_COL]);
    for(i=0; i<Stages.length; i++)
      {
	if((l = fm.stringWidth(Stages[i])) > maxlen[STAGE_COL])
	  maxlen[STAGE_COL] = l;
      }

    l = Math.max(fm.getMaxAdvance(), bfm.getMaxAdvance());
    /* left justified */
    x_col[NAME_COL] = l;
    /* right justified */
    x_col[SCORE_COL] = (l * 3) + maxlen[NAME_COL] + maxlen[SCORE_COL];
    x_col[STAGE_COL] = x_col[SCORE_COL] + (l << 1) + maxlen[STAGE_COL];

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : setFont
 * DESCRIPTION	  :
 *****************************************************************************/
  public synchronized void setFont(Font f)
  {

    pane.setFont(f);
    canvas.setFont(f);
    getMaxLengths();
    repaint();

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : close
 * DESCRIPTION	  :
 *****************************************************************************/
  void close()
  {

    if(super.isShowing() == true)
      super.setVisible(false);

    if(pane == null)
      return;

    super.dispose();
    clear_values();

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : static
 * DESCRIPTION	  :
 *****************************************************************************/
  static
  {
    ResourceBundle bundle;


    bundle = JKobo.Context.getResourceBundle();

    try {
      NameHeading = bundle.getString("ScoreWinNameHeading.message");
    }
    catch(MissingResourceException e) {
      NameHeading = "Name";
    }
    try {
      ScoreHeading = bundle.getString("ScoreWinScoreHeading.message");
    }
    catch(MissingResourceException e) {
      ScoreHeading = "High Score";
    }
    try {
      StageHeading = bundle.getString("ScoreWinStageHeading.message");
    }
    catch(MissingResourceException e) {
      StageHeading = "Last Stage";
    }
    try {
      NoScoreMessage = bundle.getString("ScoreWinNoScoreFile.message");
    }
    catch(MissingResourceException e) {
      NoScoreMessage = "No High Scores";
    }

  }

  class MyScrollPane extends ScrollPane
  {
/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getPreferredSize
 * DESCRIPTION	  :
 *****************************************************************************/
    public Dimension getPreferredSize()
    {
      int w, h;
      Dimension d, maxd;
      Toolkit tk;


      d = ScoreWin.this.canvas.getPreferredSize();
      tk = getToolkit();

      maxd = tk.getScreenSize();
      maxd.width >>>= 1;
      maxd.height >>>= 1;

      w = Math.min(d.width, maxd.width);
      h = Math.min(d.height, maxd.height);

      return(new Dimension(w, h));

    }

  }  /* END OF CLASS : MyScrollPane */

  class MyCanvas extends Canvas
  {
/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : paint
 * DESCRIPTION	  :
 *****************************************************************************/
    public void paint(Graphics g)
    {
      int i, y;
      Rectangle r;
      Font f, bf;
      FontMetrics fm, bfm;

      if(isIcon == true)
	return;

      f = getFont();
      bf = new Font(f.getName(), f.getStyle()+Font.BOLD, f.getSize());
      fm = getFontMetrics(f);
      bfm = getFontMetrics(bf);
      r = g.getClipBounds();
      g.clearRect(r.x, r.y, r.width, r.height);

      if((Names == null) || (Scores == null) || (Stages == null))
	{
	  i = r.x + (r.width >>> 1) -
	       (fm.stringWidth(no_scores) >>> 1);
	  y = r.y + (r.height >>> 1) - (fm.getHeight() >>> 1) +
	       fm.getMaxAscent();
	  g.drawString(no_scores, i, y);
	  return;
	}

      y = r.y + fm.getLeading() + bfm.getMaxAscent();
      g.setFont(bf);
      g.drawString(Headings[NAME_COL], r.x + x_col[NAME_COL], y);
      g.drawString(Headings[SCORE_COL],
		   r.x + x_col[SCORE_COL] - bfm.stringWidth(Headings[SCORE_COL]),
		   y);
      g.drawString(Headings[STAGE_COL],
		   r.x + x_col[STAGE_COL] - bfm.stringWidth(Headings[STAGE_COL]),
		   y);
      g.setFont(f);

      y += (bfm.getMaxDescent() + bfm.getLeading() + fm.getMaxAscent());

      for(i=0; i<Names.length; i++)
	{
	  g.drawString(Names[i], r.x + x_col[NAME_COL], y);
	  g.drawString(Scores[i], r.x + x_col[SCORE_COL] -
		       bfm.stringWidth(Scores[i]), y);
	  g.drawString(Stages[i], r.x + x_col[STAGE_COL] -
		       bfm.stringWidth(Stages[i]), y);
	  y += fm.getHeight();
	}

    }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getPreferredSize
 * DESCRIPTION	  :
 *****************************************************************************/
    public Dimension getPreferredSize()
    {
      int h, w, sp;
      Font bf, f;
      FontMetrics bfm, fm;

      f = getFont();
      fm = getFontMetrics(f);
      sp = fm.getMaxAdvance();

      if((Names == null) && (Scores == null) && (Stages == null))
	{
	  h = fm.getHeight();
	  w = fm.stringWidth(no_scores);
	  return(new Dimension((sp << 2) + w, h * 3));
	}

      bf = new Font(f.getName(), f.getStyle()+Font.BOLD, f.getSize());
      bfm = getFontMetrics(bf);
      sp = Math.max(sp, bfm.getMaxAdvance());

      w = x_col[STAGE_COL] + sp;
      h = fm.getLeading() + bfm.getHeight() + (Names.length * fm.getHeight());

      return(new Dimension(w, h));

    }

  }  /* END OF CLASS : MyCanvas */

}  /* END OF CLASS : ScoreWin */


/* END OF FILE : ScoreWin.java */

