/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.manager;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;
import jp.ac.nii.icpc2010.TronException;
import jp.ac.nii.icpc2010.manager.OptionsManager;
import jp.ac.nii.icpc2010.manager.PlayerManager;
import jp.ac.nii.icpc2010.manager.QuoteManager;
import jp.ac.nii.icpc2010.playfield.FieldDirection;
import jp.ac.nii.icpc2010.playfield.PlayField;
import jp.ac.nii.icpc2010.recorder.FileRecorder;
import jp.ac.nii.icpc2010.score.AbstractScore;

public class GameManager
implements Runnable {
    private PlayField _field;
    private PlayerManager _manager;
    private OptionsManager _options;
    private boolean _initialized;

    public GameManager(PlayField field, OptionsManager om) throws TronException {
        this._field = field;
        this._initialized = false;
        this._options = om;
    }

    @Override
    public void run() {
        int startTurn = 0;
        String[] playerNames = new String[this._field.getNumOfPlayers()];
        String recordFile = this._options.getRecordFile();
        FileRecorder recorder = null;
        if (recordFile != null) {
            recorder = new FileRecorder(playerNames, recordFile, this._options);
            if (!this._options.isTournamentMode()) {
                System.out.println("Recording to " + recordFile);
            }
        }
        int i = 0;
        while (i < this._options.getGameRounds()) {
            try {
                if (this._initialized) {
                    this._field.reset(this._options.getLevelName());
                } else {
                    this._field.init(this._options.getLevelName());
                    this._initialized = true;
                }
                this._field.putComment("--- Round " + this._field.getRound() + " starts ---");
                this._manager = i == 0 ? new PlayerManager(this._field, recorder, this._options) : new PlayerManager(this._field, recorder, startTurn, this._options);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
            catch (TronException e) {
                e.printStackTrace();
                System.exit(1);
            }
            this.onePlay();
            startTurn = this._manager.getStartTurn();
            ++i;
        }
        ScorePack[][] result = this.getResult(this._field.getTotalScores());
        double[] score = new double[2];
        this._field.putComment("--- Total result ---");
        int i2 = 0;
        while (i2 < result.length) {
            int j = 0;
            while (j < result[i2].length) {
                this._field.putComment(String.format("%s. Player %d: %.8f", GameManager.toOrderString(i2 + 1), result[i2][j].playerId, result[i2][j].score.getValue()));
                score[result[i2][j].playerId] = result[i2][j].score.getValue();
                ++j;
            }
            ++i2;
        }
        try {
            if (recorder != null) {
                recorder.addPlayerScore(score[0]);
                recorder.addPlayerScore(score[1]);
            }
        }
        catch (TronException e) {
            e.printStackTrace();
            System.exit(1);
        }
        this._manager.finishRecording();
    }

    private void onePlay() {
        while (this._field.isRunning()) {
            long sleepTime;
            long start = System.currentTimeMillis();
            FieldDirection[] inputs = this._manager.getInputs();
            this._field.setKeyPressed(null);
            this._field.update(inputs);
            if (this._options.isTournamentMode() || (sleepTime = this._options.getTurnTimeslot() - (System.currentTimeMillis() - start)) <= 0L) continue;
            try {
                Thread.sleep(sleepTime);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        ScorePack[][] result = this.getResult(this._field.getScores());
        this._field.putComment("--- Round " + this._field.getRound() + " result ---");
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[i].length) {
                this._field.putComment(String.format("%s. Player %d: %.8f", GameManager.toOrderString(i + 1), result[i][j].playerId, result[i][j].score.getValue()));
                ++j;
            }
            ++i;
        }
        int winnerId = result[0][(int)(Math.random() * (double)result[0].length)].playerId;
        int loserId = result[result.length - 1][(int)(Math.random() * (double)result[result.length - 1].length)].playerId;
        QuoteManager.Singleton().setWinner(this._field.getPlayerName(winnerId));
        QuoteManager.Singleton().setLoser(this._field.getPlayerName(loserId));
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String toOrderString(int n) {
        switch (n % 10) {
            case 1: {
                if (n == 11) {
                    return "11th";
                }
                return String.valueOf(n) + "st";
            }
            case 2: {
                return String.valueOf(n) + "nd";
            }
            case 3: {
                return String.valueOf(n) + "rd";
            }
        }
        return String.valueOf(n) + "th";
    }

    private ScorePack[][] getResult(AbstractScore[] scores) {
        Object[] scorePacks = new ScorePack[scores.length];
        int i = 0;
        while (i < scores.length) {
            scorePacks[i] = new ScorePack(i, scores[i]);
            ++i;
        }
        Arrays.sort(scorePacks);
        Vector tmp = new Vector();
        int order = 0;
        AbstractScore curScore = null;
        int i2 = scorePacks.length - 1;
        while (i2 >= 0) {
            AbstractScore score = ((ScorePack)scorePacks[i2]).score;
            if (curScore == null || curScore.compareTo(score) > 0) {
                curScore = score;
                order = scorePacks.length - 1 - i2;
                while (tmp.size() < order + 1) {
                    tmp.add(new LinkedList());
                }
                ((LinkedList)tmp.get(order)).addFirst(scorePacks[i2]);
            } else {
                ((LinkedList)tmp.get(order)).addFirst(scorePacks[i2]);
            }
            --i2;
        }
        ScorePack[][] result = new ScorePack[tmp.size()][];
        int i3 = 0;
        while (i3 < tmp.size()) {
            result[i3] = ((LinkedList)tmp.get(i3)).toArray(new ScorePack[((LinkedList)tmp.get(i3)).size()]);
            ++i3;
        }
        return result;
    }

    private class ScorePack
    implements Comparable<ScorePack> {
        public int playerId;
        public AbstractScore score;

        public ScorePack(int playerId, AbstractScore score) {
            this.playerId = playerId;
            this.score = score;
        }

        @Override
        public int compareTo(ScorePack scorePack) {
            return this.score.compareTo(scorePack.score);
        }
    }
}

